/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.activity;

import java.util.HashSet;
import java.util.Map;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.Call;
import org.asteriskjava.pbx.CallDirection;
import org.asteriskjava.pbx.CallImpl;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.NewChannelListener;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.activities.DialActivity;
import org.asteriskjava.pbx.asterisk.wrap.actions.SetVarAction;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse;
import org.asteriskjava.pbx.internal.activity.ActivityHelper;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.managerAPI.Dial;
import org.asteriskjava.pbx.internal.managerAPI.OriginateResult;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class DialActivityImpl
extends ActivityHelper<DialActivity>
implements DialActivity,
NewChannelListener {
    private static final Log logger = LogFactory.getLog(DialActivityImpl.class);
    private final boolean hideToCallerId;
    private boolean cancelledByOperator;
    private final EndPoint _originating;
    private Channel originatingChannel;
    private final EndPoint _accepting;
    private final CallerID toCallerID;
    private Channel acceptingChannel;
    private CallImpl newCall;
    private Map<String, String> channelVarsToSet;
    private String dialOptions;

    public DialActivityImpl(EndPoint originating, EndPoint accepting, CallerID toCallerID, boolean hideToCallerID, ActivityCallback<DialActivity> listener, Map<String, String> channelVarsToSet, String dialOptions) {
        super("Dial", listener);
        this._originating = originating;
        this._accepting = accepting;
        this.toCallerID = toCallerID;
        this.hideToCallerId = hideToCallerID;
        this.cancelledByOperator = false;
        this.channelVarsToSet = channelVarsToSet;
        this.dialOptions = dialOptions;
        this.startActivity(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doActivity() throws PBXException {
        boolean success = false;
        try (Dial nr = new Dial(this.toCallerID.toString());){
            logger.debug("*******************************************************************************");
            logger.info("***********                    begin dial out                  ****************");
            logger.info("***********               " + this._accepting + "             ****************");
            logger.debug("*******************************************************************************");
            AsteriskSettings profile = PBXFactory.getActiveProfile();
            OriginateResult[] resultChannels = nr.dial(this, this._originating, this._accepting, profile.getManagementContext(), this.toCallerID, this.hideToCallerId, this.channelVarsToSet, this.dialOptions);
            if (resultChannels[0] == null || resultChannels[1] == null) {
                if (!this.cancelledByOperator) {
                    this.setLastException(new PBXException("OperatorEndedCall"));
                    logger.error("dialout to " + this._accepting.getFullyQualifiedName() + " failed.");
                }
            } else {
                this.originatingChannel = resultChannels[0].getChannel();
                this.acceptingChannel = resultChannels[1].getChannel();
                this.newCall = new CallImpl(this.originatingChannel, this.acceptingChannel, CallDirection.OUTBOUND);
                logger.debug("dialout succeeded: dest channel is :" + this.acceptingChannel);
                if (!this.validateChannel(this.acceptingChannel)) {
                    this.setLastException(new PBXException("dialed extension hungup unexpectedly"));
                    logger.error("dialed extension hungup unexpectedly");
                } else {
                    success = true;
                }
            }
        }
        finally {
            if (!success) {
                this.hangup();
            }
        }
        return success;
    }

    private void hangup() {
        try {
            PBX pbx = PBXFactory.getActivePBX();
            if (this.acceptingChannel != null) {
                logger.warn("Hanging up");
                pbx.hangup(this.acceptingChannel);
            }
            if (this.originatingChannel != null) {
                logger.warn("Hanging up");
                pbx.hangup(this.originatingChannel);
            }
        }
        catch (Exception e) {
            logger.error(e, e);
        }
    }

    @Override
    public void markCancelled() {
        this.cancelledByOperator = true;
    }

    @Override
    public Channel getOriginatingChannel() {
        return this.originatingChannel;
    }

    @Override
    public Channel getAcceptingChannel() {
        return this.acceptingChannel;
    }

    @Override
    public EndPoint getOriginatingEndPoint() {
        return this._originating;
    }

    @Override
    public EndPoint getAcceptingEndPoint() {
        return this._accepting;
    }

    @Override
    public void channelUpdate(Channel channel) {
        if (channel.sameEndPoint(this._accepting)) {
            this.acceptingChannel = channel;
        }
        if (channel.sameEndPoint(this._originating)) {
            this.originatingChannel = channel;
        }
        super.progess(this, "Channel for " + channel.getEndPoint().getSIPSimpleName() + " is now up.");
    }

    @Override
    public boolean validateChannel(Channel channel) {
        boolean ret = false;
        SetVarAction var = new SetVarAction(channel, "testState", "1");
        ManagerResponse response = null;
        try {
            AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
            response = pbx.sendAction(var, 500);
        }
        catch (Exception e) {
            logger.debug(e, e);
            logger.error("getVariable: " + e);
        }
        if (response != null && response.getAttribute("Response").compareToIgnoreCase("success") == 0) {
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean cancelledByOperator() {
        return this.cancelledByOperator;
    }

    @Override
    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        return required;
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.NORMAL;
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
    }

    @Override
    public Call getNewCall() {
        return this.newCall;
    }
}

