/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.managerAPI;

import java.util.HashMap;
import org.asteriskjava.pbx.AgiChannelActivityAction;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.agi.AgiChannelActivityDial;
import org.asteriskjava.pbx.agi.AgiChannelActivityVoicemail;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class RedirectCall {
    private static final Log logger = LogFactory.getLog(RedirectCall.class);

    public static void setAutoAnswer(HashMap<String, String> myVars, AsteriskSettings settings) {
        myVars.put(AsteriskPBX.getSIPADDHeader(false, true), settings.getAutoAnswer());
        logger.debug("auto answer");
    }

    public boolean redirect(Channel channel, EndPoint targetEndPoint, String context, boolean autoAnswer) throws PBXException {
        String sipHeader = "";
        if (autoAnswer) {
            sipHeader = PBXFactory.getActiveProfile().getAutoAnswer();
        }
        this.redirect(channel, new AgiChannelActivityDial(targetEndPoint.getFullyQualifiedName(), sipHeader));
        logger.debug("redirected " + channel + " to " + targetEndPoint);
        return true;
    }

    public boolean redirectToVoicemail(Channel channel, EndPoint mailbox) throws PBXException {
        this.redirect(channel, new AgiChannelActivityVoicemail(mailbox.getFullyQualifiedName()));
        return true;
    }

    public void redirect(Channel channel, AgiChannelActivityAction channelActivityHold) throws PBXException {
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        if (!pbx.moveChannelToAgi(channel)) {
            throw new PBXException("Channel: " + channel + " couldn't be moved to agi");
        }
        if (!pbx.waitForChannelToQuiescent(channel, 3000)) {
            throw new PBXException("Channel: " + channel + " cannot be redirected as it is still in transition.");
        }
        channel.setCurrentActivityAction(channelActivityHold);
    }
}

