/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.ClockCacheItem;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongKeyClockCache<E extends ClockCacheItem> {
    private long[] _keys;
    private E[] _values;
    private int _capacity;
    private int _size;
    private int _mask;
    private int _clock;

    public LongKeyClockCache(int initialCapacity) {
        int capacity;
        for (capacity = 16; capacity < 2 * initialCapacity; capacity *= 2) {
        }
        this._keys = new long[capacity];
        this._values = new ClockCacheItem[capacity];
        this._mask = capacity - 1;
        this._capacity = initialCapacity;
    }

    public int size() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int i;
        ArrayList<E> listeners = null;
        LongKeyClockCache longKeyClockCache = this;
        synchronized (longKeyClockCache) {
            for (int i2 = 0; i2 < this._values.length; ++i2) {
                E item = this._values[i2];
                if (item != null) {
                    if (listeners == null) {
                        listeners = new ArrayList<E>();
                    }
                    listeners.add(item);
                }
                this._values[i2] = null;
            }
            this._size = 0;
        }
        int n = i = listeners == null ? -1 : listeners.size() - 1;
        while (i >= 0) {
            ClockCacheItem listener = (ClockCacheItem)listeners.get(i);
            listener.removeEvent();
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(long key) {
        int hash = this.getHash(key);
        LongKeyClockCache longKeyClockCache = this;
        synchronized (longKeyClockCache) {
            for (int count = this._size + 1; count > 0; --count) {
                E item = this._values[hash];
                if (item == null) {
                    return null;
                }
                if (this._keys[hash] == key) {
                    item.setUsed();
                    return item;
                }
                hash = hash + 1 & this._mask;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E put(long key, E value) {
        this.freeSpace();
        E item = this.putImpl(key, value);
        if (3 * this._values.length <= 4 * this._size) {
            LongKeyClockCache longKeyClockCache = this;
            synchronized (longKeyClockCache) {
                long[] oldKeys = this._keys;
                E[] oldValues = this._values;
                this._keys = new long[2 * oldKeys.length];
                this._values = (ClockCacheItem[])new Object[2 * oldValues.length];
                this._mask = this._values.length - 1;
                this._size = 0;
                for (int i = oldValues.length - 1; i >= 0; --i) {
                    long oldKey = oldKeys[i];
                    E oldValue = oldValues[i];
                    if (oldValue == null) continue;
                    this.putImpl(oldKey, oldValue);
                }
            }
        }
        if (item != null) {
            item.removeEvent();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E putImpl(long key, E value) {
        ClockCacheItem item = null;
        int hash = this.getHash(key);
        LongKeyClockCache longKeyClockCache = this;
        synchronized (longKeyClockCache) {
            for (int count = this._size + 1; count > 0; --count) {
                item = (ClockCacheItem)this._values[hash];
                if (item == null) {
                    this._keys[hash] = key;
                    this._values[hash] = value;
                    ++this._size;
                    return null;
                }
                if (this._keys[hash] == key) {
                    item.setUsed();
                    this._values[hash] = value;
                    return (E)item;
                }
                hash = hash + 1 & this._mask;
            }
        }
        throw new IllegalStateException();
    }

    private void freeSpace() {
        int i = this._size - this._capacity;
        if (i > 16) {
            i = 16;
        }
        while (i-- > 0 && this.removeItem()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItem() {
        int length = this._values.length;
        int clock = this._clock;
        ClockCacheItem item = null;
        for (int i = 0; i < length; ++i) {
            LongKeyClockCache longKeyClockCache = this;
            synchronized (longKeyClockCache) {
                item = this._values[clock];
                if (item != null && !item.isUsed()) {
                    this._clock = clock;
                    this._values[clock] = null;
                    --this._size;
                    this.refillEntries(clock);
                    break;
                }
            }
            if (item != null) {
                item.clearUsed();
            }
            clock = (clock + 1) % length;
            item = null;
        }
        this._clock = clock;
        if (item != null) {
            item.removeEvent();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClockCacheItem remove(long key) {
        int count;
        int hash = this.getHash(key);
        ClockCacheItem item = null;
        LongKeyClockCache longKeyClockCache = this;
        synchronized (longKeyClockCache) {
            for (count = this._size + 1; count > 0; --count) {
                item = (ClockCacheItem)this._values[hash];
                if (item == null) {
                    return null;
                }
                if (this._keys[hash] == key) {
                    this._values[hash] = null;
                    --this._size;
                    this.refillEntries(hash);
                    break;
                }
                hash = hash + 1 & this._mask;
            }
        }
        if (count < 0) {
            throw new RuntimeException("internal cache error");
        }
        item.removeEvent();
        return item;
    }

    private void refillEntries(int hash) {
        for (int count = this._size; count >= 0; --count) {
            if (this._values[hash = hash + 1 & this._mask] == null) {
                return;
            }
            this.refillEntry(hash);
        }
    }

    private void refillEntry(int baseHash) {
        long key = this._keys[baseHash];
        E value = this._values[baseHash];
        this._values[baseHash] = null;
        int hash = this.getHash(key);
        for (int count = this._size; count >= 0; --count) {
            if (this._values[hash] == null) {
                this._keys[hash] = key;
                this._values[hash] = value;
                return;
            }
            hash = hash + 1 & this._mask;
        }
    }

    private int getHash(long key) {
        long hash = key;
        hash = hash * 25214903917L + 11L + (hash >>> 32) * 137L;
        return (int)hash & this._mask;
    }
}

