/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.FieldVarGetExpr;
import com.caucho.util.L10N;

public class ThisFieldVarGetExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(FieldVarGetExpr.class);
    protected final Expr _nameExpr;

    public ThisFieldVarGetExpr(Location location, Expr nameExpr) {
        super(location);
        this._nameExpr = nameExpr;
    }

    public ThisFieldVarGetExpr(Expr nameExpr) {
        this._nameExpr = nameExpr;
    }

    public Value evalArg(Env env) {
        Value value = env.getThis();
        return value.getThisFieldArg(env, this._nameExpr.evalStringValue(env));
    }

    public Value evalRef(Env env) {
        Value value = env.getThis();
        return value.getThisFieldRef(env, this._nameExpr.evalStringValue(env));
    }

    public Value eval(Env env) {
        Value obj = env.getThis();
        return obj.getThisField(env, this._nameExpr.evalStringValue(env));
    }

    public void evalAssign(Env env, Value value) {
        Value obj = env.getThis();
        obj.putThisField(env, this._nameExpr.evalStringValue(env), value);
    }

    public Value evalArray(Env env) {
        Value obj = env.getThis();
        return obj.getThisFieldArray(env, this._nameExpr.evalStringValue(env));
    }

    public Value evalObject(Env env) {
        Value obj = env.getThis();
        return obj.getThisFieldObject(env, this._nameExpr.evalStringValue(env));
    }

    public void evalUnset(Env env) {
        Value obj = env.getThis();
        obj.unsetThisField(this._nameExpr.evalStringValue(env));
    }

    public String toString() {
        return "$this->{" + this._nameExpr + "}";
    }
}

