/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.QueueMemberState;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskQueueEntryImpl;
import org.asteriskjava.live.internal.AsteriskQueueImpl;
import org.asteriskjava.live.internal.AsteriskQueueMemberImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.ChannelManager;
import org.asteriskjava.manager.EventTimeoutException;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.action.QueueStatusAction;
import org.asteriskjava.manager.event.JoinEvent;
import org.asteriskjava.manager.event.LeaveEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.QueueEntryEvent;
import org.asteriskjava.manager.event.QueueMemberAddedEvent;
import org.asteriskjava.manager.event.QueueMemberEvent;
import org.asteriskjava.manager.event.QueueMemberPausedEvent;
import org.asteriskjava.manager.event.QueueMemberPenaltyEvent;
import org.asteriskjava.manager.event.QueueMemberRemovedEvent;
import org.asteriskjava.manager.event.QueueMemberStatusEvent;
import org.asteriskjava.manager.event.QueueParamsEvent;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class QueueManager {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AsteriskServerImpl server;
    private final ChannelManager channelManager;
    private boolean queuesMonitorForced = false;
    private long queueMonitorLastTimeReloaded;
    private long queuesMonitorLeaseTime = 1000L;
    private final Map<String, AsteriskQueueImpl> queuesLRU = new LinkedHashMap<String, AsteriskQueueImpl>();

    QueueManager(AsteriskServerImpl server, ChannelManager channelManager) {
        this.server = server;
        this.channelManager = channelManager;
    }

    void initialize() throws ManagerCommunicationException {
        ResponseEvents re;
        try {
            re = this.server.sendEventGeneratingAction(new QueueStatusAction());
        }
        catch (ManagerCommunicationException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof EventTimeoutException) {
                re = ((EventTimeoutException)throwable).getPartialResult();
            }
            throw e;
        }
        for (ManagerEvent managerEvent : re.getEvents()) {
            if (managerEvent instanceof QueueParamsEvent) {
                this.handleQueueParamsEvent((QueueParamsEvent)managerEvent);
                continue;
            }
            if (managerEvent instanceof QueueMemberEvent) {
                this.handleQueueMemberEvent((QueueMemberEvent)managerEvent);
                continue;
            }
            if (!(managerEvent instanceof QueueEntryEvent)) continue;
            this.handleQueueEntryEvent((QueueEntryEvent)managerEvent);
        }
    }

    void updateQueue(String queue) throws ManagerCommunicationException {
        ResponseEvents re;
        try {
            QueueStatusAction queueStatusAction = new QueueStatusAction();
            queueStatusAction.setQueue(queue);
            re = this.server.sendEventGeneratingAction(queueStatusAction);
        }
        catch (ManagerCommunicationException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof EventTimeoutException) {
                re = ((EventTimeoutException)throwable).getPartialResult();
            }
            throw e;
        }
        for (ManagerEvent managerEvent : re.getEvents()) {
            if (managerEvent instanceof QueueParamsEvent) {
                this.handleQueueParamsEvent((QueueParamsEvent)managerEvent);
                continue;
            }
            if (managerEvent instanceof QueueMemberEvent) {
                this.handleQueueMemberEvent((QueueMemberEvent)managerEvent);
                continue;
            }
            if (!(managerEvent instanceof QueueEntryEvent)) continue;
            this.handleQueueEntryEvent((QueueEntryEvent)managerEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnected() {
        Map<String, AsteriskQueueImpl> map = this.queuesLRU;
        synchronized (map) {
            for (AsteriskQueueImpl queue : this.queuesLRU.values()) {
                queue.cancelServiceLevelTimer();
            }
            this.queuesLRU.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<AsteriskQueue> getQueues() {
        ArrayList<AsteriskQueue> copy;
        this.refreshQueuesIfForced();
        Map<String, AsteriskQueueImpl> map = this.queuesLRU;
        synchronized (map) {
            copy = new ArrayList<AsteriskQueue>(this.queuesLRU.values());
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsteriskQueue> getQueuesUpdatedAfter(Date date) {
        this.refreshQueuesIfForced();
        ArrayList<AsteriskQueue> copy = new ArrayList<AsteriskQueue>();
        Map<String, AsteriskQueueImpl> map = this.queuesLRU;
        synchronized (map) {
            Map.Entry entry;
            AsteriskQueueImpl astQueue;
            ArrayList<Map.Entry<String, AsteriskQueueImpl>> list = new ArrayList<Map.Entry<String, AsteriskQueueImpl>>(this.queuesLRU.entrySet());
            ListIterator iter = list.listIterator(list.size());
            while (iter.hasPrevious() && (astQueue = (AsteriskQueueImpl)(entry = (Map.Entry)iter.previous()).getValue()).getLastUpdateMillis() > date.getTime()) {
                copy.add(astQueue);
            }
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addQueue(AsteriskQueueImpl queue) {
        Map<String, AsteriskQueueImpl> map = this.queuesLRU;
        synchronized (map) {
            this.queuesLRU.put(queue.getName(), queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueueParamsEvent(QueueParamsEvent event) {
        String name = event.getQueue();
        Integer max = event.getMax();
        String strategy = event.getStrategy();
        Integer serviceLevel = event.getServiceLevel();
        Integer weight = event.getWeight();
        Integer calls = event.getCalls();
        Integer holdTime = event.getHoldTime();
        Integer talkTime = event.getTalkTime();
        Integer completed = event.getCompleted();
        Integer abandoned = event.getAbandoned();
        Double serviceLevelPerf = event.getServiceLevelPerf();
        AsteriskQueueImpl queue = this.getInternalQueueByName(name);
        if (queue == null) {
            queue = new AsteriskQueueImpl(this.server, name, max, strategy, serviceLevel, weight, calls, holdTime, talkTime, completed, abandoned, serviceLevelPerf);
            this.logger.info("Adding new queue " + queue);
            this.addQueue(queue);
        } else {
            AsteriskQueueImpl asteriskQueueImpl = queue;
            synchronized (asteriskQueueImpl) {
                Map<String, AsteriskQueueImpl> map = this.queuesLRU;
                synchronized (map) {
                    if (queue.setMax(max) | queue.setServiceLevel(serviceLevel) | queue.setWeight(weight) | queue.setCalls(calls) | queue.setHoldTime(holdTime) | queue.setTalkTime(talkTime) | queue.setCompleted(completed) | queue.setAbandoned(abandoned) | queue.setServiceLevelPerf(serviceLevelPerf)) {
                        this.queuesLRU.remove(queue.getName());
                        this.queuesLRU.put(queue.getName(), queue);
                    }
                }
            }
        }
    }

    private void handleQueueMemberEvent(QueueMemberEvent event) {
        AsteriskQueueImpl queue = this.getInternalQueueByName(event.getQueue());
        if (queue == null) {
            this.logger.error("Ignored QueueEntryEvent for unknown queue " + event.getQueue());
            return;
        }
        AsteriskQueueMemberImpl member = queue.getMember(event.getInterface());
        if (member == null) {
            member = new AsteriskQueueMemberImpl(this.server, queue, event.getInterface(), QueueMemberState.valueOf(event.getStatus()), event.getPaused(), event.getPenalty(), event.getMembership(), event.getCallsTaken(), event.getLastCall());
            queue.addMember(member);
        } else {
            this.manageQueueMemberChange(queue, member, event);
        }
    }

    private void manageQueueMemberChange(AsteriskQueueImpl queue, AsteriskQueueMemberImpl member, QueueMemberEvent event) {
        if (member.stateChanged(QueueMemberState.valueOf(event.getStatus())) | member.pausedChanged(event.getPaused()) | member.penaltyChanged(event.getPenalty()) | member.callsTakenChanged(event.getCallsTaken()) | member.lastCallChanged(event.getLastCall())) {
            queue.stampLastUpdate();
        }
    }

    private void handleQueueEntryEvent(QueueEntryEvent event) {
        AsteriskQueueImpl queue = this.getInternalQueueByName(event.getQueue());
        AsteriskChannelImpl channel = this.channelManager.getChannelImplByName(event.getChannel());
        if (queue == null) {
            this.logger.error("Ignored QueueEntryEvent for unknown queue " + event.getQueue());
            return;
        }
        if (channel == null) {
            this.logger.error("Ignored QueueEntryEvent for unknown channel " + event.getChannel());
            return;
        }
        int reportedPosition = event.getPosition();
        queue.createNewEntry(channel, reportedPosition, event.getDateReceived());
    }

    void handleJoinEvent(JoinEvent event) {
        AsteriskQueueImpl queue = this.getInternalQueueByName(event.getQueue());
        AsteriskChannelImpl channel = this.channelManager.getChannelImplByName(event.getChannel());
        if (queue == null) {
            this.logger.error("Ignored JoinEvent for unknown queue " + event.getQueue());
            return;
        }
        if (channel == null) {
            this.logger.error("Ignored JoinEvent for unknown channel " + event.getChannel());
            return;
        }
        int reportedPosition = event.getPosition();
        queue.createNewEntry(channel, reportedPosition, event.getDateReceived());
    }

    void handleLeaveEvent(LeaveEvent event) {
        AsteriskQueueImpl queue = this.getInternalQueueByName(event.getQueue());
        AsteriskChannelImpl channel = this.channelManager.getChannelImplByName(event.getChannel());
        if (queue == null) {
            this.logger.error("Ignored LeaveEvent for unknown queue " + event.getQueue());
            return;
        }
        if (channel == null) {
            this.logger.error("Ignored LeaveEvent for unknown channel " + event.getChannel());
            return;
        }
        AsteriskQueueEntryImpl existingQueueEntry = queue.getEntry(event.getChannel());
        if (existingQueueEntry == null) {
            this.logger.error("Ignored leave event for non existing queue entry in queue " + event.getQueue() + " for channel " + event.getChannel());
            return;
        }
        queue.removeEntry(existingQueueEntry, event.getDateReceived());
    }

    void handleQueueMemberStatusEvent(QueueMemberStatusEvent event) {
        AsteriskQueueImpl queue = this.getInternalQueueByName(event.getQueue());
        if (queue == null) {
            this.logger.error("Ignored QueueMemberStatusEvent for unknown queue " + event.getQueue());
            return;
        }
        AsteriskQueueMemberImpl member = queue.getMemberByLocation(event.getInterface());
        if (member == null) {
            this.logger.error("Ignored QueueMemberStatusEvent for unknown member " + event.getInterface());
            return;
        }
        this.manageQueueMemberChange(queue, member, event);
        queue.fireMemberStateChanged(member);
    }

    void handleQueueMemberPausedEvent(QueueMemberPausedEvent event) {
        AsteriskQueueImpl queue = this.getInternalQueueByName(event.getQueue());
        if (queue == null) {
            this.logger.error("Ignored QueueMemberPausedEvent for unknown queue " + event.getQueue());
            return;
        }
        AsteriskQueueMemberImpl member = queue.getMemberByLocation(event.getInterface());
        if (member == null) {
            this.logger.error("Ignored QueueMemberPausedEvent for unknown member " + event.getInterface());
            return;
        }
        member.pausedChanged(event.getPaused());
    }

    void handleQueueMemberPenaltyEvent(QueueMemberPenaltyEvent event) {
        AsteriskQueueImpl queue = this.getInternalQueueByName(event.getQueue());
        if (queue == null) {
            this.logger.error("Ignored QueueMemberStatusEvent for unknown queue " + event.getQueue());
            return;
        }
        AsteriskQueueMemberImpl member = queue.getMemberByLocation(event.getLocation());
        if (member == null) {
            this.logger.error("Ignored QueueMemberStatusEvent for unknown member " + event.getLocation());
            return;
        }
        member.penaltyChanged(event.getPenalty());
    }

    AsteriskQueueImpl getQueueByName(String queueName) {
        this.refreshQueueIfForced(queueName);
        AsteriskQueueImpl queue = this.getInternalQueueByName(queueName);
        if (queue == null) {
            this.logger.error("Requested queue '" + queueName + "' not found!");
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsteriskQueueImpl getInternalQueueByName(String queueName) {
        AsteriskQueueImpl queue;
        Map<String, AsteriskQueueImpl> map = this.queuesLRU;
        synchronized (map) {
            queue = this.queuesLRU.get(queueName);
        }
        return queue;
    }

    private void refreshQueueIfForced(String queueName) {
        if (this.queuesMonitorForced) {
            this.updateQueue(queueName);
        }
    }

    private void refreshQueuesIfForced() {
        if (this.queuesMonitorForced && System.currentTimeMillis() - this.queueMonitorLastTimeReloaded > this.queuesMonitorLeaseTime) {
            this.initialize();
            this.queueMonitorLastTimeReloaded = System.currentTimeMillis();
        }
    }

    public void handleQueueMemberAddedEvent(QueueMemberAddedEvent event) {
        AsteriskQueueImpl queue = this.getInternalQueueByName(event.getQueue());
        if (queue == null) {
            this.logger.error("Ignored QueueMemberAddedEvent for unknown queue " + event.getQueue());
            return;
        }
        AsteriskQueueMemberImpl member = queue.getMember(event.getInterface());
        if (member == null) {
            member = new AsteriskQueueMemberImpl(this.server, queue, event.getInterface(), QueueMemberState.valueOf(event.getStatus()), event.getPaused(), event.getPenalty(), event.getMembership(), event.getCallsTaken(), event.getLastCall());
        }
        queue.addMember(member);
    }

    public void handleQueueMemberRemovedEvent(QueueMemberRemovedEvent event) {
        AsteriskQueueImpl queue = this.getInternalQueueByName(event.getQueue());
        if (queue == null) {
            this.logger.error("Ignored QueueMemberRemovedEvent for unknown queue " + event.getQueue());
            return;
        }
        AsteriskQueueMemberImpl member = queue.getMember(event.getInterface());
        if (member == null) {
            this.logger.error("Ignored QueueMemberRemovedEvent for unknown agent name: " + event.getMemberName() + " location: " + event.getInterface() + " queue: " + event.getQueue());
            return;
        }
        queue.removeMember(member);
    }

    public void forceQueuesMonitor(boolean force) {
        this.queuesMonitorForced = force;
    }

    public boolean isQueuesMonitorForced() {
        return this.queuesMonitorForced;
    }
}

