/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal.backwardsCompatibility.bridge;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.manager.event.BridgeEnterEvent;

public class BridgeEnterEventComparator
implements Comparator<BridgeEnterEvent> {
    private static final Pattern UNIQUE_ID_PATTERN = Pattern.compile("([0-9]+)\\.([0-9]+)$");

    @Override
    public int compare(BridgeEnterEvent o1, BridgeEnterEvent o2) {
        Matcher uniqueId1Matcher = UNIQUE_ID_PATTERN.matcher(o1.getUniqueId());
        Matcher uniqueId2Matcher = UNIQUE_ID_PATTERN.matcher(o2.getUniqueId());
        boolean find1 = uniqueId1Matcher.find();
        boolean find2 = uniqueId2Matcher.find();
        if (find1 && find2) {
            long epochtime1 = Long.valueOf(uniqueId1Matcher.group(1));
            long epochtime2 = Long.valueOf(uniqueId2Matcher.group(1));
            int serial1 = Integer.valueOf(uniqueId1Matcher.group(2));
            int serial2 = Integer.valueOf(uniqueId2Matcher.group(2));
            return epochtime1 == epochtime2 ? Integer.compare(serial1, serial2) : Long.compare(epochtime1, epochtime2);
        }
        if (!find1 && !find2) {
            return 0;
        }
        return find1 ? 1 : -1;
    }
}

