/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment.routines;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.biojava.nbio.core.alignment.template.AlignedSequence;

public class AlignerHelper {
    public static int addAnchors(Cut[] cuts, int[] scores, boolean addScore, int[] anchors) {
        int zMax = 0;
        int subscore = scores[0];
        for (int z = 1; z < scores.length; ++z) {
            if (scores[z] <= subscore) continue;
            zMax = z;
            subscore = scores[z];
        }
        for (Cut c : cuts) {
            anchors[c.getQueryIndex()] = c.getTargetIndex(zMax);
        }
        return addScore ? subscore : 0;
    }

    public static Cut[] getCuts(int k, Subproblem subproblem, int[] dim, boolean anchor0) {
        Cut[] cuts;
        int m = subproblem.getQueryEndIndex() - subproblem.getQueryStartIndex() - (anchor0 ? 1 : 0);
        if (k < m) {
            cuts = new Cut[k];
            int firstCutIndex = subproblem.getQueryStartIndex() + (anchor0 ? 1 : 0);
            for (int i = 0; i < k; ++i) {
                cuts[i] = new Cut(firstCutIndex + i * (m - 1) / (k - 1), dim);
            }
        } else {
            cuts = new Cut[m];
            int i = 0;
            int x = subproblem.getQueryStartIndex() + (anchor0 ? 1 : 0);
            while (i < m) {
                cuts[i] = new Cut(x, dim);
                ++i;
                ++x;
            }
        }
        return cuts;
    }

    public static void setCuts(int x, Subproblem subproblem, Last[][] pointers, Cut[] cuts) {
        for (Cut c : cuts) {
            c.update(x, subproblem, pointers);
        }
    }

    public static Last[] setScorePoint(int x, int y, int gop, int gep, int sub, int[][][] scores) {
        Last[] pointers = new Last[3];
        if (scores[x - 1][y - 1][1] >= scores[x - 1][y - 1][0] && scores[x - 1][y - 1][1] >= scores[x - 1][y - 1][2]) {
            scores[x][y][0] = scores[x - 1][y - 1][1] + sub;
            pointers[0] = Last.DELETION;
        } else if (scores[x - 1][y - 1][0] >= scores[x - 1][y - 1][2]) {
            scores[x][y][0] = scores[x - 1][y - 1][0] + sub;
            pointers[0] = Last.SUBSTITUTION;
        } else {
            scores[x][y][0] = scores[x - 1][y - 1][2] + sub;
            pointers[0] = Last.INSERTION;
        }
        if (scores[x - 1][y][1] >= scores[x - 1][y][0] + gop) {
            scores[x][y][1] = scores[x - 1][y][1] + gep;
            pointers[1] = Last.DELETION;
        } else {
            scores[x][y][1] = scores[x - 1][y][0] + gop + gep;
            pointers[1] = Last.SUBSTITUTION;
        }
        if (scores[x][y - 1][0] + gop >= scores[x][y - 1][2]) {
            scores[x][y][2] = scores[x][y - 1][0] + gop + gep;
            pointers[2] = Last.SUBSTITUTION;
        } else {
            scores[x][y][2] = scores[x][y - 1][2] + gep;
            pointers[2] = Last.INSERTION;
        }
        return pointers;
    }

    public static Last setScorePoint(int x, int y, int gep, int sub, int[][][] scores) {
        int d = scores[x - 1][y][0] + gep;
        int i = scores[x][y - 1][0] + gep;
        int s = scores[x - 1][y - 1][0] + sub;
        if (d >= s && d >= i) {
            scores[x][y][0] = d;
            return Last.DELETION;
        }
        if (s >= i) {
            scores[x][y][0] = s;
            return Last.SUBSTITUTION;
        }
        scores[x][y][0] = i;
        return Last.INSERTION;
    }

    public static Last[][] setScoreVector(int x, Subproblem subproblem, int gop, int gep, int[] subs, boolean storing, int[][][] scores) {
        return AlignerHelper.setScoreVector(x, subproblem.getQueryStartIndex(), subproblem.getTargetStartIndex(), subproblem.getTargetEndIndex(), gop, gep, subs, storing, scores, subproblem.isStartAnchored());
    }

    public static Last[][] setScoreVector(int x, int xb, int yb, int ye, int gop, int gep, int[] subs, boolean storing, int[][][] scores, boolean startAnchored) {
        Last[][] pointers = new Last[ye + 1][];
        int min = Integer.MIN_VALUE - gop - gep;
        AlignerHelper.ensureScoringMatrixColumn(x, storing, scores);
        if (x == xb) {
            int n = gop;
            scores[xb][yb][2] = n;
            scores[xb][yb][1] = n;
            pointers[yb] = new Last[]{null, null, null};
            if (startAnchored) {
                int subproblemStartingScore;
                assert (xb > 0 && yb > 0);
                scores[xb][yb][0] = subproblemStartingScore = scores[xb - 1][yb - 1][0] + subs[yb];
                scores[xb][yb][1] = subproblemStartingScore + gop;
                scores[xb][yb][2] = subproblemStartingScore + gop;
                pointers[yb] = new Last[]{Last.SUBSTITUTION, Last.SUBSTITUTION, Last.SUBSTITUTION};
            }
            Last[] insertion = new Last[]{null, null, Last.INSERTION};
            for (int y = yb + 1; y <= ye; ++y) {
                int n2 = min;
                scores[xb][y][1] = n2;
                scores[xb][y][0] = n2;
                scores[xb][y][2] = scores[xb][y - 1][2] + gep;
                pointers[y] = insertion;
            }
        } else {
            int n = min;
            scores[x][yb][2] = n;
            scores[x][yb][0] = n;
            scores[x][yb][1] = scores[x - 1][yb][1] + gep;
            pointers[yb] = new Last[]{null, Last.DELETION, null};
            for (int y = yb + 1; y <= ye; ++y) {
                pointers[y] = AlignerHelper.setScorePoint(x, y, gop, gep, subs[y], scores);
            }
        }
        return pointers;
    }

    public static Last[][] setScoreVector(int x, Subproblem subproblem, int gep, int[] subs, boolean storing, int[][][] scores) {
        return AlignerHelper.setScoreVector(x, subproblem.getQueryStartIndex(), subproblem.getTargetStartIndex(), subproblem.getTargetEndIndex(), gep, subs, storing, scores, subproblem.isStartAnchored());
    }

    public static Last[][] setScoreVector(int x, int xb, int yb, int ye, int gep, int[] subs, boolean storing, int[][][] scores, boolean startAnchored) {
        Last[][] pointers = new Last[ye + 1][1];
        AlignerHelper.ensureScoringMatrixColumn(x, storing, scores);
        if (x == xb) {
            if (startAnchored) {
                assert (xb > 0 && yb > 0);
                scores[xb][yb][0] = scores[xb - 1][yb - 1][0] + subs[yb];
                pointers[yb][0] = Last.SUBSTITUTION;
            }
            for (int y = yb + 1; y <= ye; ++y) {
                scores[xb][y][0] = scores[xb][y - 1][0] + gep;
                pointers[y][0] = Last.INSERTION;
            }
        } else {
            scores[x][yb][0] = scores[x - 1][yb][0] + gep;
            pointers[yb][0] = Last.DELETION;
            for (int y = yb + 1; y <= ye; ++y) {
                pointers[y][0] = AlignerHelper.setScorePoint(x, y, gep, subs[y], scores);
            }
        }
        return pointers;
    }

    public static Last[][] setScoreVector(int x, int gop, int gep, int[] subs, boolean storing, int[][][] scores, int[] xyMax, int score) {
        return AlignerHelper.setScoreVector(x, 0, 0, scores[0].length - 1, gop, gep, subs, storing, scores, xyMax, score);
    }

    public static Last[][] setScoreVector(int x, int xb, int yb, int ye, int gop, int gep, int[] subs, boolean storing, int[][][] scores, int[] xyMax, int score) {
        Last[][] pointers;
        AlignerHelper.ensureScoringMatrixColumn(x, storing, scores);
        if (x == xb) {
            pointers = new Last[ye + 1][scores[0][0].length];
        } else {
            pointers = new Last[ye + 1][];
            pointers[0] = new Last[scores[0][0].length];
            for (int y = 1; y < scores[0].length; ++y) {
                pointers[y] = AlignerHelper.setScorePoint(x, y, gop, gep, subs[y], scores);
                for (int z = 0; z < scores[0][0].length; ++z) {
                    if (scores[x][y][z] > 0) continue;
                    scores[x][y][z] = 0;
                    pointers[y][z] = null;
                }
                if (scores[x][y][0] <= score) continue;
                xyMax[0] = x;
                xyMax[1] = y;
                score = scores[x][y][0];
            }
        }
        return pointers;
    }

    public static Last[][] setScoreVector(int x, int gep, int[] subs, boolean storing, int[][][] scores, int[] xyMax, int score) {
        return AlignerHelper.setScoreVector(x, 0, 0, scores[0].length - 1, gep, subs, storing, scores, xyMax, score);
    }

    public static Last[][] setScoreVector(int x, int xb, int yb, int ye, int gep, int[] subs, boolean storing, int[][][] scores, int[] xyMax, int score) {
        Last[][] pointers;
        AlignerHelper.ensureScoringMatrixColumn(x, storing, scores);
        if (x == xb) {
            pointers = new Last[ye + 1][1];
        } else {
            pointers = new Last[ye + 1][1];
            pointers[0] = new Last[1];
            for (int y = 1; y < scores[x].length; ++y) {
                pointers[y][0] = AlignerHelper.setScorePoint(x, y, gep, subs[y], scores);
                if (scores[x][y][0] <= 0) {
                    scores[x][y][0] = 0;
                    pointers[y][0] = null;
                    continue;
                }
                if (scores[x][y][0] <= score) continue;
                xyMax[0] = x;
                xyMax[1] = y;
                score = scores[x][y][0];
            }
        }
        return pointers;
    }

    private static void ensureScoringMatrixColumn(int x, boolean storingFullMatrix, int[][][] scores) {
        if (!storingFullMatrix && x > 1) {
            scores[x] = scores[x - 2];
        }
    }

    public static int[] setSteps(Last[][][] traceback, boolean local, int[] xyMax, Last last, List<AlignedSequence.Step> sx, List<AlignedSequence.Step> sy) {
        boolean linear;
        int x = xyMax[0];
        int y = xyMax[1];
        boolean bl = linear = traceback[x][y].length == 1;
        while (local ? (linear ? last : traceback[x][y][last.ordinal()]) != null : x > 0 || y > 0) {
            switch (last) {
                case DELETION: {
                    sx.add(AlignedSequence.Step.COMPOUND);
                    sy.add(AlignedSequence.Step.GAP);
                    last = linear ? traceback[--x][y][0] : traceback[x--][y][1];
                    break;
                }
                case SUBSTITUTION: {
                    sx.add(AlignedSequence.Step.COMPOUND);
                    sy.add(AlignedSequence.Step.COMPOUND);
                    last = linear ? traceback[--x][--y][0] : traceback[x--][y--][0];
                    break;
                }
                case INSERTION: {
                    sx.add(AlignedSequence.Step.GAP);
                    sy.add(AlignedSequence.Step.COMPOUND);
                    last = linear ? traceback[x][--y][0] : traceback[x][y--][2];
                }
            }
        }
        Collections.reverse(sx);
        Collections.reverse(sy);
        return new int[]{x, y};
    }

    public static int[] setSteps(Last[][][] traceback, int[][][] scores, List<AlignedSequence.Step> sx, List<AlignedSequence.Step> sy) {
        boolean linear;
        int xMax = scores.length - 1;
        int yMax = scores[xMax].length - 1;
        boolean bl = linear = traceback[xMax][yMax].length == 1;
        Last last = linear ? traceback[xMax][yMax][0] : (scores[xMax][yMax][1] > scores[xMax][yMax][0] && scores[xMax][yMax][1] > scores[xMax][yMax][2] ? Last.DELETION : (scores[xMax][yMax][0] > scores[xMax][yMax][2] ? Last.SUBSTITUTION : Last.INSERTION));
        return AlignerHelper.setSteps(traceback, false, new int[]{xMax, yMax}, last, sx, sy);
    }

    public static int[] setSteps(Last[][][] traceback, int[] xyMax, List<AlignedSequence.Step> sx, List<AlignedSequence.Step> sy) {
        return AlignerHelper.setSteps(traceback, true, xyMax, Last.SUBSTITUTION, sx, sy);
    }

    public static String tracebackToString(Last[][][] traceback) {
        StringBuilder sb = new StringBuilder();
        for (int z = 0; z < 3; ++z) {
            for (int i = 0; i < traceback.length; ++i) {
                if (traceback[i] != null) {
                    block7: for (int j = 0; j < traceback[i].length; ++j) {
                        if (traceback[i][j] == null || z >= traceback[i][j].length || traceback[i][j][z] == null) {
                            sb.append('.');
                            continue;
                        }
                        switch (traceback[i][j][z]) {
                            case DELETION: {
                                sb.append('^');
                                continue block7;
                            }
                            case SUBSTITUTION: {
                                sb.append('\\');
                                continue block7;
                            }
                            case INSERTION: {
                                sb.append('<');
                            }
                        }
                    }
                }
                sb.append('\n');
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public static class Subproblem {
        private int queryStartIndex;
        private int targetStartIndex;
        private int queryEndIndex;
        private int targetEndIndex;
        private boolean isAnchored;

        public int getTargetStartIndex() {
            return this.targetStartIndex;
        }

        public int getQueryEndIndex() {
            return this.queryEndIndex;
        }

        public int getTargetEndIndex() {
            return this.targetEndIndex;
        }

        public int getQueryStartIndex() {
            return this.queryStartIndex;
        }

        public boolean isStartAnchored() {
            return this.isAnchored;
        }

        public Subproblem(int queryStartIndex, int targetStartIndex, int queryEndIndex, int targetEndIndex) {
            this(queryStartIndex, targetStartIndex, queryEndIndex, targetEndIndex, false);
        }

        public Subproblem(int queryStartIndex, int targetStartIndex, int queryEndIndex, int targetEndIndex, boolean isAnchored) {
            this.queryStartIndex = queryStartIndex;
            this.targetStartIndex = targetStartIndex;
            this.queryEndIndex = queryEndIndex;
            this.targetEndIndex = targetEndIndex;
            this.isAnchored = isAnchored;
        }

        public static List<Subproblem> getSubproblems(List<Anchor> anchors, int querySequenceLength, int targetSequenceLength) {
            Collections.sort(anchors, new Anchor.QueryIndexComparator());
            ArrayList<Subproblem> list = new ArrayList<Subproblem>();
            Anchor last = new Anchor(-1, -1);
            boolean isAnchored = false;
            for (int i = 0; i < anchors.size(); ++i) {
                if (anchors.get(i).targetIndex <= last.targetIndex || anchors.get(i).queryIndex <= last.queryIndex) {
                    throw new IllegalArgumentException("Anchor set must allow at least one possible alignment.");
                }
                list.add(new Subproblem(last.queryIndex + 1, last.targetIndex + 1, anchors.get(i).queryIndex, anchors.get(i).targetIndex, isAnchored));
                last = anchors.get(i);
                isAnchored = true;
            }
            list.add(new Subproblem(last.queryIndex + 1, last.targetIndex + 1, querySequenceLength, targetSequenceLength, isAnchored));
            return list;
        }
    }

    public static class Anchor {
        private final int queryIndex;
        private final int targetIndex;

        public int getQueryIndex() {
            return this.queryIndex;
        }

        public int getTargetIndex() {
            return this.targetIndex;
        }

        public Anchor(int queryIndex, int targetIndex) {
            this.queryIndex = queryIndex;
            this.targetIndex = targetIndex;
        }

        public static class QueryIndexComparator
        implements Comparator<Anchor>,
        Serializable {
            private static final long serialVersionUID = 1L;

            @Override
            public int compare(Anchor o1, Anchor o2) {
                return o1.getQueryIndex() - o2.getQueryIndex();
            }
        }
    }

    public static class Cut {
        private int queryIndex;
        private int[][] targetIndices;
        private int[][] tiLast;
        private int[][] ti1;
        private int[][] ti2;

        public Cut(int queryIndex, int[] dim) {
            this.queryIndex = queryIndex;
            this.ti1 = new int[dim[1]][dim[2]];
            this.targetIndices = this.ti1;
            this.ti2 = new int[dim[1]][dim[2]];
        }

        public int getQueryIndex() {
            return this.queryIndex;
        }

        public int getTargetIndex(int z) {
            return this.targetIndices[this.targetIndices.length - 1][z];
        }

        public void update(int x, Subproblem subproblem, Last[][] pointers) {
            if (pointers[subproblem.getTargetStartIndex()].length == 1) {
                if (this.queryIndex == x - 1) {
                    this.updateLinearInitial(subproblem, pointers);
                } else if (this.queryIndex < x) {
                    this.updateLinearAdvance(subproblem, pointers);
                }
            } else if (this.queryIndex == x - 1) {
                this.updateInitial(subproblem, pointers);
            } else if (this.queryIndex < x) {
                this.updateAdvance(subproblem, pointers);
            }
        }

        private void updateAdvance(Subproblem subproblem, Last[][] pointers) {
            this.tiLast = this.targetIndices;
            this.targetIndices = this.targetIndices == this.ti2 ? this.ti1 : this.ti2;
            for (int y = subproblem.getTargetStartIndex(); y <= subproblem.getTargetEndIndex(); ++y) {
                if (pointers[y][0] != null) {
                    this.targetIndices[y][0] = this.tiLast[y - 1][pointers[y][0].ordinal()];
                }
                if (pointers[y][1] != null) {
                    this.targetIndices[y][1] = this.tiLast[y][pointers[y][1].ordinal()];
                }
                if (pointers[y][2] == null) continue;
                this.targetIndices[y][2] = this.targetIndices[y - 1][pointers[y][2].ordinal()];
            }
        }

        private void updateInitial(Subproblem subproblem, Last[][] pointers) {
            for (int y = subproblem.getTargetStartIndex(); y <= subproblem.getTargetEndIndex(); ++y) {
                if (pointers[y][0] != null) {
                    this.targetIndices[y][0] = y - 1;
                }
                if (pointers[y][1] != null) {
                    this.targetIndices[y][1] = y;
                }
                if (pointers[y][2] == null) continue;
                this.targetIndices[y][2] = this.targetIndices[y - 1][2];
            }
        }

        private void updateLinearAdvance(Subproblem subproblem, Last[][] pointers) {
            this.tiLast = this.targetIndices;
            this.targetIndices = this.targetIndices == this.ti2 ? this.ti1 : this.ti2;
            block5: for (int y = subproblem.getTargetStartIndex(); y <= subproblem.getTargetEndIndex(); ++y) {
                switch (pointers[y][0]) {
                    case DELETION: {
                        this.targetIndices[y][0] = this.tiLast[y][0];
                        continue block5;
                    }
                    case SUBSTITUTION: {
                        this.targetIndices[y][0] = this.tiLast[y - 1][0];
                        continue block5;
                    }
                    case INSERTION: {
                        this.targetIndices[y][0] = this.targetIndices[y - 1][0];
                    }
                }
            }
        }

        private void updateLinearInitial(Subproblem subproblem, Last[][] pointers) {
            block5: for (int y = subproblem.getTargetStartIndex(); y <= subproblem.getTargetEndIndex(); ++y) {
                if (pointers[y][0] == null) continue;
                switch (pointers[y][0]) {
                    case DELETION: {
                        this.targetIndices[y][0] = y;
                        continue block5;
                    }
                    case SUBSTITUTION: {
                        this.targetIndices[y][0] = y - 1;
                        continue block5;
                    }
                    case INSERTION: {
                        this.targetIndices[y][0] = this.targetIndices[y - 1][0];
                    }
                }
            }
        }
    }

    public static enum Last {
        SUBSTITUTION,
        DELETION,
        INSERTION;

    }
}

