/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.align.gui.AlignmentTextPanel;
import org.biojava.nbio.structure.align.gui.DisplayAFP;
import org.biojava.nbio.structure.align.gui.MenuCreator;
import org.biojava.nbio.structure.align.gui.aligpanel.MultipleAligPanel;
import org.biojava.nbio.structure.align.gui.aligpanel.MultipleStatusDisplay;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.JmolTools;
import org.biojava.nbio.structure.align.gui.jmol.MultipleAlignmentJmol;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentDisplay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleAlignmentJmolDisplay {
    private static final Logger logger = LoggerFactory.getLogger(MultipleAlignmentJmolDisplay.class);

    public static List<String> getPDBresnum(int structNum, MultipleAlignment multAln, Atom[] ca) {
        ArrayList<String> lst = new ArrayList<String>();
        for (Block block : multAln.getBlocks()) {
            for (int i = 0; i < block.length(); ++i) {
                Integer pos = (Integer)((List)block.getAlignRes().get(structNum)).get(i);
                if (pos == null || pos >= ca.length) continue;
                String pdbInfo = JmolTools.getPdbInfo(ca[pos]);
                lst.add(pdbInfo);
            }
        }
        return lst;
    }

    public static void showMultipleAligmentPanel(MultipleAlignment multAln, AbstractAlignmentJmol jmol) throws StructureException {
        MultipleAligPanel me = new MultipleAligPanel(multAln, jmol);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.setTitle(jmol.getTitle());
        me.setPreferredSize(new Dimension(me.getCoordManager().getPreferredWidth(), me.getCoordManager().getPreferredHeight()));
        JMenuBar menu = MenuCreator.getAlignmentPanelMenu(frame, me, null, multAln);
        frame.setJMenuBar(menu);
        JScrollPane scroll = new JScrollPane(me);
        scroll.setAutoscrolls(true);
        MultipleStatusDisplay status = new MultipleStatusDisplay(me);
        me.addAlignmentPositionListener(status);
        Box vBox = Box.createVerticalBox();
        vBox.add(scroll);
        vBox.add(status);
        frame.getContentPane().add(vBox);
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(me);
        frame.addWindowListener(status);
    }

    public static void showAlignmentImage(MultipleAlignment multAln, String result) {
        JFrame frame = new JFrame();
        String title = multAln.getEnsemble().getAlgorithmName() + " V." + multAln.getEnsemble().getVersion();
        frame.setTitle(title);
        frame.setDefaultCloseOperation(2);
        AlignmentTextPanel txtPanel = new AlignmentTextPanel();
        txtPanel.setText(result);
        JMenuBar menu = MenuCreator.getAlignmentTextMenu(frame, txtPanel, null, multAln);
        frame.setJMenuBar(menu);
        JScrollPane js = new JScrollPane();
        js.getViewport().add(txtPanel);
        js.getViewport().setBorder(null);
        frame.getContentPane().add(js);
        frame.pack();
        frame.setVisible(true);
    }

    public static MultipleAlignmentJmol display(MultipleAlignment multAln) throws StructureException {
        List rotatedAtoms = MultipleAlignmentDisplay.getRotatedAtoms((MultipleAlignment)multAln);
        MultipleAlignmentJmol jmol = new MultipleAlignmentJmol(multAln, rotatedAtoms);
        jmol.setTitle(jmol.getStructure().getPDBHeader().getTitle());
        return jmol;
    }

    public static final Structure getAlignedStructure(List<Atom[]> atomArrays) throws StructureException {
        StructureImpl s = new StructureImpl();
        for (int i = 0; i < atomArrays.size(); ++i) {
            List<Chain> model = DisplayAFP.getAlignedModel(atomArrays.get(i));
            s.addModel(model);
        }
        return s;
    }
}

