/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.gui.ScaleableMatrixPanel;
import org.biojava.nbio.structure.jama.Matrix;

public class MyDistMaxListener
implements ActionListener {
    AbstractAlignmentJmol parent;

    public MyDistMaxListener(AbstractAlignmentJmol parent) {
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        System.out.println("Show interatomic Distance Matrices");
        if (this.parent.getDistanceMatrices() == null) {
            System.err.println("Not displaying any alignment currently!");
            return;
        }
        for (int i = 0; i < this.parent.getDistanceMatrices().size(); ++i) {
            if (this.parent.getDistanceMatrices().get(i) == null) continue;
            this.showMatrix(this.parent.getDistanceMatrices().get(i), "Internal Distances for Structure " + (i + 1));
        }
    }

    private void showMatrix(Matrix m, String title) {
        ScaleableMatrixPanel smp = new ScaleableMatrixPanel();
        JFrame frame = new JFrame(title);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JFrame f = (JFrame)e.getSource();
                f.setVisible(false);
                f.dispose();
            }
        });
        smp.setMatrix(m);
        frame.getContentPane().add(smp);
        frame.pack();
        frame.setVisible(true);
    }
}

