/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.aligpanel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JTextField;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.align.gui.aligpanel.MultipleAligPanel;
import org.biojava.nbio.structure.align.gui.jmol.JmolTools;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentTools;
import org.biojava.nbio.structure.gui.events.AlignmentPositionListener;
import org.biojava.nbio.structure.gui.util.AlignedPosition;

public class MultipleStatusDisplay
extends JTextField
implements AlignmentPositionListener,
WindowListener {
    private static final long serialVersionUID = 6939947266417830429L;
    private MultipleAligPanel panel;

    private MultipleStatusDisplay() {
        this.setBackground(Color.white);
        this.setEditable(false);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
    }

    public MultipleStatusDisplay(MultipleAligPanel panel) {
        this();
        this.panel = panel;
    }

    public void destroy() {
        this.panel = null;
    }

    @Override
    public void mouseOverPosition(AlignedPosition p) {
        if (this.panel == null) {
            return;
        }
        try {
            String msg = "alig pos";
            for (int str = 0; str < this.panel.size; ++str) {
                String alnseq = this.panel.getAlnSequences().get(str);
                char c = alnseq.charAt(p.getPos1());
                Atom a = MultipleAlignmentTools.getAtomForSequencePosition((MultipleAlignment)this.panel.getMultipleAlignment(), this.panel.getMapSeqToStruct(), (int)str, (int)p.getPos1());
                String pdbInfo = JmolTools.getPdbInfo(a);
                msg = msg + ": " + pdbInfo + " (" + c + ") ";
            }
            this.setText(msg);
            this.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void positionSelected(AlignedPosition p) {
        this.mouseOverPosition(p);
    }

    @Override
    public void toggleSelection(AlignedPosition p) {
        if (this.panel == null) {
            return;
        }
        try {
            String msg = "Clicked pos";
            for (int str = 0; str < this.panel.size; ++str) {
                String alnseq = this.panel.getAlnSequences().get(str);
                char c = alnseq.charAt(p.getPos1());
                Atom a = MultipleAlignmentTools.getAtomForSequencePosition((MultipleAlignment)this.panel.getMultipleAlignment(), this.panel.getMapSeqToStruct(), (int)str, (int)p.getPos1());
                String pdbInfo = JmolTools.getPdbInfo(a);
                msg = msg + ": " + pdbInfo + " (" + c + ") ";
            }
            this.setText(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void rangeSelected(AlignedPosition start, AlignedPosition end) {
        try {
            String msg = "Selected:";
            for (int str = 0; str < this.panel.size; ++str) {
                String alnseq = this.panel.getAlnSequences().get(str);
                char c1 = alnseq.charAt(start.getPos1());
                char c2 = alnseq.charAt(end.getPos1());
                Atom a1 = MultipleAlignmentTools.getAtomForSequencePosition((MultipleAlignment)this.panel.getMultipleAlignment(), this.panel.getMapSeqToStruct(), (int)str, (int)start.getPos1());
                Atom a2 = MultipleAlignmentTools.getAtomForSequencePosition((MultipleAlignment)this.panel.getMultipleAlignment(), this.panel.getMapSeqToStruct(), (int)str, (int)end.getPos1());
                String pdbInfo1 = JmolTools.getPdbInfo(a1);
                String pdbInfo2 = JmolTools.getPdbInfo(a2);
                msg = msg + " range" + str + ": " + pdbInfo1 + " (" + c1 + ") - " + pdbInfo2 + " (" + c2 + ")";
            }
            this.setText(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.destroy();
    }

    @Override
    public void selectionLocked() {
    }

    @Override
    public void selectionUnlocked() {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

