/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.webstart;

import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import org.biojava.nbio.structure.align.FarmJob;
import org.biojava.nbio.structure.align.client.FarmJobParameters;
import org.biojava.nbio.structure.align.gui.GUIFarmJobRunnable;
import org.biojava.nbio.structure.align.util.CliTools;
import org.biojava.nbio.structure.align.util.ConfigurationException;

public class WebStartDBSearch {
    private static final String[] mandParams = new String[]{"pdbFilePath"};
    private static final List<String> mandatoryArgs = Arrays.asList(mandParams);

    public static void main(String[] argv) {
        FarmJob job = new FarmJob();
        if (argv.length == 0) {
            job.printHelp();
            JOptionPane.showMessageDialog(null, "Not enough arguments!");
            return;
        }
        if (argv.length == 1 && (argv[0].equalsIgnoreCase("-h") || argv[0].equalsIgnoreCase("-help") || argv[0].equalsIgnoreCase("--help"))) {
            job.printHelp();
            JOptionPane.showMessageDialog(null, "Help not supported...");
            return;
        }
        FarmJobParameters params = new FarmJobParameters();
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            String value = null;
            if (i < argv.length - 1) {
                value = argv[i + 1];
            }
            if (value != null && value.startsWith("-")) {
                value = null;
            } else {
                ++i;
            }
            String[] tmp = new String[]{arg, value};
            try {
                CliTools.configureBean((Object)params, (String[])tmp);
                continue;
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
                if (!mandatoryArgs.contains(arg)) continue;
                JOptionPane.showMessageDialog(null, e.getMessage());
                return;
            }
        }
        params.setRunBackground(true);
        GUIFarmJobRunnable runnable = new GUIFarmJobRunnable(params);
        runnable.run();
    }
}

