/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.StructureAlignmentFactory;
import org.biojava.nbio.structure.align.ce.CeParameters;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.gui.DisplayAFP;
import org.biojava.nbio.structure.align.gui.MyTableRowSorter;
import org.biojava.nbio.structure.align.gui.StructureAlignmentDisplay;
import org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.WebStartMain;
import org.biojava.nbio.structure.io.PDBFileReader;

public class DBResultTable
implements ActionListener {
    public static final String[] ceColumnNames = new String[]{"name1", "tname2", "score", "z-score", "rmsd", "len1", "len2", "cov1", "cov2", "%ID", "Description", ""};
    public static final String[] fatColumnNames = new String[]{"name1", "tname2", "score", "probability", "rmsd", "len1", "len2", "cov1", "cov2", "%ID", "Description", ""};
    Object[][] data;
    JTable table;
    String oldName1 = "";
    String oldName2 = "";
    String algorithmName;
    StructureAlignment algorithm;
    boolean isCE = true;
    UserConfiguration config;
    AtomCache cache;
    String userPath = null;
    String userChain = null;

    public static void main(String[] args) {
        String file = "/tmp/results_4hhb.A.out";
        DBResultTable table = new DBResultTable();
        UserConfiguration config = WebStartMain.getDefaultConfig();
        table.show(new File(file), config);
    }

    public void show(BufferedReader in, UserConfiguration config) throws IOException {
        String str;
        ArrayList<String[]> tmpdat = new ArrayList<String[]>();
        while ((str = in.readLine()) != null) {
            String[] spl;
            if (str.startsWith("#")) {
                if (str.startsWith("# algorithm:")) {
                    spl = str.split(":");
                    if (spl.length == 2) {
                        this.algorithmName = spl[1];
                        this.isCE = this.algorithmName.startsWith("jCE");
                    }
                    this.initAlgorithm(this.algorithmName);
                    continue;
                }
                if (str.startsWith("#param:file1=")) {
                    String path = str.substring(13);
                    this.userPath = path.trim();
                    continue;
                }
                if (str.startsWith("#param:chain1=")) {
                    String chain = str.substring(14);
                    this.userChain = chain.trim();
                    continue;
                }
                if (!str.startsWith("#param:scoring=")) continue;
                try {
                    ConfigStrucAligParams params;
                    CeParameters.ScoringStrategy scoreS;
                    spl = str.split("=");
                    try {
                        int stratNum = Integer.parseInt(spl[1]);
                        CeParameters.ScoringStrategy[] vals = CeParameters.ScoringStrategy.values();
                        scoreS = vals[stratNum];
                    }
                    catch (NumberFormatException e) {
                        scoreS = CeParameters.ScoringStrategy.valueOf((String)spl[1]);
                    }
                    if (this.algorithm == null || !((params = this.algorithm.getParameters()) instanceof CeParameters)) continue;
                    CeParameters ceParams = (CeParameters)params;
                    ceParams.setScoringStrategy(scoreS);
                }
                catch (IndexOutOfBoundsException e) {
                    System.err.println("Unknown scoring strategy from line: " + str);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Unknown scoring strategy from line: " + str);
                }
                catch (Exception e) {
                    System.err.println("Unknown parameter can't read parameters from line: " + str);
                    e.printStackTrace();
                }
                continue;
            }
            spl = str.split("\t");
            if (spl.length != ceColumnNames.length - 1) {
                System.err.println("wrong table width! " + spl.length + " should be: " + (ceColumnNames.length - 1));
                System.err.println(str);
                continue;
            }
            tmpdat.add(spl);
        }
        in.close();
        Object[][] d = new Object[tmpdat.size()][ceColumnNames.length + 1];
        int i = -1;
        for (String[] spl : tmpdat) {
            ++i;
            Object[] o = new Object[spl.length + 1];
            for (int j = 0; j < spl.length; ++j) {
                o[j] = j >= 2 && j <= 4 || j == 9 ? Double.valueOf(Double.parseDouble(spl[j])) : (j > 4 && j < 10 ? Integer.valueOf(Integer.parseInt(spl[j])) : spl[j]);
            }
            o[spl.length] = "Align";
            d[i] = o;
        }
        this.data = d;
        Object[] columnNames = ceColumnNames;
        if (!this.isCE) {
            columnNames = fatColumnNames;
        }
        this.table = new JTable(this.data, columnNames);
        MyTableRowSorter sorter = new MyTableRowSorter(this.table.getModel());
        this.table.setRowSorter(sorter);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(1);
        this.table.getSelectionModel().addListSelectionListener(new RowListener());
        JFrame f = new JFrame();
        f.getContentPane().add(scrollPane);
        f.pack();
        f.setVisible(true);
    }

    public void show(File file, UserConfiguration config) {
        this.config = config;
        this.cache = new AtomCache(config);
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            this.show(in, config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void show(URL url, UserConfiguration config) {
        this.config = config;
        this.cache = new AtomCache(config);
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            this.show(in, config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initAlgorithm(String algorithmName) {
        try {
            this.algorithm = StructureAlignmentFactory.getAlgorithm((String)algorithmName);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Can't guess algorithm from output. Using jCE as default...");
            try {
                this.algorithm = StructureAlignmentFactory.getAlgorithm((String)"jCE");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    private void outputSelection() {
        StringBuffer output = new StringBuffer();
        output.append(String.format("Lead: %d, %d. ", this.table.getSelectionModel().getLeadSelectionIndex(), this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex()));
        output.append("Rows:");
        for (int c : this.table.getSelectedRows()) {
            output.append(String.format(" %d", c));
        }
        output.append(". Columns:");
        for (int c : this.table.getSelectedColumns()) {
            output.append(String.format(" %d", c));
        }
        System.out.println(output.toString());
    }

    private void showAlignment(String name1, String name2) {
        if (this.algorithm == null) {
            this.initAlgorithm(null);
        }
        try {
            Structure structure1 = null;
            structure1 = name1.equals("CUSTOM") ? this.loadCustomStructure(this.userPath, this.userChain) : this.cache.getStructure(name1);
            Structure structure2 = this.cache.getStructure(name2);
            Atom[] ca1 = StructureTools.getRepresentativeAtomArray((Structure)structure1);
            Atom[] ca2 = StructureTools.getRepresentativeAtomArray((Structure)structure2);
            AFPChain afpChain = this.algorithm.align(ca1, ca2);
            afpChain.setName1(name1);
            afpChain.setName2(name2);
            StructureAlignmentJmol jmol = StructureAlignmentDisplay.display(afpChain, ca1, ca2);
            DisplayAFP.showAlignmentPanel(afpChain, ca1, ca2, jmol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Structure loadCustomStructure(String userPath2, String userChain2) throws StructureException {
        PDBFileReader reader = new PDBFileReader();
        Structure s = null;
        try {
            s = reader.getStructure(userPath2);
        }
        catch (IOException e) {
            throw new StructureException((Throwable)e);
        }
        return StructureTools.getReducedStructure((Structure)s, (String)userChain2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private class RowListener
    implements ListSelectionListener {
        private RowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            int row = DBResultTable.this.table.getSelectionModel().getLeadSelectionIndex();
            String name1 = (String)DBResultTable.this.table.getValueAt(row, 0);
            String name2 = (String)DBResultTable.this.table.getValueAt(row, 1);
            if (name1.equals(DBResultTable.this.oldName1) && DBResultTable.this.oldName2.equals(name2)) {
                return;
            }
            System.out.println("recreating alignment of: " + name1 + " " + name2 + " using " + DBResultTable.this.algorithmName);
            DBResultTable.this.outputSelection();
            DBResultTable.this.showAlignment(name1, name2);
            DBResultTable.this.oldName1 = name1;
            DBResultTable.this.oldName2 = name2;
        }
    }
}

