/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.autosuggest;

import java.awt.Font;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.biojava.nbio.structure.align.gui.autosuggest.AutoSuggestProvider;
import org.biojava.nbio.structure.align.gui.autosuggest.DefaultAutoSuggestProvider;

public class JAutoSuggest
extends JTextField {
    private static final long serialVersionUID = 8591734727984365156L;
    private static final String DEFAULT_TEXT = "Please enter text ...";
    String defaultText;
    private JDialog dialog;
    private Point location;
    private JList list;
    private Vector<String> suggestions;
    private String lastWord;
    AutoSuggestProvider autoSuggestProvider;
    Font regular;
    Font busy;
    SuggestionFetcher matcher;

    public JAutoSuggest() {
        this.init();
    }

    public JAutoSuggest(int size) {
        super(size);
        this.init();
    }

    public JAutoSuggest(Frame owner) {
        owner.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                JAutoSuggest.this.updateLocation();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                JAutoSuggest.this.updateLocation();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                JAutoSuggest.this.updateLocation();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                JAutoSuggest.this.updateLocation();
            }
        });
        owner.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
                JAutoSuggest.this.dialog.setVisible(false);
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                JAutoSuggest.this.dialog.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                JAutoSuggest.this.dialog.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                System.out.println("Lost Focus");
                JAutoSuggest.this.dialog.setVisible(false);
                if (JAutoSuggest.this.getText().trim().equals("") && e.getOppositeComponent() != null && e.getOppositeComponent().getName() != null) {
                    if (!e.getOppositeComponent().getName().equals("suggestFieldDropdownButton")) {
                        JAutoSuggest.this.setText(JAutoSuggest.this.defaultText);
                    }
                } else if (JAutoSuggest.this.getText().trim().equals("")) {
                    JAutoSuggest.this.setText(JAutoSuggest.this.defaultText);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                System.out.println("Lost Gained");
                if (JAutoSuggest.this.getText().trim().equals(JAutoSuggest.this.defaultText)) {
                    JAutoSuggest.this.setText("");
                }
                JAutoSuggest.this.showSuggest();
            }
        });
        this.init();
    }

    private void initSuggestionList() {
        this.list = new JList();
        this.list.addMouseListener(new MouseListener(){
            private int selected;

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.selected == JAutoSuggest.this.list.getSelectedIndex()) {
                    JAutoSuggest.this.setText((String)JAutoSuggest.this.list.getSelectedValue());
                    JAutoSuggest.this.dialog.setVisible(false);
                }
                this.selected = JAutoSuggest.this.list.getSelectedIndex();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.dialog.add(new JScrollPane(this.list, 20, 31));
        this.dialog.pack();
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                JAutoSuggest.this.updateLocation();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    JAutoSuggest.this.dialog.setVisible(false);
                    return;
                }
                if (e.getKeyCode() == 40) {
                    if (JAutoSuggest.this.dialog.isVisible()) {
                        JAutoSuggest.this.list.setSelectedIndex(JAutoSuggest.this.list.getSelectedIndex() + 1);
                        JAutoSuggest.this.list.ensureIndexIsVisible(JAutoSuggest.this.list.getSelectedIndex() + 1);
                        return;
                    }
                    JAutoSuggest.this.showSuggest();
                } else {
                    if (e.getKeyCode() == 38) {
                        JAutoSuggest.this.list.setSelectedIndex(JAutoSuggest.this.list.getSelectedIndex() - 1);
                        JAutoSuggest.this.list.ensureIndexIsVisible(JAutoSuggest.this.list.getSelectedIndex() - 1);
                        return;
                    }
                    if (e.getKeyCode() == 10 & JAutoSuggest.this.list.getSelectedIndex() != -1 & JAutoSuggest.this.suggestions.size() > 0) {
                        JAutoSuggest.this.setText((String)JAutoSuggest.this.list.getSelectedValue());
                        JAutoSuggest.this.dialog.setVisible(false);
                        return;
                    }
                }
                JAutoSuggest.this.showSuggest();
            }
        });
    }

    private void init() {
        this.autoSuggestProvider = new DefaultAutoSuggestProvider();
        this.lastWord = "";
        this.regular = this.getFont();
        this.busy = new Font(this.getFont().getName(), 2, this.getFont().getSize());
        this.suggestions = new Vector();
        this.defaultText = DEFAULT_TEXT;
        this.dialog = new JDialog();
        this.dialog.setUndecorated(true);
        this.dialog.setFocusableWindowState(false);
        this.dialog.setFocusable(false);
        this.initSuggestionList();
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public AutoSuggestProvider getAutoSuggestProvider() {
        return this.autoSuggestProvider;
    }

    public void setAutoSuggestProvider(AutoSuggestProvider autoSuggestProvider) {
        this.autoSuggestProvider = autoSuggestProvider;
    }

    public void showSuggest() {
        assert (this.getText() != null);
        this.lastWord = this.getText().trim();
        if (!this.getText().toLowerCase().contains(this.lastWord.toLowerCase())) {
            this.suggestions.clear();
        }
        if (this.matcher != null) {
            this.matcher.setStop();
        }
        this.matcher = new SuggestionFetcher();
        this.matcher.execute();
        this.lastWord = this.getText().trim();
        this.updateLocation();
    }

    public void hideSuggest() {
        this.dialog.setVisible(false);
    }

    public boolean isSuggestVisible() {
        return this.dialog.isVisible();
    }

    private void updateLocation() {
        try {
            this.location = this.getLocationOnScreen();
            this.location.y += this.getHeight();
            this.dialog.setLocation(this.location);
        }
        catch (IllegalComponentStateException e) {
            return;
        }
    }

    private class SuggestionFetcher
    extends SwingWorker<String, Object> {
        private AtomicBoolean stop = new AtomicBoolean(false);
        String previousWord;

        private SuggestionFetcher() {
        }

        @Override
        public String doInBackground() {
            try {
                JAutoSuggest.this.setFont(JAutoSuggest.this.busy);
                String userInput = JAutoSuggest.this.getText().trim();
                if (userInput == null || userInput.equals("")) {
                    return "";
                }
                if (this.previousWord != null && userInput.equals(this.previousWord)) {
                    return "";
                }
                this.previousWord = userInput;
                JAutoSuggest.this.suggestions = JAutoSuggest.this.autoSuggestProvider.getSuggestion(userInput);
                JAutoSuggest.this.setFont(JAutoSuggest.this.regular);
                if (JAutoSuggest.this.suggestions.size() > 0) {
                    JAutoSuggest.this.list.setListData(JAutoSuggest.this.suggestions);
                    JAutoSuggest.this.list.setSelectedIndex(0);
                    JAutoSuggest.this.list.ensureIndexIsVisible(0);
                    JAutoSuggest.this.dialog.setVisible(true);
                } else {
                    JAutoSuggest.this.dialog.setVisible(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Done.";
        }

        public void setStop() {
            this.stop.set(true);
        }
    }
}

