/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.gui.util.AlignedPosition;
import org.biojava.nbio.structure.gui.util.CoordManager;

public class SequenceScalePanel
extends JPanel {
    static final long serialVersionUID = 7893248902423L;
    public static final int DEFAULT_X_START = 10;
    public static final int DEFAULT_X_RIGHT_BORDER = 40;
    public static final int DEFAULT_Y_START = 0;
    public static final int DEFAULT_Y_STEP = 10;
    public static final int DEFAULT_Y_HEIGHT = 8;
    public static final int DEFAULT_Y_BOTTOM = 16;
    public static final int LINE_HEIGHT = 10;
    public static final int MINIMUM_HEIGHT = 20;
    public static final Color SEQUENCE_COLOR = Color.LIGHT_GRAY;
    public static final Color SCALE_COLOR = Color.black;
    public static final Color TEXT_SCALE_COLOR = Color.GRAY;
    public static final Color IDX_COLOR = Color.yellow;
    public static final Color GAP_COLOR = Color.white;
    public static final Color BACKGROUND_COLOR;
    public static final Font seqFont;
    private static final int SEQUENCE_SHOW = 9;
    public static final int SIZE = 20;
    Chain chain;
    int chainLength;
    float scale;
    Character[] seqArr;
    CoordManager coordManager;
    int position;
    List<AlignedPosition> apos;

    public SequenceScalePanel(int position) {
        this.position = position;
        this.setBackground(BACKGROUND_COLOR);
        this.chain = new ChainImpl();
        this.setDoubleBuffered(true);
        this.seqArr = new Character[0];
        this.chainLength = 0;
        this.scale = 1.0f;
        this.setPrefSize();
        this.coordManager = new CoordManager();
        this.apos = new ArrayList<AlignedPosition>();
    }

    private void setPrefSize() {
        int length = this.chainLength;
        int l = Math.round((float)length * this.scale) + 10 + 40;
        if (l < 60) {
            l = 60;
        }
        this.setPreferredSize(new Dimension(l, 20));
    }

    public void setAligMap(List<AlignedPosition> apos) {
        this.apos = apos;
        if (apos.size() == 0) {
            return;
        }
        AlignedPosition last = apos.get(apos.size() - 1);
        if (last.getPos(this.position) != -1) {
            for (int idxlast = last.getPos(this.position); idxlast < this.chainLength; ++idxlast) {
                AlignedPosition m = new AlignedPosition();
                m.setPos(this.position, idxlast);
                apos.add(m);
            }
        }
    }

    public synchronized void setChain(Chain c) {
        List a = c.getAtomGroups(GroupType.AMINOACID);
        this.seqArr = new Character[a.size()];
        this.chain = new ChainImpl();
        Iterator iter = a.iterator();
        int i = 0;
        while (iter.hasNext()) {
            AminoAcid aa = (AminoAcid)iter.next();
            Chain old = aa.getChain();
            this.chain.addGroup((Group)aa);
            aa.setChain(old);
            this.seqArr[i] = aa.getAminoType();
            ++i;
        }
        this.chainLength = i;
        this.coordManager.setLength(this.chainLength);
        this.setPrefSize();
        this.repaint();
    }

    public Chain getChain() {
        return this.chain;
    }

    public synchronized float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.coordManager.setScale(scale);
        this.setPrefSize();
        this.repaint();
        this.revalidate();
    }

    protected void setPaintDefaults(Graphics2D g2D) {
        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setFont(seqFont);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(BACKGROUND_COLOR);
        Rectangle drawHere = g.getClipBounds();
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        Graphics2D g2D = (Graphics2D)g;
        this.setPaintDefaults(g2D);
        int y = 1;
        y = this.drawScale(g2D, 1);
        this.drawIdx(g2D, y);
        y = this.drawSequence(g2D, y);
    }

    protected int drawScale(Graphics2D g2D, int y) {
        Rectangle drawHere = g2D.getClipBounds();
        g2D.setColor(SCALE_COLOR);
        int aminosize = Math.round(1.0f * this.scale);
        if (aminosize < 1) {
            aminosize = 1;
        }
        int startpos = this.coordManager.getSeqPos(drawHere.x);
        int endpos = this.coordManager.getSeqPos(drawHere.x + drawHere.width);
        if (endpos > this.apos.size()) {
            endpos = this.apos.size();
        }
        int l = endpos - startpos + 1;
        int drawStart = this.coordManager.getPanelPos(startpos);
        int drawEnd = this.coordManager.getPanelPos(l) - 10 + aminosize;
        if (this.scale < 9.0f) {
            g2D.setColor(SEQUENCE_COLOR);
            Rectangle seqline = new Rectangle(drawStart, y, drawEnd, 10);
            g2D.fill(seqline);
        }
        g2D.setColor(SCALE_COLOR);
        Rectangle baseline = new Rectangle(drawStart, y, drawEnd, 2);
        g2D.fill(baseline);
        int lineH = 11;
        if (this.scale <= 3.0f) {
            lineH = 8;
        }
        for (int gap = startpos; gap <= endpos && gap < this.apos.size(); ++gap) {
            int xpos = this.coordManager.getPanelPos(gap);
            AlignedPosition m = this.apos.get(gap);
            if (m.getPos(this.position) == -1) {
                g2D.setColor(GAP_COLOR);
                g2D.fillRect(xpos, y + 2, aminosize + 1, y + lineH);
                g2D.setColor(GAP_COLOR);
                continue;
            }
            int i = m.getPos(this.position);
            if ((i + 1) % 100 == 0) {
                if (!((double)this.scale > 0.1)) continue;
                g2D.setColor(TEXT_SCALE_COLOR);
                g2D.fillRect(xpos, y + 2, aminosize, y + lineH);
                g2D.setColor(SCALE_COLOR);
                if (!(this.scale < 9.0f)) continue;
                g2D.drawString("" + (i + 1), xpos, y + 10);
                continue;
            }
            if ((i + 1) % 50 == 0) {
                if (!((double)this.scale > 1.4)) continue;
                g2D.setColor(TEXT_SCALE_COLOR);
                g2D.fillRect(xpos, y + 2, aminosize, y + lineH);
                g2D.setColor(SCALE_COLOR);
                if (!(this.scale < 9.0f)) continue;
                g2D.drawString("" + (i + 1), xpos, y + 10);
                continue;
            }
            if ((i + 1) % 10 != 0 || !(this.scale > 3.0f)) continue;
            g2D.setColor(TEXT_SCALE_COLOR);
            g2D.fillRect(xpos, y + 2, aminosize, y + lineH);
            g2D.setColor(SCALE_COLOR);
            if (!(this.scale < 9.0f)) continue;
            g2D.drawString("" + (i + 1), xpos, y + 10);
        }
        int length = this.chainLength;
        if (endpos >= length - 1) {
            int endPanel = this.coordManager.getPanelPos(endpos);
            g2D.drawString("" + length, endPanel + 10, y + 10);
        }
        return y;
    }

    protected void drawIdx(Graphics2D g2D, int y) {
        int aminosize = Math.round(1.0f * this.scale);
        if (aminosize < 1) {
            aminosize = 1;
        }
        Rectangle drawHere = g2D.getClipBounds();
        int startpos = this.coordManager.getSeqPos(drawHere.x);
        Composite oldComp = g2D.getComposite();
        g2D.setComposite(AlphaComposite.getInstance(3, 0.8f));
        if (startpos < 0) {
            startpos = 999;
        }
        g2D.setColor(IDX_COLOR);
        int lineH = 11;
        if (this.scale <= 3.0f) {
            lineH = 8;
        }
        int i = startpos;
        block0: for (int gap = startpos; gap < this.apos.size(); ++gap) {
            int xpos = this.coordManager.getPanelPos(gap);
            AlignedPosition m = this.apos.get(gap);
            if (m.getEquivalent() == 0) continue;
            i = m.getPos(this.position);
            for (AlignedPosition xi : this.apos) {
                if (xi.getPos(this.position) == -1 || i != xi.getPos(this.position)) continue;
                g2D.fillRect(xpos, y + 2, aminosize, y + lineH);
                continue block0;
            }
        }
        g2D.setComposite(oldComp);
    }

    protected int drawSequence(Graphics2D g2D, int y) {
        g2D.setColor(SEQUENCE_COLOR);
        int aminosize = Math.round(1.0f * this.scale);
        if (aminosize < 1) {
            aminosize = 1;
        }
        Rectangle drawHere = g2D.getClipBounds();
        int startpos = this.coordManager.getSeqPos(drawHere.x);
        Composite oldComp = g2D.getComposite();
        g2D.setComposite(AlphaComposite.getInstance(3, 0.8f));
        if (startpos < 0) {
            startpos = 999;
        }
        if (this.scale > 9.0f) {
            g2D.setColor(Color.black);
            int i = startpos;
            for (int gap = startpos; gap < this.apos.size(); ++gap) {
                int xpos = this.coordManager.getPanelPos(gap);
                AlignedPosition m = this.apos.get(gap);
                if (m.getPos(this.position) == -1) {
                    g2D.drawString("-", xpos + 1, y + 2 + 10);
                    continue;
                }
                i = m.getPos(this.position);
                g2D.drawString(this.seqArr[i].toString(), xpos + 1, y + 2 + 10);
            }
            y += 2;
        }
        g2D.setComposite(oldComp);
        return y += 12;
    }

    static {
        String fontName = "Helvetica";
        int fsize = 12;
        seqFont = new Font(fontName, 0, fsize);
        String col1 = "#FFFFFF";
        BACKGROUND_COLOR = Color.decode(col1);
    }
}

