/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util.color;

import java.awt.Color;

public class ColorUtils {
    public static Color orange = Color.decode("#FFA500");
    public static Color cyan = Color.decode("#00FFFF");
    public static Color gold = Color.decode("#FFD700");
    static final Color c1 = Color.decode("#228B22");
    static final Color c2 = Color.decode("#8F8FFF");
    static final Color c3 = gold;
    static final Color c4 = Color.decode("#FF8C00");
    static final Color c5 = Color.decode("#FF00FF");
    static final Color c6 = Color.decode("#C71585");
    public static final Color[] colorWheel = new Color[]{c1, c2, c3, c4, c5, c6};

    public static void main(String[] args) {
        int i = -1;
        for (Color color : colorWheel) {
            float[] af = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            System.out.println("position " + ++i + "  " + af[0] + " " + af[1] + " " + af[2]);
        }
    }

    public static String toHexColor(Color col) {
        return Integer.toHexString(col.getRGB() & 0xFFFFFF | 0x1000000).substring(1);
    }

    public static Color rotateHue(Color color, float fraction) {
        float[] af = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float hue = af[0];
        float saturation = af[1];
        float brightness = af[2];
        float hueNew = hue + fraction;
        Color hsb = Color.getHSBColor(hueNew, saturation, brightness);
        return new Color(hsb.getRed(), hsb.getGreen(), hsb.getBlue(), color.getAlpha());
    }

    public static Color getIntermediate(Color start, Color end, int stepSize, int position) {
        float hue1;
        float[] af1 = Color.RGBtoHSB(start.getRed(), start.getGreen(), start.getBlue(), null);
        float[] af2 = Color.RGBtoHSB(end.getRed(), end.getGreen(), end.getBlue(), null);
        float hue2 = af2[0];
        if (hue2 < (hue1 = af1[0])) {
            hue2 = af1[0];
            hue1 = af2[0];
        }
        float range = Math.abs(hue2 - hue1);
        while (position > stepSize) {
            position -= stepSize;
        }
        float inc = range * (float)position / (float)stepSize;
        float hueNew = hue1 + inc;
        return Color.getHSBColor(hueNew, af1[1], af1[2]);
    }

    public static Color darker(Color color, double fraction) {
        int red = (int)Math.round((double)color.getRed() * (1.0 - fraction));
        int green = (int)Math.round((double)color.getGreen() * (1.0 - fraction));
        int blue = (int)Math.round((double)color.getBlue() * (1.0 - fraction));
        if (red < 0) {
            red = 0;
        } else if (red > 255) {
            red = 255;
        }
        if (green < 0) {
            green = 0;
        } else if (green > 255) {
            green = 255;
        }
        if (blue < 0) {
            blue = 0;
        } else if (blue > 255) {
            blue = 255;
        }
        int alpha = color.getAlpha();
        return new Color(red, green, blue, alpha);
    }

    public static Color lighter(Color color, double fraction) {
        int red = (int)Math.round((double)color.getRed() * (1.0 + fraction));
        int green = (int)Math.round((double)color.getGreen() * (1.0 + fraction));
        int blue = (int)Math.round((double)color.getBlue() * (1.0 + fraction));
        if (red < 0) {
            red = 0;
        } else if (red > 255) {
            red = 255;
        }
        if (green < 0) {
            green = 0;
        } else if (green > 255) {
            green = 255;
        }
        if (blue < 0) {
            blue = 0;
        } else if (blue > 255) {
            blue = 255;
        }
        int alpha = color.getAlpha();
        return new Color(red, green, blue, alpha);
    }
}

