/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.biojava.nbio.structure.align.FarmJob;
import org.biojava.nbio.structure.align.events.AlignmentProgressListener;

public class GUIAlignmentProgressListener
extends JPanel
implements AlignmentProgressListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    int alignmentsProcessed;
    JProgressBar progressBar;
    private JTextArea taskOutput;
    private JButton stopButton = new JButton("Stop");
    FarmJob farmJob;

    public GUIAlignmentProgressListener() {
        super(new BorderLayout());
        this.stopButton.setActionCommand("Stop");
        this.stopButton.addActionListener(this);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        JPanel panel = new JPanel();
        panel.add(this.stopButton);
        panel.add(this.progressBar);
        this.add((Component)panel, "First");
        this.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    public FarmJob getFarmJob() {
        return this.farmJob;
    }

    public void setFarmJob(FarmJob parent) {
        this.farmJob = parent;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.logStatus("terminating");
        this.logStatus(" Total alignments processed: " + this.alignmentsProcessed);
        this.stopButton.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(false);
        System.out.println("terminating jobs");
        this.farmJob.terminate();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.progressBar.setIndeterminate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alignmentEnded() {
        ++this.alignmentsProcessed;
        int v = this.progressBar.getValue();
        this.progressBar.setValue(v + 1);
        this.progressBar.setString(String.valueOf(v));
        GUIAlignmentProgressListener gUIAlignmentProgressListener = this;
        synchronized (gUIAlignmentProgressListener) {
            this.notifyAll();
        }
    }

    public void alignmentStarted(String name1, String name2) {
        this.logStatus("#" + this.progressBar.getValue() + " starting alignment of " + name1 + " " + name2);
    }

    public void downloadingStructures(String name) {
        this.logStatus("Downloading " + name);
    }

    public void logStatus(String message) {
        this.taskOutput.append(message + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestingAlignmentsFromServer(int nrAlignments) {
        this.logStatus("Requesting " + nrAlignments + " alignments to be calculated");
        this.progressBar.setMaximum(nrAlignments);
        this.progressBar.setValue(0);
        GUIAlignmentProgressListener gUIAlignmentProgressListener = this;
        synchronized (gUIAlignmentProgressListener) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentResultsToServer(int nrAlignments, String serverMessage) {
        this.logStatus("sent alignment results back to server. Server responded: >" + serverMessage + "<");
        this.progressBar.setValue(0);
        GUIAlignmentProgressListener gUIAlignmentProgressListener = this;
        synchronized (gUIAlignmentProgressListener) {
            this.notifyAll();
        }
    }
}

