/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.gui.AlignmentTextPanel;
import org.biojava.nbio.structure.align.gui.MenuCreator;
import org.biojava.nbio.structure.align.gui.aligpanel.AligPanel;
import org.biojava.nbio.structure.align.gui.aligpanel.StatusDisplay;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.JmolTools;
import org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AlignmentTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayAFP {
    private static final Logger logger = LoggerFactory.getLogger(DisplayAFP.class);

    public static final List<Integer> getEQRAlignmentPos(AFPChain afpChain) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        char[] s1 = afpChain.getAlnseq1();
        char[] s2 = afpChain.getAlnseq2();
        char[] symb = afpChain.getAlnsymb();
        boolean isFatCat = afpChain.getAlgorithmName().startsWith("jFatCat");
        for (int i = 0; i < s1.length; ++i) {
            char c1 = s1[i];
            char c2 = s2[i];
            if (!DisplayAFP.isAlignedPosition(i, c1, c2, isFatCat, symb)) continue;
            lst.add(i);
        }
        return lst;
    }

    private static boolean isAlignedPosition(int i, char c1, char c2, boolean isFatCat, char[] symb) {
        char s = symb[i];
        return c1 != '-' && c2 != '-' && s != ' ';
    }

    public static final List<String> getPDBresnum(int aligPos, AFPChain afpChain, Atom[] ca) {
        ArrayList<String> lst = new ArrayList<String>();
        if (aligPos > 1) {
            System.err.println("multiple alignments not supported yet!");
            return lst;
        }
        int blockNum = afpChain.getBlockNum();
        int[] optLen = afpChain.getOptLen();
        int[][][] optAln = afpChain.getOptAln();
        if (optLen == null) {
            return lst;
        }
        for (int bk = 0; bk < blockNum; ++bk) {
            for (int i = 0; i < optLen[bk]; ++i) {
                int pos = optAln[bk][aligPos][i];
                if (pos >= ca.length) continue;
                String pdbInfo = JmolTools.getPdbInfo(ca[pos]);
                lst.add(pdbInfo);
            }
        }
        return lst;
    }

    public static final Atom getAtomForAligPos(AFPChain afpChain, int chainNr, int aligPos, Atom[] ca, boolean getPrevious) throws StructureException {
        int[] optLen = afpChain.getOptLen();
        if (optLen == null) {
            return null;
        }
        if (chainNr < 0 || chainNr > 1) {
            throw new StructureException("So far only pairwise alignments are supported, but you requested results for alinged chain nr " + chainNr);
        }
        int capos = DisplayAFP.getUngappedFatCatPos(afpChain, chainNr, aligPos);
        if (capos < 0) {
            capos = DisplayAFP.getNextFatCatPos(afpChain, chainNr, aligPos, getPrevious);
        }
        if (capos < 0) {
            System.err.println("could not match position " + aligPos + " in chain " + chainNr + ". Returing null...");
            return null;
        }
        if (capos > ca.length) {
            System.err.println("Atom array " + chainNr + " does not have " + capos + " atoms. Returning null.");
            return null;
        }
        return ca[capos];
    }

    private static int getNextFatCatPos(AFPChain afpChain, int chainNr, int aligPos, boolean getPrevious) {
        char[] aseq = chainNr == 0 ? afpChain.getAlnseq1() : afpChain.getAlnseq2();
        if (aligPos > aseq.length) {
            return -1;
        }
        if (aligPos < 0) {
            return -1;
        }
        int blockNum = afpChain.getBlockNum();
        int[] optLen = afpChain.getOptLen();
        int[][][] optAln = afpChain.getOptAln();
        int p1b = 0;
        int p2b = 0;
        int len = 0;
        boolean terminateNextMatch = false;
        for (int i = 0; i < blockNum; ++i) {
            for (int j = 0; j < optLen[i]; ++j) {
                int p1 = optAln[i][0][j];
                int p2 = optAln[i][1][j];
                if (len > 0) {
                    int lmax = p1 - p1b - 1 > p2 - p2b - 1 ? p1 - p1b - 1 : p2 - p2b - 1;
                    for (int k = 0; k < lmax; ++k) {
                        if (k >= p1 - p1b - 1) {
                            if (aligPos == len && chainNr == 0) {
                                if (getPrevious) {
                                    return p1b;
                                }
                                terminateNextMatch = true;
                            }
                        } else if (aligPos == len && chainNr == 0) {
                            return p1b + 1 + k;
                        }
                        if (k >= p2 - p2b - 1) {
                            if (aligPos == len && chainNr == 1) {
                                if (getPrevious) {
                                    return p2b;
                                }
                                terminateNextMatch = true;
                            }
                        } else if (aligPos == len && chainNr == 1) {
                            return p2b + 1 + k;
                        }
                        ++len;
                    }
                }
                if (aligPos == len && chainNr == 0) {
                    return p1;
                }
                if (aligPos == len && chainNr == 1) {
                    return p2;
                }
                if (terminateNextMatch) {
                    if (chainNr == 0) {
                        return p1;
                    }
                    return p2;
                }
                if (len > aligPos) {
                    if (getPrevious) {
                        if (chainNr == 0) {
                            return p1b;
                        }
                        return p2b;
                    }
                    terminateNextMatch = true;
                }
                ++len;
                p1b = p1;
                p2b = p2;
            }
        }
        return -1;
    }

    private static final int getUngappedFatCatPos(AFPChain afpChain, int chainNr, int aligPos) {
        char[] aseq = chainNr == 0 ? afpChain.getAlnseq1() : afpChain.getAlnseq2();
        if (aligPos > aseq.length) {
            return -1;
        }
        if (aligPos < 0) {
            return -1;
        }
        int blockNum = afpChain.getBlockNum();
        int[] optLen = afpChain.getOptLen();
        int[][][] optAln = afpChain.getOptAln();
        int p1b = 0;
        int p2b = 0;
        int len = 0;
        for (int i = 0; i < blockNum; ++i) {
            for (int j = 0; j < optLen[i]; ++j) {
                int p1 = optAln[i][0][j];
                int p2 = optAln[i][1][j];
                if (len > 0) {
                    int lmax = p1 - p1b - 1 > p2 - p2b - 1 ? p1 - p1b - 1 : p2 - p2b - 1;
                    for (int k = 0; k < lmax; ++k) {
                        if (k >= p1 - p1b - 1) {
                            if (aligPos == len && chainNr == 0) {
                                return -1;
                            }
                        } else if (aligPos == len && chainNr == 0) {
                            return p1b + 1 + k;
                        }
                        if (k >= p2 - p2b - 1) {
                            if (aligPos == len && chainNr == 1) {
                                return -1;
                            }
                        } else if (aligPos == len && chainNr == 1) {
                            return p2b + 1 + k;
                        }
                        ++len;
                    }
                }
                if (aligPos == len && chainNr == 0) {
                    return p1;
                }
                if (aligPos == len && chainNr == 1) {
                    return p2;
                }
                ++len;
                p1b = p1;
                p2b = p2;
            }
        }
        return -1;
    }

    public static final Atom[] getAtomArray(Atom[] ca, List<Group> hetatms) throws StructureException {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        Collections.addAll(atoms, ca);
        logger.debug("got {} hetatoms", (Object)hetatms.size());
        for (Group g : hetatms) {
            if (g.size() < 1) continue;
            Atom a = g.getAtom(0);
            a.setGroup(g);
            atoms.add(a);
        }
        Atom[] arr = atoms.toArray(new Atom[atoms.size()]);
        return arr;
    }

    public static final StructureAlignmentJmol display(AFPChain afpChain, Group[] twistedGroups, Atom[] ca1, Atom[] ca2, List<Group> hetatms1, List<Group> hetatms2) throws StructureException {
        ArrayList<Atom> twistedAs = new ArrayList<Atom>();
        for (Group g : twistedGroups) {
            if (g == null || g.size() < 1) continue;
            Atom a = g.getAtom(0);
            twistedAs.add(a);
        }
        Atom[] twistedAtoms = twistedAs.toArray(new Atom[twistedAs.size()]);
        twistedAtoms = StructureTools.cloneAtomArray((Atom[])twistedAtoms);
        Atom[] arr1 = DisplayAFP.getAtomArray(ca1, hetatms1);
        Atom[] arr2 = DisplayAFP.getAtomArray(twistedAtoms, hetatms2);
        String title = afpChain.getAlgorithmName() + " V." + afpChain.getVersion() + " : " + afpChain.getName1() + " vs. " + afpChain.getName2();
        StructureAlignmentJmol jmol = new StructureAlignmentJmol(afpChain, arr1, arr2);
        System.out.format("CA2[0]=(%.2f,%.2f,%.2f)%n", arr2[0].getX(), arr2[0].getY(), arr2[0].getZ());
        jmol.setTitle(title);
        return jmol;
    }

    public static void showAlignmentPanel(AFPChain afpChain, Atom[] ca1, Atom[] ca2, AbstractAlignmentJmol jmol) throws StructureException {
        AligPanel me = new AligPanel();
        me.setAlignmentJmol(jmol);
        me.setAFPChain(afpChain);
        me.setCa1(ca1);
        me.setCa2(ca2);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.setTitle(afpChain.getName1() + " vs. " + afpChain.getName2() + " | " + afpChain.getAlgorithmName() + " V. " + afpChain.getVersion());
        me.setPreferredSize(new Dimension(me.getCoordManager().getPreferredWidth(), me.getCoordManager().getPreferredHeight()));
        JMenuBar menu = MenuCreator.getAlignmentPanelMenu(frame, me, afpChain, null);
        frame.setJMenuBar(menu);
        JScrollPane scroll = new JScrollPane(me);
        scroll.setAutoscrolls(true);
        StatusDisplay status = new StatusDisplay();
        status.setAfpChain(afpChain);
        status.setCa1(ca1);
        status.setCa2(ca2);
        me.addAlignmentPositionListener(status);
        Box vBox = Box.createVerticalBox();
        vBox.add(scroll);
        vBox.add(status);
        frame.getContentPane().add(vBox);
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(me);
        frame.addWindowListener(status);
    }

    public static void showAlignmentImage(AFPChain afpChain, String result) {
        JFrame frame = new JFrame();
        String title = afpChain.getAlgorithmName() + " V." + afpChain.getVersion() + " : " + afpChain.getName1() + " vs. " + afpChain.getName2();
        frame.setTitle(title);
        frame.setDefaultCloseOperation(2);
        AlignmentTextPanel txtPanel = new AlignmentTextPanel();
        txtPanel.setText(result);
        JMenuBar menu = MenuCreator.getAlignmentTextMenu(frame, txtPanel, afpChain, null);
        frame.setJMenuBar(menu);
        JScrollPane js = new JScrollPane();
        js.getViewport().add(txtPanel);
        js.getViewport().setBorder(null);
        frame.getContentPane().add(js);
        frame.pack();
        frame.setVisible(true);
    }

    public static Structure createArtificalStructure(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        if (afpChain.getNrEQR() < 1) {
            return AlignmentTools.getAlignedStructure((Atom[])ca1, (Atom[])ca2);
        }
        Group[] twistedGroups = AlignmentTools.prepareGroupsForDisplay((AFPChain)afpChain, (Atom[])ca1, (Atom[])ca2);
        ArrayList<Atom> twistedAs = new ArrayList<Atom>();
        for (Group g : twistedGroups) {
            if (g == null || g.size() < 1) continue;
            Atom a = g.getAtom(0);
            twistedAs.add(a);
        }
        Atom[] twistedAtoms = twistedAs.toArray(new Atom[twistedAs.size()]);
        List hetatms = StructureTools.getUnalignedGroups((Atom[])ca1);
        List hetatms2 = StructureTools.getUnalignedGroups((Atom[])ca2);
        Atom[] arr1 = DisplayAFP.getAtomArray(ca1, hetatms);
        Atom[] arr2 = DisplayAFP.getAtomArray(twistedAtoms, hetatms2);
        Structure artificial = AlignmentTools.getAlignedStructure((Atom[])arr1, (Atom[])arr2);
        return artificial;
    }
}

