/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.jmol;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.structure.align.gui.jmol.AtomInfoParser;

public class AtomInfo {
    String chainId;
    String atomName;
    String residueName;
    String residueNumber;
    int modelNumber;
    private static Pattern inscodePatter = Pattern.compile("([0-9]+)([a-zA-Z]*)?");

    public static AtomInfo fromString(String atomInfo) {
        return AtomInfoParser.parse(atomInfo);
    }

    public int getModelNumber() {
        return this.modelNumber;
    }

    public void setModelNumber(int modelNumber) {
        this.modelNumber = modelNumber;
    }

    public String getResidueName() {
        return this.residueName;
    }

    public void setResidueName(String residueName) {
        this.residueName = residueName;
    }

    public String getResidueNumber() {
        return this.residueNumber;
    }

    public void setResidueNumber(String residueNumber) {
        this.residueNumber = residueNumber;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public String getAtomName() {
        return this.atomName;
    }

    public void setAtomName(String name) {
        this.atomName = name;
    }

    public String toString() {
        String aa3 = "";
        boolean printResName = true;
        String chain1 = "";
        String res1 = "";
        aa3 = this.residueName;
        res1 = this.residueNumber;
        chain1 = this.chainId;
        StringBuffer buf = new StringBuffer();
        if (printResName && !"".equals(aa3)) {
            buf.append("[");
            buf.append(aa3);
            buf.append("]");
        }
        if (!"".equals(res1)) {
            Matcher matcher = inscodePatter.matcher(res1);
            boolean found = matcher.find();
            if (!found) {
                System.err.println("JmolTools: could not parse the residue number string " + res1);
                buf.append(res1);
            } else {
                String residueNumber = matcher.group(1);
                String insCode = matcher.group(2);
                buf.append(residueNumber);
                if (insCode != null && !"".equals(insCode)) {
                    buf.append("^");
                    buf.append(insCode);
                }
            }
        }
        if (!"".equals(chain1)) {
            buf.append(":");
            buf.append(chain1);
        }
        if (this.atomName != null) {
            buf.append(".");
            buf.append(this.atomName);
        }
        if (this.modelNumber > 0) {
            buf.append("/");
            buf.append(this.modelNumber);
        }
        return buf.toString();
    }
}

