/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.align.gui.AlignmentGui;
import org.biojava.nbio.structure.gui.BiojavaJmol;
import org.biojava.nbio.structure.io.PDBFileReader;

public class MenuCreator {
    public static JMenuBar initMenu() {
        JMenuBar menu = new JMenuBar();
        JMenu file = new JMenu("File");
        file.getAccessibleContext().setAccessibleDescription("File Menu");
        JMenuItem openI = new JMenuItem("Open");
        openI.setMnemonic(79);
        openI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc;
                int returnVal;
                String cmd = e.getActionCommand();
                if ("Open".equals(cmd) && (returnVal = (fc = new JFileChooser()).showOpenDialog(null)) == 0) {
                    File file = fc.getSelectedFile();
                    PDBFileReader reader = new PDBFileReader();
                    try {
                        Structure s = reader.getStructure(file);
                        BiojavaJmol jmol = new BiojavaJmol();
                        jmol.setStructure(s);
                        jmol.evalString("select * ; color chain;");
                        jmol.evalString("select *; spacefill off; wireframe off; backbone 0.4;  ");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        file.add(openI);
        JMenuItem exitI = new JMenuItem("Exit");
        exitI.setMnemonic(88);
        exitI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if ("Exit".equals(cmd)) {
                    System.exit(0);
                }
            }
        });
        file.add(exitI);
        menu.add(file);
        JMenu align = new JMenu("Align");
        JMenuItem pairI = new JMenuItem("2 protein structures");
        pairI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if ("2 protein structures".equals(cmd)) {
                    MenuCreator.showPairDialog();
                }
            }
        });
        align.add(pairI);
        menu.add(align);
        JMenu about = new JMenu("About");
        JMenuItem aboutI = new JMenuItem("PDBview");
        aboutI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if ("PDBview".equals(cmd)) {
                    MenuCreator.showAboutDialog();
                }
            }
        });
        about.add(aboutI);
        menu.add(Box.createGlue());
        menu.add(about);
        return menu;
    }

    private static void showPairDialog() {
        AlignmentGui gui = AlignmentGui.getInstance();
        gui.setVisible(true);
    }

    private static void showAboutDialog() {
        JDialog dialog = new JDialog();
        dialog.setSize(new Dimension(300, 300));
        Object msg = "This viewer is based on <b>BioJava</b> and <b>Jmol</>. <br>Author: Andreas Prlic <br> ";
        msg = (String)msg + "Structure Alignment algorithm based on a variation of the PSC++ algorithm by Peter Lackner.";
        JEditorPane txt = new JEditorPane("text/html", (String)msg);
        txt.setEditable(false);
        JScrollPane scroll = new JScrollPane(txt);
        Box vBox = Box.createVerticalBox();
        vBox.add(scroll);
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                JButton but = (JButton)source;
                Container parent = but.getParent().getParent().getParent().getParent().getParent().getParent();
                JDialog dia = (JDialog)parent;
                dia.dispose();
            }
        });
        Box hBoxb = Box.createHorizontalBox();
        hBoxb.add(Box.createGlue());
        hBoxb.add((Component)close, "East");
        vBox.add(hBoxb);
        dialog.getContentPane().add(vBox);
        dialog.setVisible(true);
    }
}

