/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.align.MultipleStructureAligner;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.StructureAlignmentFactory;
import org.biojava.nbio.structure.align.ce.AbstractUserArgumentProcessor;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.gui.AlignmentCalculationRunnable;
import org.biojava.nbio.structure.align.gui.MenuCreator;
import org.biojava.nbio.structure.align.gui.MultipleAlignmentCalc;
import org.biojava.nbio.structure.align.gui.ParameterGUI;
import org.biojava.nbio.structure.align.gui.ProgressThreadDrawer;
import org.biojava.nbio.structure.align.multiple.mc.MultipleMcMain;
import org.biojava.nbio.structure.align.webstart.AligUIManager;
import org.biojava.nbio.structure.gui.util.SelectMultiplePanel;

public class MultipleAlignmentGUI
extends JFrame {
    private static final long serialVersionUID = 0L;
    private static final String version = "1.0";
    private MultipleStructureAligner multiple;
    private StructureAlignment pairwise;
    private SelectMultiplePanel tab;
    private JTabbedPane tabPane;
    private Thread thread = null;
    private AlignmentCalculationRunnable alicalc;
    private JProgressBar progress;
    private JButton abortB;
    private static final String MAIN_TITLE = "Multiple Structure Alignment - Main - V.1.0";
    private static final MultipleAlignmentGUI me = new MultipleAlignmentGUI();

    public static void main(String[] args) {
        MultipleAlignmentGUI.getInstance();
    }

    public static MultipleAlignmentGUI getInstance() {
        AbstractUserArgumentProcessor.printAboutMe();
        AligUIManager.setLookAndFeel();
        if (!me.isVisible()) {
            me.setVisible(true);
        }
        if (!me.isActive()) {
            me.requestFocus();
        }
        return me;
    }

    public static MultipleAlignmentGUI getInstanceNoVisibilityChange() {
        return me;
    }

    protected MultipleAlignmentGUI() {
        JMenuBar menu = MenuCreator.initAlignmentGUIMenu(this);
        this.setJMenuBar(menu);
        this.setDefaultCloseOperation(3);
        this.setTitle(MAIN_TITLE);
        this.tab = new SelectMultiplePanel();
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Select Structures", null, this.tab, "Input Structure identifiers");
        Box hBoxPair = this.setupPairwiseAlgorithm();
        Box hBoxMult = this.setupMultipleAlgorithm();
        Box vBox = Box.createVerticalBox();
        vBox.add(this.tabPane);
        vBox.add(Box.createGlue());
        Box vBoxMain = Box.createVerticalBox();
        vBoxMain.add(hBoxPair);
        vBoxMain.add(hBoxMult);
        vBoxMain.add(this.tabPane);
        vBoxMain.add(this.initButtons());
        this.getContentPane().add(vBoxMain);
        this.pack();
        this.setVisible(true);
    }

    private Box setupPairwiseAlgorithm() {
        String[] pairAlgo = StructureAlignmentFactory.getAllAlgorithmNames();
        try {
            this.pairwise = StructureAlignmentFactory.getAlgorithm((String)pairAlgo[0]);
        }
        catch (StructureException e) {
            e.printStackTrace();
        }
        JLabel algoLabel = new JLabel("Select pairwise aligner: ");
        JComboBox<String> algorithmList = new JComboBox<String>(pairAlgo);
        algorithmList.setSelectedIndex(0);
        AbstractAction actionAlgorithm = new AbstractAction("Algorithm"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                JComboBox cb = (JComboBox)evt.getSource();
                String algorithmName = (String)cb.getSelectedItem();
                MultipleAlignmentGUI.this.updatePairwiseAlgorithm(algorithmName);
            }
        };
        algorithmList.addActionListener(actionAlgorithm);
        AbstractAction paramAction = new AbstractAction("Parameters"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureAlignment p = MultipleAlignmentGUI.this.getPairwiseStructureAligner();
                ConfigStrucAligParams params = p.getParameters();
                new ParameterGUI(params, p.getAlgorithmName());
            }
        };
        JButton parameterButton = new JButton(paramAction);
        Box hBoxAlgoPair = Box.createHorizontalBox();
        hBoxAlgoPair.add(Box.createGlue());
        hBoxAlgoPair.add(algoLabel);
        hBoxAlgoPair.add(algorithmList);
        hBoxAlgoPair.add(Box.createGlue());
        hBoxAlgoPair.add(parameterButton);
        hBoxAlgoPair.add(Box.createGlue());
        return hBoxAlgoPair;
    }

    private Box setupMultipleAlgorithm() {
        String[] multAlgo = new String[]{"jMultipleMC"};
        this.multiple = new MultipleMcMain(this.pairwise);
        JLabel multLabel = new JLabel("Select multiple aligner: ");
        JComboBox<String> multList = new JComboBox<String>(multAlgo);
        multList.setSelectedIndex(0);
        AbstractAction actionMultiple = new AbstractAction("Algorithm"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleAlignmentGUI.this.updateMultipleAlgorithm();
            }
        };
        multList.addActionListener(actionMultiple);
        AbstractAction paramAction = new AbstractAction("Parameters"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleStructureAligner m = MultipleAlignmentGUI.this.getMultipleStructureAligner();
                ConfigStrucAligParams params = m.getParameters();
                new ParameterGUI(params, m.getAlgorithmName());
            }
        };
        JButton parameterButton = new JButton(paramAction);
        Box hBoxAlgo = Box.createHorizontalBox();
        hBoxAlgo.add(Box.createGlue());
        hBoxAlgo.add(multLabel);
        hBoxAlgo.add(multList);
        hBoxAlgo.add(Box.createGlue());
        hBoxAlgo.add(parameterButton);
        hBoxAlgo.add(Box.createGlue());
        return hBoxAlgo;
    }

    private Box initButtons() {
        this.progress = new JProgressBar();
        this.progress.setIndeterminate(false);
        this.progress.setMaximumSize(new Dimension(10, 100));
        this.progress.setVisible(false);
        AbstractAction action1 = new AbstractAction("Align"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleAlignmentGUI.this.calcAlignment();
            }
        };
        JButton submitB = new JButton(action1);
        AbstractAction action3 = new AbstractAction("Abort"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleAlignmentGUI.this.abortCalc();
            }
        };
        this.abortB = new JButton(action3);
        this.abortB.setEnabled(false);
        AbstractAction action2 = new AbstractAction("Exit"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleAlignmentGUI.this.abortCalc();
                MultipleAlignmentGUI.this.dispose();
                System.exit(0);
            }
        };
        JButton closeB = new JButton(action2);
        Box hBox = Box.createHorizontalBox();
        hBox.add(closeB);
        hBox.add(Box.createGlue());
        hBox.add(this.progress);
        hBox.add(this.abortB);
        hBox.add(submitB);
        return hBox;
    }

    public void cleanUp() {
        if (this.alicalc != null) {
            this.alicalc.cleanup();
        }
    }

    private void calcAlignment() {
        try {
            List<Structure> structures = this.tab.getStructures();
            if (structures.size() < 2) {
                System.err.println("please input more than 1 structure");
                return;
            }
            List<StructureIdentifier> names = this.tab.getNames();
            Object message = "aligning: ";
            for (StructureIdentifier name : names) {
                message = (String)message + name.getIdentifier() + " ";
            }
            System.out.println((String)message);
            this.alicalc = new MultipleAlignmentCalc(this, structures, names);
            this.thread = new Thread(this.alicalc);
            this.thread.start();
            this.abortB.setEnabled(true);
            this.progress.setIndeterminate(true);
            ProgressThreadDrawer drawer = new ProgressThreadDrawer(this.progress);
            drawer.start();
        }
        catch (StructureException e) {
            JOptionPane.showMessageDialog(null, "Could not align structures. Exception: " + e.getMessage());
        }
    }

    public void notifyCalcFinished() {
        this.abortB.setEnabled(false);
        this.thread = null;
        this.progress.setIndeterminate(false);
        this.repaint();
    }

    private void abortCalc() {
        System.err.println("Interrupting alignment ...");
        if (this.alicalc != null) {
            this.alicalc.interrupt();
        }
        this.notifyCalcFinished();
    }

    public MultipleStructureAligner getMultipleStructureAligner() {
        return this.multiple;
    }

    public StructureAlignment getPairwiseStructureAligner() {
        return this.pairwise;
    }

    private void updatePairwiseAlgorithm(String algorithmName) {
        try {
            this.pairwise = StructureAlignmentFactory.getAlgorithm((String)algorithmName);
            ConfigStrucAligParams params = this.multiple.getParameters();
            this.updateMultipleAlgorithm();
            this.multiple.setParameters(params);
        }
        catch (StructureException ex) {
            ex.printStackTrace();
        }
    }

    private void updateMultipleAlgorithm() {
        this.multiple = new MultipleMcMain(this.pairwise);
    }
}

