/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.jmol;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.structure.align.gui.jmol.AtomInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomInfoParser {
    private static final Logger logger = LoggerFactory.getLogger(AtomInfoParser.class);
    static Pattern pattern;

    public static void main(String[] args) {
        String s1 = "[GLY]371:A.CA #2811";
        String s2 = "[ASP]1^A:A.CA/2 #2";
        System.out.println(s1 + " got: " + String.valueOf(AtomInfoParser.parse(s1)));
        System.out.println(s2 + " got: " + String.valueOf(AtomInfoParser.parse(s2)));
    }

    public static AtomInfo parse(String jmolAtomInfo) {
        Matcher matcher = pattern.matcher(jmolAtomInfo);
        boolean found = matcher.find();
        if (!found) {
            logger.info("Could not parse the atomInfo string {}", (Object)jmolAtomInfo);
            return new AtomInfo();
        }
        String residueName = matcher.group(1);
        String residueNumber = matcher.group(2);
        String chainId = matcher.group(3);
        String atomName = matcher.group(4);
        String modelNumber = matcher.group(5);
        AtomInfo info = new AtomInfo();
        info.setAtomName(atomName);
        info.setResidueName(residueName);
        info.setResidueNumber(residueNumber.replaceAll("\\^", ""));
        String ci = " ";
        if (chainId != null) {
            ci = chainId.substring(1, chainId.length());
        }
        info.setChainId(ci);
        int mn = 1;
        if (modelNumber != null) {
            mn = Integer.parseInt(modelNumber.substring(1, modelNumber.length()));
        }
        info.setModelNumber(mn);
        return info;
    }

    static {
        String numberPattern = "\\[(.*)\\]([0-9^a-zA-Z]+)(:[a-zA-Z]*)?\\.([a-zA-Z]+)(/[0-9]*)?";
        pattern = Pattern.compile(numberPattern);
    }
}

