/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.jmolScript;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.symmetry.axis.RotationAxisAligner;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySubunits;
import org.biojava.nbio.structure.symmetry.core.Rotation;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;
import org.biojava.nbio.structure.symmetry.geometry.Polyhedron;
import org.biojava.nbio.structure.symmetry.jmolScript.ColorConverter;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGenerator;
import org.jcolorbrewer.ColorBrewer;

public abstract class JmolSymmetryScriptGeneratorPointGroup
extends JmolSymmetryScriptGenerator {
    private static String N_FOLD_AXIS_COLOR = "red";
    private static String TWO_FOLD_AXIS_COLOR = "deepskyblue";
    private static String THREE_FOLD_AXIS_COLOR = "lime";
    private static double AXIS_SCALE_FACTOR = 1.2;
    private RotationAxisAligner rotationAxisAligner = null;
    private RotationGroup rotationGroup = null;
    private Polyhedron polyhedron = null;
    private String name = "";
    private String defaultColoring = "";
    private boolean onTheFly = true;

    public JmolSymmetryScriptGeneratorPointGroup(RotationAxisAligner rotationAxisAligner, String name) {
        this.rotationAxisAligner = rotationAxisAligner;
        this.rotationGroup = this.rotationAxisAligner.getRotationGroup();
        this.name = name;
    }

    @Override
    public abstract int getZoom();

    @Override
    public void setOnTheFly(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    @Override
    public String getDefaultOrientation() {
        StringBuilder s = new StringBuilder();
        s.append(this.setCentroid());
        Quat4d q = new Quat4d();
        q.set(this.polyhedron.getViewMatrix(0));
        q.normalize();
        Quat4d r = new Quat4d();
        r.set(this.rotationAxisAligner.getRotationMatrix());
        r.normalize();
        q.mul(r);
        q.normalize();
        s.append("moveto 0 quaternion{");
        s.append(JmolSymmetryScriptGeneratorPointGroup.jMolFloat(q.x));
        s.append(",");
        s.append(JmolSymmetryScriptGeneratorPointGroup.jMolFloat(q.y));
        s.append(",");
        s.append(JmolSymmetryScriptGeneratorPointGroup.jMolFloat(q.z));
        s.append(",");
        s.append(JmolSymmetryScriptGeneratorPointGroup.jMolFloat(q.w));
        s.append("};");
        return s.toString();
    }

    @Override
    public int getOrientationCount() {
        return this.polyhedron.getViewCount();
    }

    @Override
    public String getOrientation(int index) {
        StringBuilder s = new StringBuilder();
        s.append(this.setCentroid());
        Quat4d q = new Quat4d();
        q.set(this.polyhedron.getViewMatrix(index));
        q.normalize();
        Quat4d r = new Quat4d();
        r.set(this.rotationAxisAligner.getRotationMatrix());
        r.normalize();
        q.mul(r);
        q.normalize();
        s.append("moveto 4 quaternion{");
        s.append(JmolSymmetryScriptGeneratorPointGroup.jMolFloat(q.x));
        s.append(",");
        s.append(JmolSymmetryScriptGeneratorPointGroup.jMolFloat(q.y));
        s.append(",");
        s.append(JmolSymmetryScriptGeneratorPointGroup.jMolFloat(q.z));
        s.append(",");
        s.append(JmolSymmetryScriptGeneratorPointGroup.jMolFloat(q.w));
        s.append("}");
        s.append(";");
        return s.toString();
    }

    @Override
    public String getOrientationWithZoom(int index) {
        StringBuilder s = new StringBuilder();
        s.append(this.getOrientation(index));
        s.insert(s.length() - 1, this.getZoom());
        return s.toString();
    }

    @Override
    public String getOrientationName(int index) {
        return this.polyhedron.getViewName(index);
    }

    @Override
    public Matrix4d getTransformation() {
        return this.rotationAxisAligner.getTransformation();
    }

    @Override
    public void setDefaultColoring(String colorScript) {
        this.defaultColoring = colorScript;
    }

    @Override
    public String drawPolyhedron() {
        StringBuilder s = new StringBuilder();
        Point3d[] vertices = this.getPolyhedronVertices();
        int index = 0;
        double width = this.getMaxExtension() * 0.015;
        for (int[] lineLoop : this.polyhedron.getLineLoops()) {
            s.append("draw polyhedron");
            s.append(this.name);
            s.append(index++);
            s.append(" line");
            for (int i : lineLoop) {
                s.append(JmolSymmetryScriptGeneratorPointGroup.getJmolPoint((Tuple3d)vertices[i]));
            }
            s.append("width ");
            s.append(JmolSymmetryScriptGeneratorPointGroup.fDot2(width));
            s.append(" color");
            Color4f c = this.getPolyhedronColor();
            s.append(JmolSymmetryScriptGeneratorPointGroup.getJmolColor(c));
            s.append(" off;");
        }
        return s.toString();
    }

    @Override
    public String hidePolyhedron() {
        return "draw polyhedron* off;";
    }

    @Override
    public String showPolyhedron() {
        return "draw polyhedron* on;";
    }

    @Override
    public String drawAxes() {
        if ("C1".equals(this.rotationGroup.getPointGroup())) {
            return this.drawInertiaAxes();
        }
        return this.drawSymmetryAxes();
    }

    @Override
    public String hideAxes() {
        return "draw axes* off;";
    }

    @Override
    public String showAxes() {
        return "draw axes* on;";
    }

    @Override
    public String playOrientations() {
        StringBuilder s = new StringBuilder();
        if ("C1".equals(this.rotationGroup.getPointGroup())) {
            s.append(this.drawFooter("Asymmetric", "white"));
        } else {
            s.append(this.drawFooter("Point group " + this.rotationGroup.getPointGroup(), "white"));
        }
        s.append(this.drawPolyhedron());
        s.append(this.showPolyhedron());
        s.append(this.drawAxes());
        s.append(this.showAxes());
        for (int i = 0; i < this.getOrientationCount(); ++i) {
            s.append(this.deleteHeader());
            s.append(this.getOrientationWithZoom(i));
            s.append(this.drawHeader(this.polyhedron.getViewName(i), "white"));
            s.append("delay 4;");
        }
        s.append(this.deleteHeader());
        s.append(this.getOrientationWithZoom(0));
        s.append(this.drawHeader(this.polyhedron.getViewName(0), "white"));
        return s.toString();
    }

    @Override
    public String colorBySubunit() {
        QuatSymmetrySubunits subunits = this.rotationAxisAligner.getSubunits();
        List modelNumbers = subunits.getModelNumbers();
        List chainIds = subunits.getChainIds();
        List orbits = this.rotationAxisAligner.getOrbits();
        int fold = this.rotationGroup.getRotation(0).getFold();
        Color[] col = null;
        Color4f[] colors = null;
        if (fold > 1) {
            col = ColorBrewer.Spectral.getColorPalette(2 * fold);
            colors = ColorConverter.convertColor4f(col);
        } else {
            col = ColorBrewer.Spectral.getColorPalette(orbits.size());
            colors = ColorConverter.convertColor4f(col);
        }
        int half = colors.length / 2;
        for (int i = 0; i < half; ++i) {
            if (i % 2 == 0) continue;
            Color4f temp = colors[i];
            colors[i] = colors[half + i];
            colors[half + i] = temp;
        }
        HashMap<Color4f, List<String>> colorMap = new HashMap<Color4f, List<String>>();
        for (int i = 0; i < orbits.size(); ++i) {
            for (int j = 0; j < fold; ++j) {
                int colorIndex = i;
                if (fold > 1) {
                    colorIndex = i % 2 == 0 ? j : fold + j;
                }
                int subunit = (Integer)((List)orbits.get(i)).get(j);
                Color4f c = colors[colorIndex];
                ArrayList<String> ids = (ArrayList<String>)colorMap.get(c);
                if (ids == null) {
                    ids = new ArrayList<String>();
                    colorMap.put(c, ids);
                }
                String id = this.getChainSpecification(modelNumbers, chainIds, subunit);
                ids.add(id);
            }
        }
        return this.defaultColoring + JmolSymmetryScriptGeneratorPointGroup.getJmolColorScript(colorMap) + JmolSymmetryScriptGeneratorPointGroup.getJmolLigandScript();
    }

    @Override
    public String colorBySequenceCluster() {
        QuatSymmetrySubunits subunits = this.rotationAxisAligner.getSubunits();
        int n = subunits.getSubunitCount();
        List modelNumbers = subunits.getModelNumbers();
        List chainIds = subunits.getChainIds();
        List seqClusterIds = subunits.getClusterIds();
        int clusters = (Integer)Collections.max(seqClusterIds) + 1;
        Color[] col = ColorBrewer.BrBG.getColorPalette(clusters);
        Color4f[] colors = ColorConverter.convertColor4f(col);
        HashMap<Color4f, List<String>> colorMap = new HashMap<Color4f, List<String>>();
        for (int i = 0; i < n; ++i) {
            Color4f c = colors[(Integer)seqClusterIds.get(i)];
            ArrayList<String> ids = (ArrayList<String>)colorMap.get(c);
            if (ids == null) {
                ids = new ArrayList<String>();
                colorMap.put(c, ids);
            }
            String id = this.getChainSpecification(modelNumbers, chainIds, i);
            ids.add(id);
        }
        return this.defaultColoring + JmolSymmetryScriptGeneratorPointGroup.getJmolColorScript(colorMap) + JmolSymmetryScriptGeneratorPointGroup.getJmolLigandScript();
    }

    @Override
    public String colorBySymmetry() {
        String pointGroup = this.rotationGroup.getPointGroup();
        QuatSymmetrySubunits subunits = this.rotationAxisAligner.getSubunits();
        List modelNumbers = subunits.getModelNumbers();
        List chainIds = subunits.getChainIds();
        List orbits = this.rotationAxisAligner.getOrbits();
        int n = subunits.getSubunitCount();
        int fold = this.rotationGroup.getRotation(0).getFold();
        HashMap<Color4f, List<String>> colorMap = new HashMap();
        if (pointGroup.startsWith("C") && n == fold) {
            colorMap = this.getCnColorMap();
        } else if (pointGroup.startsWith("D") && orbits.size() > 2 || "T".equals(pointGroup) || "O".equals(pointGroup) || "I".equals(pointGroup)) {
            int nColor = 0;
            nColor = orbits.size() % 2 == 0 ? orbits.size() / 2 : (orbits.size() + 1) / 2;
            Color4f[] colors = this.getSymmetryColors(nColor);
            for (int i = 0; i < orbits.size(); ++i) {
                Color4f c;
                ArrayList<String> ids;
                int colorIndex = i;
                if (i >= nColor) {
                    colorIndex = orbits.size() - 1 - i;
                }
                if ((ids = (ArrayList<String>)colorMap.get(c = colors[colorIndex])) == null) {
                    ids = new ArrayList<String>();
                    colorMap.put(c, ids);
                }
                Iterator iterator = ((List)orbits.get(i)).iterator();
                while (iterator.hasNext()) {
                    int subunit = (Integer)iterator.next();
                    String id = this.getChainSpecification(modelNumbers, chainIds, subunit);
                    ids.add(id);
                }
            }
        } else {
            Color4f[] colors = this.getSymmetryColors(orbits.size());
            for (int i = 0; i < orbits.size(); ++i) {
                Color4f c = new Color4f(colors[i]);
                ArrayList<String> ids = (ArrayList<String>)colorMap.get(c);
                if (ids == null) {
                    ids = new ArrayList<String>();
                    colorMap.put(c, ids);
                }
                List orbit = (List)orbits.get(i);
                for (int j = 0; j < orbit.size(); ++j) {
                    String id = this.getChainSpecification(modelNumbers, chainIds, (Integer)orbit.get(j));
                    ids.add(id);
                }
            }
        }
        return this.defaultColoring + JmolSymmetryScriptGeneratorPointGroup.getJmolColorScript(colorMap) + JmolSymmetryScriptGeneratorPointGroup.getJmolLigandScript();
    }

    protected double getMaxExtension() {
        Vector3d dimension = this.rotationAxisAligner.getDimension();
        double maxExtension = Math.max(dimension.x, dimension.y);
        maxExtension = Math.max(maxExtension, dimension.z);
        return maxExtension;
    }

    protected double getMeanExtension() {
        Vector3d dimension = this.rotationAxisAligner.getDimension();
        return (dimension.x + dimension.y + dimension.z) / 3.0;
    }

    protected RotationAxisAligner getAxisTransformation() {
        return this.rotationAxisAligner;
    }

    protected void setAxisTransformation(RotationAxisAligner axisTransformation) {
        this.rotationAxisAligner = axisTransformation;
    }

    protected RotationGroup getRotationGroup() {
        return this.rotationGroup;
    }

    protected void setRotationGroup(RotationGroup rotationGroup) {
        this.rotationGroup = rotationGroup;
    }

    protected Polyhedron getPolyhedron() {
        return this.polyhedron;
    }

    protected void setPolyhedron(Polyhedron polyhedron) {
        this.polyhedron = polyhedron;
    }

    private String getChainSpecification(List<Integer> modelNumbers, List<String> chainIds, int subunit) {
        if (this.onTheFly) {
            if (Collections.max(modelNumbers) > 1) {
                return chainIds.get(subunit) + "&symop=" + (modelNumbers.get(subunit) + 1);
            }
            return chainIds.get(subunit);
        }
        return chainIds.get(subunit) + "/" + (modelNumbers.get(subunit) + 1);
    }

    private Map<Color4f, List<String>> getCnColorMap() {
        QuatSymmetrySubunits subunits = this.rotationAxisAligner.getSubunits();
        List modelNumbers = subunits.getModelNumbers();
        List chainIds = subunits.getChainIds();
        List orbits = this.rotationAxisAligner.getOrbits();
        int fold = this.rotationGroup.getRotation(0).getFold();
        HashMap<Color4f, List<String>> colorMap = new HashMap<Color4f, List<String>>();
        Color4f[] colors = this.getSymmetryColors(fold);
        for (List orbit : orbits) {
            for (int i = 0; i < fold; ++i) {
                int subunit = (Integer)orbit.get(i);
                String id = null;
                id = this.getChainSpecification(modelNumbers, chainIds, subunit);
                Color4f c = colors[i];
                ArrayList<String> ids = (ArrayList<String>)colorMap.get(c);
                if (ids == null) {
                    ids = new ArrayList<String>();
                    colorMap.put(c, ids);
                }
                ids.add(id);
            }
        }
        return colorMap;
    }

    private Point3d[] getPolyhedronVertices() {
        Point3d[] vertices = this.polyhedron.getVertices();
        Matrix4d reverseTransformation = this.rotationAxisAligner.getGeometicCenterTransformation();
        for (int i = 0; i < vertices.length; ++i) {
            reverseTransformation.transform(vertices[i]);
        }
        return vertices;
    }

    private Color4f getPolyhedronColor() {
        Color4f[] colors = this.getSymmetryColors(5);
        Color4f strongestColor = colors[4];
        Color4f complement = new Color4f(Color.WHITE);
        complement.sub((Tuple4f)strongestColor);
        return complement;
    }

    private Color4f[] getSymmetryColors(int nColors) {
        String pointGroup = this.rotationGroup.getPointGroup();
        Color[] col = null;
        Color4f[] colors = null;
        if ("C1".equals(pointGroup)) {
            col = ColorBrewer.Greys.getColorPalette(nColors);
            colors = ColorConverter.convertColor4f(col);
        } else if (pointGroup.startsWith("C")) {
            col = ColorBrewer.YlGnBu.getColorPalette(nColors);
            colors = ColorConverter.convertColor4f(col);
        } else if (pointGroup.startsWith("D")) {
            col = ColorBrewer.YlOrRd.getColorPalette(nColors);
            colors = ColorConverter.convertColor4f(col);
        } else if ("T".equals(pointGroup)) {
            col = ColorBrewer.Greens.getColorPalette(nColors);
            colors = ColorConverter.convertColor4f(col);
        } else if ("O".equals(pointGroup)) {
            col = ColorBrewer.Blues.getColorPalette(nColors);
            colors = ColorConverter.convertColor4f(col);
        } else if ("I".equals(pointGroup)) {
            col = ColorBrewer.BuPu.getColorPalette(nColors);
            colors = ColorConverter.convertColor4f(col);
        } else {
            col = ColorBrewer.Greys.getColorPalette(nColors);
            colors = ColorConverter.convertColor4f(col);
        }
        System.arraycopy(colors, 0, colors, 0, nColors);
        return colors;
    }

    private String drawInertiaAxes() {
        StringBuilder s = new StringBuilder();
        Point3d centroid = this.rotationAxisAligner.getGeometricCenter();
        Vector3d[] axes = this.rotationAxisAligner.getPrincipalAxesOfInertia();
        for (int i = 0; i < axes.length; ++i) {
            s.append("draw axesInertia");
            s.append(this.name);
            s.append(i);
            s.append(" ");
            s.append("line");
            Point3d v1 = new Point3d((Tuple3d)axes[i]);
            if (i == 0) {
                v1.scale(AXIS_SCALE_FACTOR * this.rotationAxisAligner.getDimension().y);
            } else if (i == 1) {
                v1.scale(AXIS_SCALE_FACTOR * this.rotationAxisAligner.getDimension().x);
            } else if (i == 2) {
                v1.scale(AXIS_SCALE_FACTOR * this.rotationAxisAligner.getDimension().z);
            }
            Point3d v2 = new Point3d(v1);
            v2.negate();
            v1.add((Tuple3d)centroid);
            v2.add((Tuple3d)centroid);
            s.append(JmolSymmetryScriptGeneratorPointGroup.getJmolPoint((Tuple3d)v1));
            s.append(JmolSymmetryScriptGeneratorPointGroup.getJmolPoint((Tuple3d)v2));
            s.append("width 0.5 ");
            s.append(" color white");
            s.append(" off;");
        }
        return s.toString();
    }

    private String drawSymmetryAxes() {
        StringBuilder s = new StringBuilder();
        int n = this.rotationGroup.getOrder();
        if (n == 0) {
            return s.toString();
        }
        float diameter = 0.5f;
        double radius = 0.0;
        String color = "";
        List<Rotation> axes = this.getUniqueAxes();
        int i = 0;
        for (Rotation r : axes) {
            if (this.rotationGroup.getPointGroup().startsWith("C") || this.rotationGroup.getPointGroup().startsWith("D") && r.getDirection() == 0) {
                radius = this.rotationAxisAligner.getDimension().z;
                color = N_FOLD_AXIS_COLOR;
            } else {
                radius = this.polyhedron.getCirumscribedRadius();
                color = r.getFold() == 2 ? TWO_FOLD_AXIS_COLOR : (r.getFold() == 3 ? THREE_FOLD_AXIS_COLOR : N_FOLD_AXIS_COLOR);
            }
            Point3d center = this.rotationAxisAligner.getGeometricCenter();
            AxisAngle4d axisAngle = r.getAxisAngle();
            Vector3d axis = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
            Vector3d refAxis = this.rotationAxisAligner.getRotationReferenceAxis();
            s.append(this.getSymmetryAxis(i, i + axes.size(), this.rotationGroup.getPointGroup(), r.getFold(), refAxis, radius, diameter, color, center, axis));
            ++i;
        }
        return s.toString();
    }

    private Vector3d getAlignmentVector(Point3d point, Vector3d axis) {
        if (this.rotationGroup.getPointGroup().startsWith("C") || this.rotationGroup.getPointGroup().startsWith("D")) {
            if (axis.dot(this.rotationAxisAligner.getPrincipalRotationAxis()) < 0.1) {
                return this.rotationAxisAligner.getPrincipalRotationAxis();
            }
            return this.rotationAxisAligner.getRotationReferenceAxis();
        }
        Vector3d ref = new Vector3d();
        double dSqThreshold = 25.0;
        double dSqMin = Double.MAX_VALUE;
        Point3d refPoint = null;
        for (Point3d v : this.getPolyhedronVertices()) {
            double dSq = point.distanceSquared(v);
            if (!(dSq > dSqThreshold) || !(dSq < dSqMin)) continue;
            dSqMin = dSq;
            refPoint = v;
        }
        ref.sub((Tuple3d)point, refPoint);
        ref.cross(axis, ref);
        ref.cross(axis, ref);
        ref.normalize();
        return ref;
    }

    private String getSymmetryAxis(int i, int j, String pointGroup, int n, Vector3d referenceAxis, double radius, float diameter, String color, Point3d center, Vector3d axis) {
        boolean drawPolygon = true;
        Point3d p1 = new Point3d((Tuple3d)axis);
        p1.scaleAdd(-AXIS_SCALE_FACTOR * radius, (Tuple3d)center);
        Point3d p2 = new Point3d((Tuple3d)axis);
        p2.scaleAdd(AXIS_SCALE_FACTOR * radius, (Tuple3d)center);
        StringBuilder s = new StringBuilder();
        s.append("draw");
        s.append(" axesSymmetry");
        s.append(this.name);
        s.append(i);
        s.append(" cylinder");
        s.append(JmolSymmetryScriptGeneratorPointGroup.getJmolPoint((Tuple3d)p1));
        s.append(JmolSymmetryScriptGeneratorPointGroup.getJmolPoint((Tuple3d)p2));
        s.append("diameter ");
        s.append(diameter);
        s.append(" color ");
        s.append(color);
        s.append(" off;");
        p1 = new Point3d((Tuple3d)axis);
        p1.scaleAdd(-1.01 * radius, (Tuple3d)center);
        p2 = new Point3d((Tuple3d)axis);
        p2.scaleAdd(1.01 * radius, (Tuple3d)center);
        if (drawPolygon) {
            double polygonRadius = this.getMeanExtension() * 0.06;
            if (n == 2) {
                referenceAxis = this.getAlignmentVector(p1, axis);
                s.append(JmolSymmetryScriptGeneratorPointGroup.getC2PolygonJmol(i, p1, referenceAxis, axis, color, polygonRadius, this.name));
                referenceAxis = this.getAlignmentVector(p2, axis);
                s.append(JmolSymmetryScriptGeneratorPointGroup.getC2PolygonJmol(j, p2, referenceAxis, axis, color, polygonRadius, this.name));
            } else if (n > 2) {
                referenceAxis = this.getAlignmentVector(p1, axis);
                s.append(JmolSymmetryScriptGeneratorPointGroup.getPolygonJmol(i, p1, referenceAxis, axis, n, color, polygonRadius, this.name));
                referenceAxis = this.getAlignmentVector(p2, axis);
                s.append(JmolSymmetryScriptGeneratorPointGroup.getPolygonJmol(j, p2, referenceAxis, axis, n, color, polygonRadius, this.name));
            }
        }
        return s.toString();
    }

    private static String getPolygonJmol(int index, Point3d center, Vector3d referenceAxis, Vector3d axis, int n, String color, double radius, String name) {
        Vector3d[] vertexes;
        StringBuilder s = new StringBuilder();
        s.append("draw axesSymbol");
        s.append(name);
        s.append(index);
        s.append(" ");
        s.append("polygon");
        s.append(" ");
        s.append(n + 1);
        s.append(JmolSymmetryScriptGeneratorPointGroup.getJmolPoint((Tuple3d)center));
        for (Vector3d v : vertexes = JmolSymmetryScriptGeneratorPointGroup.getPolygonVertices(axis, referenceAxis, center, n, radius)) {
            s.append(JmolSymmetryScriptGeneratorPointGroup.getJmolPoint((Tuple3d)v));
        }
        s.append(n);
        for (int i = 1; i <= n; ++i) {
            s.append("[");
            s.append(0);
            s.append(" ");
            s.append(i);
            s.append(" ");
            if (i < n) {
                s.append(i + 1);
            } else {
                s.append(1);
            }
            s.append(" ");
            s.append(7);
            s.append("]");
        }
        if (n == 2) {
            s.append("mesh off");
        }
        s.append(" color ");
        s.append(color);
        s.append(" off;");
        return s.toString();
    }

    private static Vector3d[] getPolygonVertices(Vector3d axis, Vector3d referenceAxis, Point3d center, int n, double radius) {
        Vector3d ref = new Vector3d(referenceAxis);
        ref.scale(radius);
        AxisAngle4d axisAngle = new AxisAngle4d(axis, 0.0);
        Vector3d[] vectors = new Vector3d[n];
        Matrix4d m = new Matrix4d();
        for (int i = 0; i < n; ++i) {
            axisAngle.angle = (double)(i * 2) * Math.PI / (double)n;
            vectors[i] = new Vector3d(ref);
            m.set(axisAngle);
            m.setElement(3, 3, 1.0);
            m.transform(vectors[i]);
            vectors[i].add((Tuple3d)center);
        }
        return vectors;
    }

    private static String getC2PolygonJmol(int index, Point3d center, Vector3d referenceAxis, Vector3d axis, String color, double radius, String name) {
        Vector3d[] vertexes;
        StringBuilder s = new StringBuilder();
        int n = 10;
        s.append("draw axesSymbol");
        s.append(name);
        s.append(index);
        s.append(" ");
        s.append("polygon");
        s.append(" ");
        s.append(n - 1);
        s.append(JmolSymmetryScriptGeneratorPointGroup.getJmolPoint((Tuple3d)center));
        for (Vector3d v : vertexes = JmolSymmetryScriptGeneratorPointGroup.getC2PolygonVertices(axis, referenceAxis, center, n, radius)) {
            s.append(JmolSymmetryScriptGeneratorPointGroup.getJmolPoint((Tuple3d)v));
        }
        s.append(n - 2);
        for (int i = 1; i < n - 1; ++i) {
            s.append("[");
            s.append(0);
            s.append(" ");
            s.append(i);
            s.append(" ");
            if (i < n - 2) {
                s.append(i + 1);
            } else {
                s.append(1);
            }
            s.append(" ");
            s.append(7);
            s.append("]");
        }
        s.append("color ");
        s.append(color);
        s.append(" off;");
        return s.toString();
    }

    private static Vector3d[] getC2PolygonVertices(Vector3d axis, Vector3d referenceAxis, Point3d center, int n, double radius) {
        int i;
        Vector3d ref = new Vector3d(referenceAxis);
        ref.scale(4.0 * radius);
        AxisAngle4d axisAngle = new AxisAngle4d(axis, 0.0);
        int k = n / 2;
        int f = 6;
        Vector3d[] vectors = new Vector3d[n - 2];
        Matrix4d m = new Matrix4d();
        axisAngle.angle = ((double)k + 0.5) * 2.0 * Math.PI / (double)(f * k);
        Vector3d begin = new Vector3d(ref);
        m.set(axisAngle);
        m.setElement(3, 3, 1.0);
        m.transform(begin);
        axisAngle.angle = ((double)(2 * k - 1) + 0.5) * 2.0 * Math.PI / (double)(f * k);
        Vector3d end = new Vector3d(ref);
        m.set(axisAngle);
        m.setElement(3, 3, 1.0);
        m.transform(end);
        Vector3d arcCenter = new Vector3d();
        arcCenter.interpolate((Tuple3d)begin, (Tuple3d)end, 0.5);
        arcCenter.negate();
        Vector3d trans = new Vector3d();
        trans.sub((Tuple3d)center, (Tuple3d)arcCenter);
        for (i = 0; i < k; ++i) {
            axisAngle.angle = ((double)(k + i) + 0.5) * 2.0 * Math.PI / (double)(f * k);
            vectors[i] = new Vector3d(ref);
            m.set(axisAngle);
            m.setElement(3, 3, 1.0);
            m.transform(vectors[i]);
            vectors[i].add((Tuple3d)arcCenter);
            vectors[i].add((Tuple3d)center);
        }
        for (i = k; i < 2 * k - 2; ++i) {
            axisAngle.angle = ((double)(f / 2 * k + i) + 1.5) * 2.0 * Math.PI / (double)(f * k);
            vectors[i] = new Vector3d(ref);
            m.set(axisAngle);
            m.setElement(3, 3, 1.0);
            m.transform(vectors[i]);
            vectors[i].sub((Tuple3d)arcCenter);
            vectors[i].add((Tuple3d)center);
        }
        return vectors;
    }

    private List<Rotation> getUniqueAxes() {
        ArrayList<Rotation> uniqueRotations = new ArrayList<Rotation>();
        int n = this.rotationGroup.getOrder();
        for (int i = 0; i < n; ++i) {
            Rotation rotationI = this.rotationGroup.getRotation(i);
            AxisAngle4d axisAngleI = rotationI.getAxisAngle();
            Vector3d axisI = new Vector3d(axisAngleI.x, axisAngleI.y, axisAngleI.z);
            boolean redundant = false;
            for (Rotation r : uniqueRotations) {
                AxisAngle4d axisAngleJ = r.getAxisAngle();
                Vector3d axisJ = new Vector3d(axisAngleJ.x, axisAngleJ.y, axisAngleJ.z);
                if (!(Math.abs(axisI.dot(axisJ)) > 0.99)) continue;
                redundant = true;
                break;
            }
            if (redundant) continue;
            uniqueRotations.add(rotationI);
        }
        return uniqueRotations;
    }

    private String drawHeader(String text, String color) {
        StringBuilder s = new StringBuilder();
        s.append("set echo top center;");
        s.append("color echo ");
        s.append(color);
        s.append(";");
        s.append("font echo 24 sanserif;");
        s.append("echo ");
        s.append(text);
        s.append(";");
        return s.toString();
    }

    private String deleteHeader() {
        return "set echo top center;echo ;";
    }

    private String drawFooter(String text, String color) {
        StringBuilder s = new StringBuilder();
        s.append("set echo bottom center;");
        s.append("color echo ");
        s.append(color);
        s.append(";");
        s.append("font echo 24 sanserif;");
        s.append("echo ").append(text);
        s.append(";");
        return s.toString();
    }

    private String setCentroid() {
        Point3d centroid = this.rotationAxisAligner.getCentroid();
        StringBuilder s = new StringBuilder();
        s.append("center");
        s.append(JmolSymmetryScriptGeneratorPointGroup.getJmolPoint((Tuple3d)centroid));
        s.append(";");
        return s.toString();
    }
}

