/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomIterator;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HetatomImpl
implements Group,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(HetatomImpl.class);
    private static final long serialVersionUID = 4491470432023820382L;
    public static final GroupType type = GroupType.HETATM;
    private Map<String, Object> properties;
    private long id;
    protected boolean pdb_flag = false;
    protected String pdb_name = null;
    protected ResidueNumber residueNumber = null;
    protected List<Atom> atoms = new ArrayList<Atom>();
    private Chain parent = null;
    private Map<String, Atom> atomNameLookup;
    private ChemComp chemComp = null;
    private List<Group> altLocs = null;

    public HetatomImpl() {
        this.properties = new HashMap<String, Object>();
        this.atomNameLookup = new HashMap<String, Atom>();
    }

    @Override
    public boolean has3D() {
        return this.pdb_flag;
    }

    @Override
    public void setPDBFlag(boolean flag) {
        this.pdb_flag = flag;
    }

    @Override
    public void setPDBName(String s) {
        if (s != null && s.equals("?")) {
            logger.info("invalid pdbname: ?");
        }
        this.pdb_name = s;
    }

    @Override
    public String getPDBName() {
        return this.pdb_name;
    }

    @Override
    public void addAtom(Atom atom) {
        Atom existingAtom;
        atom.setGroup(this);
        this.atoms.add(atom);
        if (atom.getCoords() != null) {
            this.setPDBFlag(true);
        }
        if ((existingAtom = this.atomNameLookup.put(atom.getName(), atom)) != null) {
            String altLocStr = "";
            char altLoc = atom.getAltLoc().charValue();
            if (altLoc != ' ') {
                altLocStr = "(alt loc '" + altLoc + "')";
            }
            logger.warn("An atom with name " + atom.getName() + " " + altLocStr + " is already present in group: " + this.toString() + ". The atom with serial " + atom.getPDBserial() + " will be ignored in look-ups.");
        }
    }

    @Override
    public void clearAtoms() {
        this.atoms.clear();
        this.setPDBFlag(false);
        this.atomNameLookup.clear();
    }

    @Override
    public int size() {
        return this.atoms.size();
    }

    @Override
    public List<Atom> getAtoms() {
        return this.atoms;
    }

    @Override
    public void setAtoms(List<Atom> atoms) {
        this.atomNameLookup.clear();
        for (Atom a : atoms) {
            a.setGroup(this);
            this.atomNameLookup.put(a.getName(), a);
        }
        this.atoms = atoms;
        if (!atoms.isEmpty()) {
            this.pdb_flag = true;
        }
    }

    @Override
    public Atom getAtom(String name) {
        return this.atomNameLookup.get(name);
    }

    @Override
    public Atom getAtom(int position) {
        if (position < 0 || position >= this.atoms.size()) {
            return null;
        }
        return this.atoms.get(position);
    }

    @Override
    public boolean hasAtom(String fullName) {
        Atom a = this.atomNameLookup.get(fullName.trim());
        return a != null;
    }

    @Override
    public GroupType getType() {
        return type;
    }

    public String toString() {
        String str = "Hetatom " + this.residueNumber + " " + this.pdb_name + " " + this.pdb_flag;
        if (this.pdb_flag) {
            str = str + " atoms: " + this.atoms.size();
        }
        if (this.altLocs != null) {
            str = str + " has altLocs :" + this.altLocs.size();
        }
        return str;
    }

    @Override
    public boolean hasAminoAtoms() {
        return this.hasAtom("CA") && this.hasAtom("C") && this.hasAtom("N") && this.hasAtom("O");
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        this.properties = props;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Iterator<Atom> iterator() {
        return new AtomIterator(this);
    }

    @Override
    public Object clone() {
        HetatomImpl n = new HetatomImpl();
        n.setPDBFlag(this.has3D());
        n.setResidueNumber(this.residueNumber);
        n.setPDBName(this.getPDBName());
        for (Atom atom1 : this.atoms) {
            Atom atom = (Atom)atom1.clone();
            n.addAtom(atom);
            atom.setGroup(n);
        }
        return n;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public ChemComp getChemComp() {
        if (this.chemComp == null) {
            this.chemComp = ChemCompGroupFactory.getChemComp(this.pdb_name);
            if (this.chemComp == null) {
                logger.info("getChemComp: " + this.pdb_name);
            }
        }
        return this.chemComp;
    }

    @Override
    public void setChemComp(ChemComp cc) {
        this.chemComp = cc;
    }

    @Override
    public void setChain(Chain chain) {
        this.parent = chain;
        if (this.residueNumber != null) {
            this.residueNumber.setChainId(chain.getChainID());
        }
    }

    @Override
    public Chain getChain() {
        return this.parent;
    }

    @Override
    public String getChainId() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.getChainID();
    }

    @Override
    public ResidueNumber getResidueNumber() {
        return this.residueNumber;
    }

    @Override
    public void setResidueNumber(ResidueNumber residueNumber) {
        this.residueNumber = residueNumber;
    }

    @Override
    public void setResidueNumber(String chainId, Integer resNum, Character iCode) {
        this.residueNumber = new ResidueNumber(chainId, resNum, iCode);
    }

    @Override
    public boolean hasAltLoc() {
        if (this.altLocs == null) {
            return false;
        }
        return !this.altLocs.isEmpty();
    }

    @Override
    public List<Group> getAltLocs() {
        if (this.altLocs == null) {
            return new ArrayList<Group>();
        }
        return this.altLocs;
    }

    @Override
    public Group getAltLocGroup(Character altLoc) {
        Atom a = this.getAtom(0);
        if (a == null) {
            return null;
        }
        if (a.getAltLoc().equals(altLoc)) {
            return this;
        }
        if (this.altLocs == null || this.altLocs.isEmpty()) {
            return null;
        }
        for (Group group : this.altLocs) {
            Atom b;
            if (group.getAtoms().isEmpty() || (b = group.getAtom(0)) == null || !b.getAltLoc().equals(altLoc)) continue;
            return group;
        }
        return null;
    }

    @Override
    public void addAltLoc(Group group) {
        if (this.altLocs == null) {
            this.altLocs = new ArrayList<Group>();
        }
        this.altLocs.add(group);
    }

    @Override
    public boolean isWater() {
        return GroupType.WATERNAMES.contains(this.pdb_name);
    }

    @Override
    public void trimToSize() {
        if (this.atoms instanceof ArrayList) {
            ArrayList myatoms = (ArrayList)this.atoms;
            myatoms.trimToSize();
        }
        if (this.altLocs instanceof ArrayList) {
            ArrayList myAltLocs = (ArrayList)this.altLocs;
            myAltLocs.trimToSize();
        }
        this.atomNameLookup = new HashMap<String, Atom>(this.atomNameLookup);
        if (this.hasAltLoc()) {
            for (Group alt : this.getAltLocs()) {
                alt.trimToSize();
            }
        }
    }
}

