/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.cath.CathFactory;
import org.biojava.nbio.structure.scop.ScopFactory;

public class Identifier {
    private static final String CATH_PATTERN = "[0-9][a-z0-9]{3}.[0-9]{2}";
    private static final String SCOP_PATTERN = "d[0-9][a-zA-Z0-9]{3,4}([a-zA-Z][0-9_]|\\.[0-9]+)";

    public static StructureIdentifier loadIdentifier(String id, AtomCache cache) {
        if (id.matches(CATH_PATTERN)) {
            return CathFactory.getCathDatabase().getDescriptionByCathId(id);
        }
        if (id.matches(SCOP_PATTERN)) {
            return ScopFactory.getSCOP().getDomainByScopID(id);
        }
        try {
            return new SubstructureIdentifier(id, cache);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't understand id " + id, e);
        }
    }
}

