/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupIterator;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.PDBFileParser;

public final class StandardAminoAcid {
    private static Map<String, AminoAcid> aminoAcids = new HashMap<String, AminoAcid>();

    private StandardAminoAcid() {
    }

    public static AminoAcid getAminoAcid(String name) {
        return aminoAcids.get(name);
    }

    static {
        try {
            InputStream fileStream = StandardAminoAcid.class.getClassLoader().getResourceAsStream("org/biojava/bio/structure/standardaminos.pdb");
            if (fileStream == null) {
                throw new Exception("Couldn't locate standardaminos.pdb.  This probably means that your biojava.jar file is corrupt or incorrectly built.");
            }
            PDBFileParser parser = new PDBFileParser();
            Structure s = parser.parsePDBFile(fileStream);
            GroupIterator iter = new GroupIterator(s);
            while (iter.hasNext()) {
                Group g = iter.next();
                if (!(g instanceof AminoAcid)) continue;
                AminoAcid aa = (AminoAcid)g;
                aminoAcids.put(aa.getPDBName(), aa);
                aminoAcids.put(aa.getAminoType().toString(), aa);
            }
        }
        catch (Exception t) {
            throw new RuntimeException("Unable to initialize standard aminoacids", t);
        }
    }
}

