/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.ce;

import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.MultiThreadedDBSearch;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.ce.GuiWrapper;
import org.biojava.nbio.structure.align.ce.StartupParameters;
import org.biojava.nbio.structure.align.ce.UserArgumentProcessor;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AFPAlignmentDisplay;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.CliTools;
import org.biojava.nbio.structure.align.util.ConfigurationException;
import org.biojava.nbio.structure.align.util.ResourceManager;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.xml.AFPChainXMLConverter;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.biojava.nbio.structure.io.PDBFileReader;

public abstract class AbstractUserArgumentProcessor
implements UserArgumentProcessor {
    public static String newline = System.getProperty("line.separator");
    protected StartupParameters params = this.getStartupParametersInstance();
    public static final List<String> mandatoryArgs = new ArrayList<String>();

    protected AbstractUserArgumentProcessor() {
    }

    protected abstract StartupParameters getStartupParametersInstance();

    public abstract StructureAlignment getAlgorithm();

    public abstract Object getParameters();

    public abstract String getDbSearchLegend();

    @Override
    public void process(String[] argv) {
        AbstractUserArgumentProcessor.printAboutMe();
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.equalsIgnoreCase("-h") || arg.equalsIgnoreCase("-help") || arg.equalsIgnoreCase("--help")) {
                System.out.println(this.printHelp());
                return;
            }
            if (arg.equalsIgnoreCase("-version") || arg.equalsIgnoreCase("--version")) {
                StructureAlignment alg = this.getAlgorithm();
                System.out.println(alg.getAlgorithmName() + " v." + alg.getVersion());
                return;
            }
            String value = null;
            if (i < argv.length - 1) {
                value = argv[i + 1];
            }
            if (value != null && value.startsWith("-")) {
                value = null;
            } else {
                ++i;
            }
            String[] tmp = new String[]{arg, value};
            try {
                CliTools.configureBean(this.params, tmp);
                continue;
            }
            catch (ConfigurationException e) {
                System.err.println("Error: " + e.getLocalizedMessage());
                System.exit(1);
                return;
            }
        }
        if (this.params.getPdbFilePath() != null) {
            System.setProperty("PDB_DIR", this.params.getPdbFilePath());
        }
        if (this.params.getCacheFilePath() != null) {
            System.setProperty("PDB_CACHE_DIR", this.params.getCacheFilePath());
        }
        if (this.params.isShowMenu()) {
            System.err.println("showing menu...");
            try {
                GuiWrapper.showAlignmentGUI();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
        if (this.params.getShowDBresult() != null) {
            System.err.println("showing DB results...");
            try {
                GuiWrapper.showDBResults(this.params);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
        String pdb1 = this.params.getPdb1();
        String file1 = this.params.getFile1();
        try {
            if (pdb1 != null || file1 != null) {
                this.runPairwise();
                return;
            }
            if (this.params.getAlignPairs() != null) {
                this.runDBSearch();
                return;
            }
            if (this.params.getSearchFile() != null) {
                this.runDBSearch();
                return;
            }
        }
        catch (ConfigurationException e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(1);
            return;
        }
        System.out.println(this.printHelp());
        System.err.println("Error: insufficient arguments.");
        System.exit(1);
    }

    public static void printAboutMe() {
        try {
            ResourceManager about = ResourceManager.getResourceManager("about");
            String version = about.getString("project_version");
            String build = about.getString("build");
            System.out.println("Protein Comparison Tool " + version + " " + build);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runDBSearch() throws ConfigurationException {
        String cacheFilePath;
        String pdbFilePath = this.params.getPdbFilePath();
        if (pdbFilePath == null || pdbFilePath.equals("")) {
            UserConfiguration c = new UserConfiguration();
            pdbFilePath = c.getPdbFilePath();
            System.err.println("You did not specify the -pdbFilePath parameter. Defaulting to " + pdbFilePath + ".");
        }
        if ((cacheFilePath = this.params.getCacheFilePath()) == null || cacheFilePath.equals("")) {
            cacheFilePath = pdbFilePath;
        }
        AtomCache cache = new AtomCache(pdbFilePath, pdbFilePath);
        String alignPairs = this.params.getAlignPairs();
        String searchFile = this.params.getSearchFile();
        if ((alignPairs == null || alignPairs.equals("")) && (searchFile == null || searchFile.equals(""))) {
            throw new ConfigurationException("Please specify -alignPairs or -searchFile !");
        }
        String outputFile = this.params.getOutFile();
        if (outputFile == null || outputFile.equals("")) {
            throw new ConfigurationException("Please specify the mandatory argument -outFile!");
        }
        System.out.println("running DB search with parameters: " + this.params);
        if (alignPairs != null && !alignPairs.equals("")) {
            this.runAlignPairs(cache, alignPairs, outputFile);
        } else {
            int useNrCPUs = this.params.getNrCPU();
            this.runDbSearch(cache, searchFile, outputFile, useNrCPUs, this.params);
        }
    }

    private void runDbSearch(AtomCache cache, String searchFile, String outputFile, int useNrCPUs, StartupParameters params) throws ConfigurationException {
        System.out.println("will use " + useNrCPUs + " CPUs.");
        PDBFileReader reader = new PDBFileReader();
        Structure structure1 = null;
        try {
            structure1 = reader.getStructure(searchFile);
        }
        catch (IOException e) {
            throw new ConfigurationException("could not parse as PDB file: " + searchFile);
        }
        File searchF = new File(searchFile);
        String name1 = "CUSTOM";
        StructureAlignment algorithm = this.getAlgorithm();
        MultiThreadedDBSearch dbSearch = new MultiThreadedDBSearch(name1, structure1, outputFile, algorithm, useNrCPUs, params.isDomainSplit());
        dbSearch.setCustomFile1(searchF.getAbsolutePath());
        dbSearch.run();
    }

    private void runAlignPairs(AtomCache cache, String alignPairs, String outputFile) {
        try {
            File f = new File(alignPairs);
            BufferedReader is = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            BufferedWriter out = new BufferedWriter(new FileWriter(outputFile, true));
            StructureAlignment algorithm = this.getAlgorithm();
            String header = "# algorithm:" + algorithm.getAlgorithmName();
            out.write(header);
            out.write(newline);
            out.write("#Legend: " + newline);
            String legend = this.getDbSearchLegend();
            out.write(legend + newline);
            System.out.println(legend);
            String line = null;
            while ((line = is.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] spl = line.split(" ");
                if (spl.length != 2) {
                    System.err.println("wrongly formattted line. Expected format: 4hhb.A 4hhb.B but found " + line);
                    continue;
                }
                String pdb1 = spl[0];
                String pdb2 = spl[1];
                Structure structure1 = cache.getStructure(pdb1);
                Structure structure2 = cache.getStructure(pdb2);
                Atom[] ca1 = StructureTools.getAtomCAArray(structure1);
                Atom[] ca2 = StructureTools.getAtomCAArray(structure2);
                Object jparams = this.getParameters();
                AFPChain afpChain = algorithm.align(ca1, ca2, jparams);
                afpChain.setName1(pdb1);
                afpChain.setName2(pdb2);
                String result = this.getDbSearchResult(afpChain);
                out.write(result);
                System.out.print(result);
                this.checkWriteFile(afpChain, ca1, ca2, true);
            }
            out.close();
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runPairwise() throws ConfigurationException {
        String name1 = this.params.getPdb1();
        String file1 = this.params.getFile1();
        if (name1 == null && file1 == null) {
            throw new ConfigurationException("You did not specify the -pdb1 or -file1 parameter. Can not find query PDB id for alignment.");
        }
        if (file1 == null && name1.length() < 4) {
            throw new ConfigurationException("-pdb1 does not look like a PDB ID. Please specify PDB code or PDB.chainId.");
        }
        String name2 = this.params.getPdb2();
        String file2 = this.params.getFile2();
        if (name2 == null && file2 == null) {
            throw new ConfigurationException("You did not specify the -pdb2 or -file2 parameter. Can not find target PDB id for alignment.");
        }
        if (file2 == null && name2.length() < 4) {
            throw new ConfigurationException("-pdb2 does not look like a PDB ID. Please specify PDB code or PDB.chainId.");
        }
        Structure structure1 = null;
        Structure structure2 = null;
        String path = this.params.getPdbFilePath();
        if (file1 == null || file2 == null) {
            if (path == null) {
                UserConfiguration c = new UserConfiguration();
                path = c.getPdbFilePath();
                System.err.println("You did not specify the -pdbFilePath parameter. Defaulting to " + path + ".");
            }
            AtomCache cache = new AtomCache(path, path);
            if (this.params.isAutoFetch()) {
                cache.setFetchBehavior(LocalPDBDirectory.FetchBehavior.DEFAULT);
            } else {
                cache.setFetchBehavior(LocalPDBDirectory.FetchBehavior.LOCAL_ONLY);
            }
            structure1 = this.getStructure(cache, name1, file1);
            structure2 = this.getStructure(cache, name2, file2);
        } else {
            structure1 = this.getStructure(null, name1, file1);
            structure2 = this.getStructure(null, name2, file2);
        }
        if (structure1 == null) {
            System.err.println("structure 1 is null, can't run alignment.");
            System.exit(1);
            return;
        }
        if (structure2 == null) {
            System.err.println("structure 2 is null, can't run alignment.");
            System.exit(1);
            return;
        }
        if (name1 == null) {
            name1 = structure1.getName();
        }
        if (name2 == null) {
            name2 = structure2.getName();
        }
        try {
            Atom[] ca1 = StructureTools.getAtomCAArray(structure1);
            Atom[] ca2 = StructureTools.getAtomCAArray(structure2);
            StructureAlignment algorithm = this.getAlgorithm();
            Object jparams = this.getParameters();
            AFPChain afpChain = algorithm.align(ca1, ca2, jparams);
            afpChain.setName1(name1);
            afpChain.setName2(name2);
            if (this.params.isShow3d()) {
                if (!GuiWrapper.isGuiModuleInstalled()) {
                    System.err.println("The biojava-structure-gui module is not installed. Please install!");
                } else {
                    try {
                        Object jmol = GuiWrapper.display(afpChain, ca1, ca2);
                        GuiWrapper.showAlignmentImage(afpChain, ca1, ca2, jmol);
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
            this.checkWriteFile(afpChain, ca1, ca2, false);
            if (this.params.isPrintXML()) {
                String fatcatXML = AFPChainXMLConverter.toXML(afpChain, ca1, ca2);
                System.out.println(fatcatXML);
            }
            if (this.params.isPrintFatCat()) {
                System.out.println(afpChain.toFatcat(ca1, ca2));
            }
            if (this.params.isPrintCE()) {
                System.out.println(afpChain.toCE(ca1, ca2));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        catch (StructureException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkWriteFile(AFPChain afpChain, Atom[] ca1, Atom[] ca2, boolean dbsearch) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String output = null;
        if (this.params.isOutputPDB()) {
            if (!GuiWrapper.isGuiModuleInstalled()) {
                System.err.println("The biojava-structure-gui module is not installed. Please install!");
                output = AFPChainXMLConverter.toXML(afpChain, ca1, ca2);
            } else {
                Structure tmp = AFPAlignmentDisplay.createArtificalStructure(afpChain, ca1, ca2);
                output = "TITLE  " + afpChain.getAlgorithmName() + " " + afpChain.getVersion() + " ";
                output = output + afpChain.getName1() + " vs. " + afpChain.getName2();
                output = output + newline;
                output = output + tmp.toPDB();
            }
        } else if (this.params.getOutFile() != null) {
            output = AFPChainXMLConverter.toXML(afpChain, ca1, ca2);
        } else if (this.params.getSaveOutputDir() != null) {
            output = AFPChainXMLConverter.toXML(afpChain, ca1, ca2);
        }
        if (output == null) {
            return;
        }
        String fileName = null;
        if (dbsearch) {
            if (this.params.getSaveOutputDir() == null) return;
            if (afpChain.getName1().startsWith("file:") || afpChain.getName2().startsWith("file:")) {
                return;
            }
            fileName = this.params.getSaveOutputDir();
            fileName = fileName + this.getAutoFileName(afpChain);
        } else if (this.params.getOutFile() != null) {
            fileName = this.params.getOutFile();
        }
        if (fileName == null) {
            System.err.println("Can't write outputfile. Either provide a filename using -outFile or set -autoOutputFile to true .");
            System.exit(1);
            return;
        }
        FileOutputStream out = new FileOutputStream(fileName);
        PrintStream p = new PrintStream(out);
        p.println(output);
        p.close();
    }

    private String getAutoFileName(AFPChain afpChain) {
        String fileName = afpChain.getName1() + "_" + afpChain.getName2() + "_" + afpChain.getAlgorithmName();
        fileName = this.params.isOutputPDB() ? fileName + ".pdb" : fileName + ".xml";
        return fileName;
    }

    private Structure getStructure(AtomCache cache, String name1, String file) {
        PDBFileReader reader = new PDBFileReader();
        if (file != null) {
            try {
                URL url = new URL(file);
                System.out.println(url);
                Structure s = reader.getStructure(url);
                return this.fixStructureName(s, file);
            }
            catch (Exception e) {
                try {
                    System.err.println(e.getMessage());
                    File f = new File(file);
                    System.out.println("file from local " + f.getAbsolutePath());
                    Structure s = reader.getStructure(f);
                    return this.fixStructureName(s, file);
                }
                catch (Exception e2) {
                    System.err.println("general exception:" + e2.getMessage());
                    System.err.println("unable to load structure from " + file);
                    return null;
                }
            }
        }
        try {
            Structure s = cache.getStructure(name1);
            return s;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("unable to load structure from dir: " + cache.getPath() + "/" + name1);
            return null;
        }
    }

    private Structure fixStructureName(Structure s, String file) {
        if (s.getName() != null && !s.getName().equals("")) {
            return s;
        }
        s.setName(s.getPDBCode());
        if (s.getName() == null || s.getName().equals("")) {
            File f = new File(file);
            s.setName(f.getName());
        }
        return s;
    }

    public String getDbSearchResult(AFPChain afpChain) {
        return afpChain.toDBSearchResult();
    }

    @Override
    public String printHelp() {
        StringBuffer buf = new StringBuffer();
        StructureAlignment alg = this.getAlgorithm();
        buf.append("-------------------").append(newline);
        buf.append(alg.getAlgorithmName() + " v." + alg.getVersion() + " help: " + newline);
        buf.append("-------------------").append(newline);
        buf.append(newline);
        buf.append(alg.getAlgorithmName() + " accepts the following parameters:" + newline);
        buf.append(newline);
        buf.append("--- pairwise alignments ---").append(newline);
        buf.append(" two files to align can be specified by providing a path to a file, or a URL:").append(newline);
        buf.append("   -file1 the first file to align").append(newline);
        buf.append("   -file2 the second file to align").append(newline);
        buf.append(" alternatively you can specify PDB files by their PDB ids:").append(newline);
        buf.append("   -pdbFilePath  Path to the directory in your file system that contains the PDB files.").append(newline);
        buf.append("   -pdb1  PDB ID of target structure. Chain IDs are optional. In order to specify chain IDs write e.g: 5pti.A").append(newline);
        buf.append("   -pdb2  PDB ID of query structure. Chain IDs are optional. In order to specify chain IDs write e.g: 5pti.A").append(newline);
        buf.append(newline);
        buf.append("   -h / -help / --help : print this help string.").append(newline);
        buf.append("   -version: print version info").append(newline);
        buf.append("   -printXML true/false print the XML representation of the alignment on stdout.").append(newline);
        buf.append("   -printFatCat true/false print the original FATCAT output to stdout.").append(newline);
        buf.append("   -printCE true/false print the result in CE style").append(newline);
        buf.append("   -show3d print a 3D visualisation of the alignment (requires jmolapplet.jar in classpath)").append(newline);
        buf.append("   -outFile file to write the output to (default: writes XML representation).").append(newline);
        buf.append("   -outputPDB use this flag together with -outFile to dump the PDB file of the aligned structures, instead of the XML representation, instead of XML").append(newline);
        buf.append("   -autoFetch true/false if set to true PDB files will automatically get downloaded and stored in the right location. (default: false)").append(newline);
        buf.append("   -showMenu displays the menu that allows to run alignments through a user interface.").append(newline);
        buf.append(newline);
        buf.append("--- custom searches ---").append(newline);
        buf.append("   -alignPairs (mandatory) path to a file that contains a set of pairs to compair").append(newline);
        buf.append("   -outFile (mandatory) a file that will contain the summary of all the pairwise alignments").append(newline);
        buf.append(newline);
        buf.append("--- database searches ---").append(newline);
        buf.append("   -searchFile (mandatory) path to a PDB file that should be used in the search").append(newline);
        buf.append("   -outFile (mandatory) a directory that will contain the results of the DB search").append(newline);
        buf.append("   -nrCPU (optional) Number of CPUs to use for the database search. By default will use the all, but one CPU in the system.").append(newline);
        buf.append("   -pdbFilePath (mandatory) Path to the directory in your file system that contains the PDB files.").append(newline);
        buf.append("   -saveOutputDir (optional) a directory that will contain the detailed outputs of the alignments. By default will write XML files, if used together with -outputPDB, will write PDB files of the alignment.").append(newline);
        buf.append(newline);
        buf.append(" Once DB seaches are complete it is possible to view the results with:").append(newline);
        buf.append("   -showDBresult (optional) path to a DB outFile to show. Also provide the -pdbFilePath parameter to enable visualisation of results.").append(newline);
        buf.append(newline);
        ConfigStrucAligParams params = alg.getParameters();
        List<String> paramNames = params.getUserConfigParameters();
        List<String> paramHelp = params.getUserConfigHelp();
        assert (paramNames.size() == paramHelp.size());
        int size = Math.min(paramNames.size(), paramHelp.size());
        if (size > 0) {
            Iterator<String> namesIt = paramNames.iterator();
            Iterator<String> helpIt = paramHelp.iterator();
            buf.append("--- ").append(alg.getAlgorithmName()).append(" parameters: ---").append(newline);
            for (int i = 0; i < size; ++i) {
                String name = namesIt.next();
                buf.append("   -").append(Introspector.decapitalize(name));
                buf.append(" ").append(helpIt.next());
                buf.append(newline);
            }
        }
        buf.append(newline);
        buf.append(" For boolean arguments: if neither the text >true< or >false< is provided it is assumed to mean >true<. Instead of >-argument false< it is also possible to write -noArgument.").append(newline);
        buf.append(newline);
        buf.append("--- How to specify what to align ---").append(newline);
        buf.append(" If only a PDB code is provided, the whole structure will be used for the alignment.").append(newline);
        buf.append(" To specify a particular chain write as: 4hhb.A (chain IDs are case sensitive, PDB ids are not)").append(newline);
        buf.append(" To specify that the 1st chain in a structure should be used write: 4hhb:0 .").append(newline);
        buf.append(" In order to align SCOP domains, provide pdb1/pdb2 as: d4hhba_ Note: if SCOP is not installed at the -pdbFilePath, will automatically download and install.").append(newline);
        buf.append(newline);
        return buf.toString();
    }
}

