/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.contact.AtomContact;
import org.biojava.nbio.structure.contact.AtomContactSet;
import org.biojava.nbio.structure.contact.GroupContact;
import org.biojava.nbio.structure.contact.Pair;
import org.biojava.nbio.structure.contact.ResidueIdentifier;

public class GroupContactSet
implements Iterable<GroupContact> {
    private HashMap<Pair<ResidueNumber>, GroupContact> contacts = new HashMap();
    private HashSet<Pair<ResidueIdentifier>> residueIdContacts;

    public GroupContactSet() {
    }

    public GroupContactSet(AtomContactSet atomContacts) {
        this.atoms2groups(atomContacts);
    }

    private void atoms2groups(AtomContactSet atomContacts) {
        for (AtomContact atomContact : atomContacts) {
            GroupContact groupContact;
            Group jResidue;
            Pair<Atom> atomPair = atomContact.getPair();
            Group iResidue = atomPair.getFirst().getGroup();
            if (iResidue.equals(jResidue = atomPair.getSecond().getGroup())) continue;
            Pair<Group> residuePair = new Pair<Group>(iResidue, jResidue);
            Pair<ResidueNumber> pair = new Pair<ResidueNumber>(iResidue.getResidueNumber(), jResidue.getResidueNumber());
            if (!this.contacts.containsKey(pair)) {
                groupContact = new GroupContact();
                groupContact.setPair(residuePair);
                groupContact.addAtomContact(atomContact);
                this.contacts.put(pair, groupContact);
                continue;
            }
            groupContact = this.contacts.get(pair);
            groupContact.addAtomContact(atomContact);
        }
    }

    public void add(GroupContact groupContact) {
        this.contacts.put(this.getResNumberPairFromContact(groupContact), groupContact);
    }

    public boolean hasContact(Group group1, Group group2) {
        return this.hasContact(group1.getResidueNumber(), group2.getResidueNumber());
    }

    public boolean hasContact(ResidueNumber resNumber1, ResidueNumber resNumber2) {
        return this.contacts.containsKey(new Pair<ResidueNumber>(resNumber1, resNumber2));
    }

    public boolean hasContact(ResidueIdentifier resId1, ResidueIdentifier resId2) {
        if (this.residueIdContacts == null) {
            this.initResidueIdContacts();
        }
        return this.residueIdContacts.contains(new Pair<ResidueIdentifier>(resId1, resId2));
    }

    private void initResidueIdContacts() {
        this.residueIdContacts = new HashSet();
        for (Pair<ResidueNumber> pairResNum : this.contacts.keySet()) {
            ResidueNumber resNumFirst = pairResNum.getFirst();
            ResidueNumber resNumSecond = pairResNum.getSecond();
            this.residueIdContacts.add(new Pair<ResidueIdentifier>(new ResidueIdentifier(resNumFirst.getSeqNum(), resNumFirst.getInsCode()), new ResidueIdentifier(resNumSecond.getSeqNum(), resNumSecond.getInsCode())));
        }
    }

    public GroupContact getContact(Group group1, Group group2) {
        return this.contacts.get(new Pair<ResidueNumber>(group1.getResidueNumber(), group2.getResidueNumber()));
    }

    public int size() {
        return this.contacts.size();
    }

    @Override
    public Iterator<GroupContact> iterator() {
        return this.contacts.values().iterator();
    }

    private Pair<ResidueNumber> getResNumberPairFromContact(GroupContact groupContact) {
        return new Pair<ResidueNumber>(groupContact.getPair().getFirst().getResidueNumber(), groupContact.getPair().getSecond().getResidueNumber());
    }
}

