/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Compound;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.biojava.nbio.structure.io.PDBFileParser;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.mmcif.ReducedChemCompProvider;

public class PDBFileReader
extends LocalPDBDirectory {
    public static final String LOAD_CHEM_COMP_PROPERTY = "loadChemCompInfo";
    public static final String[] PDB_SPLIT_DIR = new String[]{"data", "structures", "divided", "pdb"};
    public static final String[] PDB_OBSOLETE_DIR = new String[]{"data", "structures", "obsolete", "pdb"};

    public static void main(String[] args) {
        PDBFileReader pdbreader = new PDBFileReader();
        String property = "java.io.tmpdir";
        String tempdir = System.getProperty(property);
        pdbreader.setPath(tempdir);
        FileParsingParameters params = new FileParsingParameters();
        pdbreader.setFileParsingParameters(params);
        try {
            Structure struc = pdbreader.getStructureById("193D");
            System.out.println(struc);
            List<Compound> compounds = struc.getCompounds();
            for (Compound comp : compounds) {
                List<Chain> chains = comp.getChains();
                System.out.print(">Chains :");
                for (Chain c : chains) {
                    System.out.print(c.getChainID() + " ");
                }
                System.out.println();
                if (chains.size() <= 0) continue;
                System.out.println(chains.get(0).getAtomSequence());
                System.out.println(chains.get(0).getSeqResSequence());
                System.out.print("  Atom Ligands: ");
                for (Group g : chains.get(0).getAtomLigands()) {
                    System.out.print(g.getPDBName() + " ");
                }
                System.out.println(" ");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PDBFileReader() {
        this(null);
    }

    public PDBFileReader(String path) {
        super(path);
        this.addExtension(".ent");
        this.addExtension(".pdb");
        this.addExtension(".ent.gz");
        this.addExtension(".pdb.gz");
        this.addExtension(".ent.Z");
        this.addExtension(".pdb.Z");
    }

    @Deprecated
    public void downloadPDB(String pdbId) throws IOException {
        this.downloadStructure(pdbId);
    }

    @Override
    public void setFileParsingParameters(FileParsingParameters params) {
        super.setFileParsingParameters(params);
        if (!params.isLoadChemCompInfo()) {
            ChemCompGroupFactory.setChemCompProvider(new ReducedChemCompProvider());
        }
    }

    @Deprecated
    public void setFetchFileEvenIfObsolete(boolean fetchFileEvenIfObsolete) {
        if (fetchFileEvenIfObsolete) {
            this.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.FETCH_OBSOLETE);
        } else if (this.getObsoleteBehavior() == LocalPDBDirectory.ObsoleteBehavior.FETCH_OBSOLETE) {
            this.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.DEFAULT);
        }
    }

    @Deprecated
    public boolean isFetchFileEvenIfObsolete() {
        return this.getObsoleteBehavior() == LocalPDBDirectory.ObsoleteBehavior.FETCH_OBSOLETE;
    }

    @Deprecated
    public void setFetchCurrent(boolean fetchNewestCurrent) {
        if (fetchNewestCurrent) {
            this.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.FETCH_CURRENT);
        } else if (this.getObsoleteBehavior() == LocalPDBDirectory.ObsoleteBehavior.FETCH_CURRENT) {
            this.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.DEFAULT);
        }
    }

    @Deprecated
    public boolean isFetchCurrent() {
        return this.getObsoleteBehavior() == LocalPDBDirectory.ObsoleteBehavior.FETCH_CURRENT;
    }

    @Override
    protected String getFilename(String pdbId) {
        return "pdb" + pdbId.toLowerCase() + ".ent.gz";
    }

    @Override
    public Structure getStructure(InputStream inStream) throws IOException {
        PDBFileParser pdbpars = new PDBFileParser();
        pdbpars.setFileParsingParameters(this.getFileParsingParameters());
        Structure struc = pdbpars.parsePDBFile(inStream);
        return struc;
    }

    @Override
    protected String[] getSplitDirPath() {
        return PDB_SPLIT_DIR;
    }

    @Override
    protected String[] getObsoleteDirPath() {
        return PDB_OBSOLETE_DIR;
    }
}

