/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.biojava.nbio.structure.io.mmcif.ChemCompConsumer;
import org.biojava.nbio.structure.io.mmcif.ChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.ChemicalComponentDictionary;
import org.biojava.nbio.structure.io.mmcif.SimpleMMcifParser;
import org.biojava.nbio.structure.io.mmcif.chem.PolymerType;
import org.biojava.nbio.structure.io.mmcif.chem.ResidueType;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReducedChemCompProvider
implements ChemCompProvider {
    private static final Logger logger = LoggerFactory.getLogger(ReducedChemCompProvider.class);

    public ReducedChemCompProvider() {
        logger.debug("Initialising ReducedChemCompProvider");
    }

    public ChemComp getEmptyChemComp() {
        ChemComp comp = new ChemComp();
        comp.setOne_letter_code("?");
        comp.setPolymerType(PolymerType.unknown);
        comp.setResidueType(ResidueType.atomn);
        return comp;
    }

    @Override
    public ChemComp getChemComp(String recordName) {
        String name = recordName.toUpperCase().trim();
        InputStream inStream = this.getClass().getResourceAsStream("/chemcomp/" + name + ".cif.gz");
        if (inStream == null) {
            logger.debug("Getting empty chem comp for {}", (Object)name);
            ChemComp cc = this.getEmptyChemComp();
            cc.setId(name);
            return cc;
        }
        SimpleMMcifParser parser = new SimpleMMcifParser();
        ChemCompConsumer consumer = new ChemCompConsumer();
        parser.addMMcifConsumer(consumer);
        try {
            parser.parse(new BufferedReader(new InputStreamReader(new GZIPInputStream(inStream))));
            ChemicalComponentDictionary dict = consumer.getDictionary();
            ChemComp chemComp = dict.getChemComp(name);
            return chemComp;
        }
        catch (IOException e) {
            logger.error("IOException caught while reading chem comp {}. Error: {}", (Object)name, (Object)e.getMessage());
            logger.warn("Problem when loading chem comp {}, will use an empty chem comp for it", (Object)name);
            ChemComp cc = this.getEmptyChemComp();
            cc.setId(name);
            return cc;
        }
    }
}

