/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.MMCIFFileReader;
import org.biojava.nbio.structure.io.mmcif.MMcifConsumer;
import org.biojava.nbio.structure.io.mmcif.MMcifParser;
import org.biojava.nbio.structure.io.mmcif.model.AtomSite;
import org.biojava.nbio.structure.io.mmcif.model.AuditAuthor;
import org.biojava.nbio.structure.io.mmcif.model.Cell;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompAtom;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompBond;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompDescriptor;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePDBremark;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePDBrev;
import org.biojava.nbio.structure.io.mmcif.model.Entity;
import org.biojava.nbio.structure.io.mmcif.model.EntityPolySeq;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcGen;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcNat;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcSyn;
import org.biojava.nbio.structure.io.mmcif.model.Exptl;
import org.biojava.nbio.structure.io.mmcif.model.PdbxChemCompDescriptor;
import org.biojava.nbio.structure.io.mmcif.model.PdbxChemCompIdentifier;
import org.biojava.nbio.structure.io.mmcif.model.PdbxEntityNonPoly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxNonPolyScheme;
import org.biojava.nbio.structure.io.mmcif.model.PdbxPolySeqScheme;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList;
import org.biojava.nbio.structure.io.mmcif.model.Refine;
import org.biojava.nbio.structure.io.mmcif.model.Struct;
import org.biojava.nbio.structure.io.mmcif.model.StructAsym;
import org.biojava.nbio.structure.io.mmcif.model.StructConn;
import org.biojava.nbio.structure.io.mmcif.model.StructKeywords;
import org.biojava.nbio.structure.io.mmcif.model.StructNcsOper;
import org.biojava.nbio.structure.io.mmcif.model.StructRef;
import org.biojava.nbio.structure.io.mmcif.model.StructRefSeq;
import org.biojava.nbio.structure.io.mmcif.model.Symmetry;
import org.biojava.nbio.structure.jama.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMMcifParser
implements MMcifParser {
    private List<MMcifConsumer> consumers = new ArrayList<MMcifConsumer>();
    public static final String LOOP_END = "#";
    public static final String LOOP_START = "loop_";
    public static final String FIELD_LINE = "_";
    public static final String STRING_LIMIT = ";";
    private static final char s1 = '\'';
    private static final char s2 = '\"';
    private Struct struct = null;
    private static final Logger logger = LoggerFactory.getLogger(SimpleMMcifParser.class);

    @Override
    public void addMMcifConsumer(MMcifConsumer consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public void clearConsumers() {
        this.consumers.clear();
    }

    @Override
    public void removeMMcifConsumer(MMcifConsumer consumer) {
        this.consumers.remove(consumer);
    }

    public static void main(String[] args) {
        String file = "/Users/andreas/WORK/PDB/mmCif/a9/1a9n.cif.gz";
        System.out.println("parsing " + file);
        MMCIFFileReader pdbreader = new MMCIFFileReader();
        try {
            Structure s = pdbreader.getStructure(file);
            System.out.println(s);
            System.out.println(s.toPDB());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void parse(InputStream inStream) throws IOException {
        this.parse(new BufferedReader(new InputStreamReader(inStream)));
    }

    @Override
    public void parse(BufferedReader buf) throws IOException {
        this.triggerDocumentStart();
        this.struct = new Struct();
        String line = null;
        boolean inLoop = false;
        ArrayList<String> loopFields = new ArrayList<String>();
        List<Object> lineData = new ArrayList();
        HashSet<String> loopWarnings = new HashSet<String>();
        String category = null;
        line = buf.readLine();
        if (!line.startsWith("data_")) {
            logger.error("this does not look like a valid MMcif file! The first line should be data_1XYZ, but is " + line);
            this.triggerDocumentEnd();
            return;
        }
        while ((line = buf.readLine()) != null) {
            logger.debug(inLoop + " " + line);
            if (inLoop) {
                if (line.startsWith(LOOP_END)) {
                    inLoop = false;
                    lineData.clear();
                    category = null;
                    loopFields.clear();
                    loopWarnings.clear();
                    continue;
                }
                if (line.startsWith(FIELD_LINE)) {
                    String txt = line.trim();
                    if (txt.indexOf(46) > -1) {
                        String[] spl = txt.split("\\.");
                        category = spl[0];
                        String attribute = spl[1];
                        loopFields.add(attribute);
                        if (spl.length <= 2) continue;
                        logger.warn("found nested attribute, not supported, yet!");
                        continue;
                    }
                    category = txt;
                    continue;
                }
                lineData = this.processLine(line, buf, loopFields.size());
                if (lineData.size() != loopFields.size()) {
                    logger.warn("did not find enough data fields...");
                }
                this.endLineChecks(category, loopFields, lineData, loopWarnings);
                lineData.clear();
                continue;
            }
            if (line.startsWith(LOOP_START)) {
                loopFields.clear();
                loopWarnings.clear();
                inLoop = true;
                category = null;
                lineData.clear();
                continue;
            }
            if (line.startsWith(LOOP_END)) {
                inLoop = false;
                if (category != null) {
                    this.endLineChecks(category, loopFields, lineData, loopWarnings);
                }
                category = null;
                loopFields.clear();
                loopWarnings.clear();
                lineData.clear();
                continue;
            }
            List<String> data = this.processLine(line, buf, 2);
            if (data.size() < 1) {
                lineData.clear();
                continue;
            }
            String key = data.get(0);
            int pos = key.indexOf(".");
            if (pos < 0) {
                if (!line.startsWith("data_")) {
                    logger.warn("this does not look like a valid MMcif file! The first line should be data_1XYZ, but is " + line);
                    this.triggerDocumentEnd();
                    return;
                }
                category = null;
                lineData.clear();
                continue;
            }
            category = key.substring(0, pos);
            String value = data.get(1);
            loopFields.add(key.substring(pos + 1, key.length()));
            lineData.add(value);
        }
        if (this.struct != null) {
            this.triggerStructData(this.struct);
        }
        this.triggerDocumentEnd();
    }

    private List<String> processSingleLine(String line) {
        ArrayList<String> data = new ArrayList<String>();
        if (line.trim().length() == 0) {
            return data;
        }
        if (line.trim().length() == 1 && line.startsWith(STRING_LIMIT)) {
            return data;
        }
        boolean inString = false;
        boolean inS1 = false;
        boolean inS2 = false;
        String word = "";
        for (int i = 0; i < line.length(); ++i) {
            boolean wordEnd;
            Character c = Character.valueOf(line.charAt(i));
            Character nextC = null;
            if (i < line.length() - 1) {
                nextC = Character.valueOf(line.charAt(i + 1));
            }
            if (c.charValue() == ' ') {
                if (!inString) {
                    if (!word.equals("")) {
                        data.add(word.trim());
                    }
                    word = "";
                    continue;
                }
                word = word + c;
                continue;
            }
            if (c.charValue() == '\'') {
                if (inString) {
                    wordEnd = false;
                    if (!inS2 && nextC != null && Character.isWhitespace(nextC.charValue())) {
                        ++i;
                        wordEnd = true;
                    }
                    if (wordEnd) {
                        if (!word.equals("")) {
                            data.add(word.trim());
                        }
                        word = "";
                        inString = false;
                        inS1 = false;
                        continue;
                    }
                    word = word + c;
                    continue;
                }
                inString = true;
                inS1 = true;
                continue;
            }
            if (c.charValue() == '\"') {
                if (inString) {
                    wordEnd = false;
                    if (!inS1 && nextC != null && Character.isWhitespace(nextC.charValue())) {
                        ++i;
                        wordEnd = true;
                    }
                    if (wordEnd) {
                        if (!word.equals("")) {
                            data.add(word.trim());
                        }
                        word = "";
                        inString = false;
                        inS2 = false;
                        continue;
                    }
                    word = word + c;
                    continue;
                }
                inString = true;
                inS2 = true;
                continue;
            }
            word = word + c;
        }
        if (!word.trim().equals("")) {
            data.add(word);
        }
        return data;
    }

    private List<String> processLine(String line, BufferedReader buf, int fieldLength) throws IOException {
        ArrayList<String> lineData = new ArrayList<String>();
        boolean inString = false;
        StringBuilder bigWord = null;
        do {
            if (line.startsWith(STRING_LIMIT)) {
                if (!inString) {
                    inString = true;
                    bigWord = line.length() > 1 ? new StringBuilder(line.substring(1)) : new StringBuilder("");
                } else {
                    lineData.add(bigWord.toString());
                    bigWord = null;
                    inString = false;
                }
            } else if (inString) {
                bigWord.append(line);
            } else {
                List<String> dat = this.processSingleLine(line);
                for (String d : dat) {
                    lineData.add(d);
                }
            }
            if (lineData.size() > fieldLength) {
                logger.warn("wrong data length (" + lineData.size() + ") should be (" + fieldLength + ") at line " + line + " got lineData: " + lineData);
                return lineData;
            }
            if (lineData.size() != fieldLength) continue;
            return lineData;
        } while ((line = buf.readLine()) != null);
        return lineData;
    }

    private void endLineChecks(String category, List<String> loopFields, List<String> lineData, Set<String> loopWarnings) throws IOException {
        if (loopFields.size() != lineData.size()) {
            logger.warn("looks like we got a problem with nested string quote characters:");
            throw new IOException("data length (" + lineData.size() + ") != fields length (" + loopFields.size() + ") category: " + category + " fields: " + loopFields + " DATA: " + lineData);
        }
        if (category.equals("_entity")) {
            Entity e = (Entity)this.buildObject(Entity.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewEntity(e);
        } else if (category.equals("_struct")) {
            this.struct = (Struct)this.buildObject(Struct.class.getName(), loopFields, lineData, loopWarnings);
        } else if (category.equals("_atom_site")) {
            AtomSite a = (AtomSite)this.buildObject(AtomSite.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewAtomSite(a);
        } else if (category.equals("_database_PDB_rev")) {
            DatabasePDBrev dbrev = (DatabasePDBrev)this.buildObject(DatabasePDBrev.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewDatabasePDBrev(dbrev);
        } else if (category.equals("_database_PDB_remark")) {
            DatabasePDBremark remark = (DatabasePDBremark)this.buildObject(DatabasePDBremark.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewDatabasePDBremark(remark);
        } else if (category.equals("_exptl")) {
            Exptl exptl = (Exptl)this.buildObject(Exptl.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerExptl(exptl);
        } else if (category.equals("_cell")) {
            Cell cell = (Cell)this.buildObject(Cell.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewCell(cell);
        } else if (category.equals("_symmetry")) {
            Symmetry symmetry = (Symmetry)this.buildObject(Symmetry.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewSymmetry(symmetry);
        } else if (category.equals("_struct_ncs_oper")) {
            StructNcsOper sNcsOper = this.getStructNcsOper(loopFields, lineData);
            this.triggerNewStructNcsOper(sNcsOper);
        } else if (category.equals("_struct_ref")) {
            StructRef sref = (StructRef)this.buildObject(StructRef.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewStrucRef(sref);
        } else if (category.equals("_struct_ref_seq")) {
            StructRefSeq sref = (StructRefSeq)this.buildObject(StructRefSeq.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewStrucRefSeq(sref);
        } else if (category.equals("_entity_poly_seq")) {
            EntityPolySeq exptl = (EntityPolySeq)this.buildObject(EntityPolySeq.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewEntityPolySeq(exptl);
        } else if (category.equals("_entity_src_gen")) {
            EntitySrcGen entitySrcGen = (EntitySrcGen)this.buildObject(EntitySrcGen.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewEntitySrcGen(entitySrcGen);
        } else if (category.equals("_entity_src_nat")) {
            EntitySrcNat entitySrcNat = (EntitySrcNat)this.buildObject(EntitySrcNat.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewEntitySrcNat(entitySrcNat);
        } else if (category.equals("_pdbx_entity_src_syn")) {
            EntitySrcSyn entitySrcSyn = (EntitySrcSyn)this.buildObject(EntitySrcSyn.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewEntitySrcSyn(entitySrcSyn);
        } else if (category.equals("_struct_asym")) {
            StructAsym sasym = (StructAsym)this.buildObject(StructAsym.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewStructAsym(sasym);
        } else if (category.equals("_pdbx_poly_seq_scheme")) {
            PdbxPolySeqScheme ppss = (PdbxPolySeqScheme)this.buildObject(PdbxPolySeqScheme.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewPdbxPolySeqScheme(ppss);
        } else if (category.equals("_pdbx_nonpoly_scheme")) {
            PdbxNonPolyScheme ppss = (PdbxNonPolyScheme)this.buildObject(PdbxNonPolyScheme.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewPdbxNonPolyScheme(ppss);
        } else if (category.equals("_pdbx_entity_nonpoly")) {
            PdbxEntityNonPoly pen = (PdbxEntityNonPoly)this.buildObject(PdbxEntityNonPoly.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewPdbxEntityNonPoly(pen);
        } else if (category.equals("_struct_keywords")) {
            StructKeywords kw = (StructKeywords)this.buildObject(StructKeywords.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewStructKeywords(kw);
        } else if (category.equals("_refine")) {
            Refine r = (Refine)this.buildObject(Refine.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewRefine(r);
        } else if (category.equals("_chem_comp")) {
            ChemComp c = (ChemComp)this.buildObject(ChemComp.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewChemComp(c);
        } else if (category.equals("_audit_author")) {
            AuditAuthor aa = (AuditAuthor)this.buildObject(AuditAuthor.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewAuditAuthor(aa);
        } else if (category.equals("_pdbx_chem_comp_descriptor")) {
            ChemCompDescriptor ccd = (ChemCompDescriptor)this.buildObject(ChemCompDescriptor.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewChemCompDescriptor(ccd);
        } else if (category.equals("_pdbx_struct_oper_list")) {
            PdbxStructOperList structOper = this.getPdbxStructOperList(loopFields, lineData);
            this.triggerNewPdbxStructOper(structOper);
        } else if (category.equals("_pdbx_struct_assembly")) {
            PdbxStructAssembly sa = (PdbxStructAssembly)this.buildObject(PdbxStructAssembly.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewPdbxStructAssembly(sa);
        } else if (category.equals("_pdbx_struct_assembly_gen")) {
            PdbxStructAssemblyGen sa = (PdbxStructAssemblyGen)this.buildObject(PdbxStructAssemblyGen.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewPdbxStructAssemblyGen(sa);
        } else if (category.equals("_chem_comp_atom")) {
            ChemCompAtom atom = (ChemCompAtom)this.buildObject(ChemCompAtom.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewChemCompAtom(atom);
        } else if (category.equals("_chem_comp_bond")) {
            ChemCompBond bond = (ChemCompBond)this.buildObject(ChemCompBond.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewChemCompBond(bond);
        } else if (category.equals("_pdbx_chem_comp_identifier")) {
            PdbxChemCompIdentifier id = (PdbxChemCompIdentifier)this.buildObject(PdbxChemCompIdentifier.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewPdbxChemCompIdentifier(id);
        } else if (category.equals("_pdbx_chem_comp_descriptor")) {
            PdbxChemCompDescriptor id = (PdbxChemCompDescriptor)this.buildObject(PdbxChemCompDescriptor.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewPdbxChemCompDescriptor(id);
        } else if (category.equals("_struct_conn")) {
            StructConn id = (StructConn)this.buildObject(StructConn.class.getName(), loopFields, lineData, loopWarnings);
            this.triggerNewStructConn(id);
        } else {
            this.triggerGeneric(category, loopFields, lineData);
        }
    }

    private PdbxStructOperList getPdbxStructOperList(List<String> loopFields, List<String> lineData) {
        Double d;
        String val;
        PdbxStructOperList so = new PdbxStructOperList();
        String id = lineData.get(loopFields.indexOf("id"));
        so.setId(id);
        so.setType(lineData.get(loopFields.indexOf("type")));
        Matrix matrix = new Matrix(3, 3);
        for (int i = 1; i <= 3; ++i) {
            for (int j = 1; j <= 3; ++j) {
                String max = String.format("matrix[%d][%d]", j, i);
                val = lineData.get(loopFields.indexOf(max));
                d = Double.parseDouble(val);
                matrix.set(j - 1, i - 1, d);
            }
        }
        double[] coords = new double[3];
        for (int i = 1; i <= 3; ++i) {
            String v = String.format("vector[%d]", i);
            val = lineData.get(loopFields.indexOf(v));
            d = Double.parseDouble(val);
            coords[i - 1] = d;
        }
        so.setMatrix(matrix);
        so.setVector(coords);
        return so;
    }

    public void triggerNewPdbxStructOper(PdbxStructOperList structOper) {
        for (MMcifConsumer c : this.consumers) {
            c.newPdbxStructOperList(structOper);
        }
    }

    private StructNcsOper getStructNcsOper(List<String> loopFields, List<String> lineData) {
        int i;
        StructNcsOper sNcsOper = new StructNcsOper();
        int id = Integer.parseInt(lineData.get(loopFields.indexOf("id")));
        sNcsOper.setId(id);
        sNcsOper.setCode(lineData.get(loopFields.indexOf("code")));
        sNcsOper.setDetails(lineData.get(loopFields.indexOf("details")));
        Matrix4d op = new Matrix4d();
        op.setElement(3, 0, 0.0);
        op.setElement(3, 1, 0.0);
        op.setElement(3, 2, 0.0);
        op.setElement(3, 3, 1.0);
        for (i = 1; i <= 3; ++i) {
            for (int j = 1; j <= 3; ++j) {
                String max = String.format("matrix[%d][%d]", i, j);
                String val = lineData.get(loopFields.indexOf(max));
                Double d = Double.parseDouble(val);
                op.setElement(i - 1, j - 1, d.doubleValue());
            }
        }
        for (i = 1; i <= 3; ++i) {
            String v = String.format("vector[%d]", i);
            String val = lineData.get(loopFields.indexOf(v));
            Double d = Double.parseDouble(val);
            op.setElement(i - 1, 3, d.doubleValue());
        }
        sNcsOper.setOperator(op);
        return sNcsOper;
    }

    public void triggerNewStructNcsOper(StructNcsOper sNcsOper) {
        for (MMcifConsumer c : this.consumers) {
            c.newStructNcsOper(sNcsOper);
        }
    }

    private void setArray(Class c, Object o, String key, String val) {
    }

    private Object buildObject(String className, List<String> loopFields, List<String> lineData, Set<String> warnings) {
        Object o = null;
        try {
            Class<?> c = Class.forName(className);
            o = c.newInstance();
            int pos = -1;
            for (String key : loopFields) {
                String val = lineData.get(++pos);
                String u = key.substring(0, 1).toUpperCase();
                if (key.contains("-")) {
                    key = key.replace('-', '_');
                }
                try {
                    Method m = c.getMethod("set" + u + key.substring(1, key.length()), String.class);
                    m.invoke(o, val);
                }
                catch (NoSuchMethodException nex) {
                    if (key.indexOf("[") > -1) {
                        this.setArray(c, o, key, val);
                        continue;
                    }
                    String warning = "Trying to set field " + key + " in " + c.getName() + ", but not found! (value:" + val + ")";
                    String warnkey = key + "-" + c.getName();
                    if (val.equals("?") || val.equals(".") || warnings != null && warnings.contains(warnkey)) {
                        logger.debug(warning);
                    } else {
                        logger.warn(warning);
                    }
                    if (warnings == null) continue;
                    warnings.add(warnkey);
                }
            }
        }
        catch (InstantiationException eix) {
            logger.warn("Error while constructing " + className, (Object)eix.getMessage());
        }
        catch (InvocationTargetException etx) {
            logger.warn("Error while constructing " + className, (Object)etx.getMessage());
        }
        catch (IllegalAccessException eax) {
            logger.warn("Error while constructing " + className, (Object)eax.getMessage());
        }
        catch (ClassNotFoundException ex) {
            logger.warn("Error while constructing " + className, (Object)ex.getMessage());
        }
        return o;
    }

    public void triggerGeneric(String category, List<String> loopFields, List<String> lineData) {
        for (MMcifConsumer c : this.consumers) {
            c.newGenericData(category, loopFields, lineData);
        }
    }

    public void triggerNewEntity(Entity entity) {
        for (MMcifConsumer c : this.consumers) {
            c.newEntity(entity);
        }
    }

    public void triggerNewEntityPolySeq(EntityPolySeq epolseq) {
        for (MMcifConsumer c : this.consumers) {
            c.newEntityPolySeq(epolseq);
        }
    }

    public void triggerNewEntitySrcGen(EntitySrcGen entitySrcGen) {
        for (MMcifConsumer c : this.consumers) {
            c.newEntitySrcGen(entitySrcGen);
        }
    }

    public void triggerNewEntitySrcNat(EntitySrcNat entitySrcNat) {
        for (MMcifConsumer c : this.consumers) {
            c.newEntitySrcNat(entitySrcNat);
        }
    }

    public void triggerNewEntitySrcSyn(EntitySrcSyn entitySrcSyn) {
        for (MMcifConsumer c : this.consumers) {
            c.newEntitySrcSyn(entitySrcSyn);
        }
    }

    public void triggerNewChemComp(ChemComp cc) {
        for (MMcifConsumer c : this.consumers) {
            c.newChemComp(cc);
        }
    }

    public void triggerNewStructAsym(StructAsym sasym) {
        for (MMcifConsumer c : this.consumers) {
            c.newStructAsym(sasym);
        }
    }

    private void triggerStructData(Struct struct) {
        for (MMcifConsumer c : this.consumers) {
            c.setStruct(struct);
        }
    }

    private void triggerNewAtomSite(AtomSite atom) {
        for (MMcifConsumer c : this.consumers) {
            c.newAtomSite(atom);
        }
    }

    private void triggerNewAuditAuthor(AuditAuthor aa) {
        for (MMcifConsumer c : this.consumers) {
            c.newAuditAuthor(aa);
        }
    }

    private void triggerNewDatabasePDBrev(DatabasePDBrev dbrev) {
        for (MMcifConsumer c : this.consumers) {
            c.newDatabasePDBrev(dbrev);
        }
    }

    private void triggerNewDatabasePDBremark(DatabasePDBremark remark) {
        for (MMcifConsumer c : this.consumers) {
            c.newDatabasePDBremark(remark);
        }
    }

    private void triggerExptl(Exptl exptl) {
        for (MMcifConsumer c : this.consumers) {
            c.newExptl(exptl);
        }
    }

    private void triggerNewCell(Cell cell) {
        for (MMcifConsumer c : this.consumers) {
            c.newCell(cell);
        }
    }

    private void triggerNewSymmetry(Symmetry symmetry) {
        for (MMcifConsumer c : this.consumers) {
            c.newSymmetry(symmetry);
        }
    }

    private void triggerNewStrucRef(StructRef sref) {
        for (MMcifConsumer c : this.consumers) {
            c.newStructRef(sref);
        }
    }

    private void triggerNewStrucRefSeq(StructRefSeq sref) {
        for (MMcifConsumer c : this.consumers) {
            c.newStructRefSeq(sref);
        }
    }

    private void triggerNewPdbxPolySeqScheme(PdbxPolySeqScheme ppss) {
        for (MMcifConsumer c : this.consumers) {
            c.newPdbxPolySeqScheme(ppss);
        }
    }

    private void triggerNewPdbxNonPolyScheme(PdbxNonPolyScheme ppss) {
        for (MMcifConsumer c : this.consumers) {
            c.newPdbxNonPolyScheme(ppss);
        }
    }

    public void triggerNewPdbxEntityNonPoly(PdbxEntityNonPoly pen) {
        for (MMcifConsumer c : this.consumers) {
            c.newPdbxEntityNonPoly(pen);
        }
    }

    public void triggerNewStructKeywords(StructKeywords kw) {
        for (MMcifConsumer c : this.consumers) {
            c.newStructKeywords(kw);
        }
    }

    public void triggerNewRefine(Refine r) {
        for (MMcifConsumer c : this.consumers) {
            c.newRefine(r);
        }
    }

    public void triggerDocumentStart() {
        for (MMcifConsumer c : this.consumers) {
            c.documentStart();
        }
    }

    public void triggerDocumentEnd() {
        for (MMcifConsumer c : this.consumers) {
            c.documentEnd();
        }
    }

    public void triggerNewChemCompDescriptor(ChemCompDescriptor ccd) {
        for (MMcifConsumer c : this.consumers) {
            c.newChemCompDescriptor(ccd);
        }
    }

    private void triggerNewPdbxStructAssembly(PdbxStructAssembly sa) {
        for (MMcifConsumer c : this.consumers) {
            c.newPdbxStrucAssembly(sa);
        }
    }

    private void triggerNewPdbxStructAssemblyGen(PdbxStructAssemblyGen sa) {
        for (MMcifConsumer c : this.consumers) {
            c.newPdbxStrucAssemblyGen(sa);
        }
    }

    private void triggerNewChemCompAtom(ChemCompAtom atom) {
        for (MMcifConsumer c : this.consumers) {
            c.newChemCompAtom(atom);
        }
    }

    private void triggerNewChemCompBond(ChemCompBond bond) {
        for (MMcifConsumer c : this.consumers) {
            c.newChemCompBond(bond);
        }
    }

    private void triggerNewPdbxChemCompIdentifier(PdbxChemCompIdentifier id) {
        for (MMcifConsumer c : this.consumers) {
            c.newPdbxChemCompIndentifier(id);
        }
    }

    private void triggerNewPdbxChemCompDescriptor(PdbxChemCompDescriptor id) {
        for (MMcifConsumer c : this.consumers) {
            c.newPdbxChemCompDescriptor(id);
        }
    }

    private void triggerNewStructConn(StructConn id) {
        for (MMcifConsumer c : this.consumers) {
            c.newStructConn(id);
        }
    }
}

