/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.sifts;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.biojava.nbio.structure.io.sifts.SiftsEntity;
import org.biojava.nbio.structure.io.sifts.SiftsResidue;
import org.biojava.nbio.structure.io.sifts.SiftsSegment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SiftsXMLParser {
    Document dom;
    List<SiftsEntity> entities = new ArrayList<SiftsEntity>();
    static boolean debug = false;

    public List<SiftsEntity> getEntities() {
        return this.entities;
    }

    public void parseXmlFile(InputStream is) {
        this.entities = new ArrayList<SiftsEntity>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(is);
            this.parseDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void parseDocument() {
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("entity");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                SiftsEntity e = this.getSiftsEntity(el);
                this.entities.add(e);
            }
        }
    }

    private SiftsEntity getSiftsEntity(Element empEl) {
        String type = empEl.getAttribute("type");
        String entityId = empEl.getAttribute("entityId");
        SiftsEntity entity = new SiftsEntity(type, entityId);
        NodeList nl = empEl.getElementsByTagName("segment");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                SiftsSegment s = this.getSiftsSegment(el);
                entity.addSegment(s);
            }
        }
        return entity;
    }

    private SiftsSegment getSiftsSegment(Element el) {
        NodeList nl;
        String segId = el.getAttribute("segId");
        String start = el.getAttribute("start");
        String end = el.getAttribute("end");
        SiftsSegment seg = new SiftsSegment(segId, start, end);
        if (debug) {
            System.out.println("parsed " + seg);
        }
        if ((nl = el.getElementsByTagName("listResidue")) != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element listResidueEl = (Element)nl.item(i);
                NodeList residueNodes = listResidueEl.getElementsByTagName("residue");
                if (residueNodes == null || residueNodes.getLength() <= 0) continue;
                for (int j = 0; j < residueNodes.getLength(); ++j) {
                    Element residue = (Element)residueNodes.item(j);
                    SiftsResidue pos = this.getResidue(residue);
                    seg.addResidue(pos);
                }
            }
        }
        return seg;
    }

    private SiftsResidue getResidue(Element residue) {
        SiftsResidue res = new SiftsResidue();
        String dbResNumS = residue.getAttribute("dbResNum");
        res.setNaturalPos(Integer.parseInt(dbResNumS));
        String seqResName = residue.getAttribute("dbResName");
        res.setSeqResName(seqResName);
        boolean observed = true;
        String detail = this.getTextValue(residue, "residueDetail");
        if (detail != null && detail.trim().equalsIgnoreCase("Not_Observed")) {
            observed = false;
        }
        res.setNotObserved(!observed);
        NodeList nl = residue.getElementsByTagName("crossRefDb");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element crossRefEl = (Element)nl.item(i);
                String dbSource = crossRefEl.getAttribute("dbSource");
                String dbCoordSys = crossRefEl.getAttribute("dbCoordSys");
                String dbAccessionId = crossRefEl.getAttribute("dbAccessionId");
                String dbResNum = crossRefEl.getAttribute("dbResNum");
                String dbResName = crossRefEl.getAttribute("dbResName");
                String dbChainId = crossRefEl.getAttribute("dbChainId");
                if (dbSource.equals("PDB") && dbCoordSys.equals("PDBresnum")) {
                    res.setPdbResNum(dbResNum);
                    res.setPdbResName(dbResName);
                    res.setChainId(dbChainId);
                    res.setPdbId(dbAccessionId);
                    continue;
                }
                if (!dbSource.equals("UniProt")) continue;
                res.setUniProtPos(Integer.parseInt(dbResNum));
                res.setUniProtResName(dbResName);
                res.setUniProtAccessionId(dbAccessionId);
            }
        }
        return res;
    }

    private String getTextValue(Element ele, String tagName) {
        String textVal = null;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            textVal = el.getFirstChild().getNodeValue();
        }
        return textVal;
    }
}

