/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.secstruc;

import java.math.BigDecimal;
import java.math.BigInteger;

public class BigSqrt {
    private static BigDecimal ZERO = new BigDecimal("0");
    private static BigDecimal ONE = new BigDecimal("1");
    private static BigDecimal TWO = new BigDecimal("2");
    public static final int DEFAULT_MAX_ITERATIONS = 50;
    public static final int DEFAULT_SCALE = 3;
    private BigDecimal error;
    private int iterations;
    private boolean traceFlag;
    private int scale = 3;
    private int maxIterations = 50;

    public BigDecimal getError() {
        return this.error;
    }

    public int getIterations() {
        return this.iterations;
    }

    public boolean getTraceFlag() {
        return this.traceFlag;
    }

    public void setTraceFlag(boolean flag) {
        this.traceFlag = flag;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    private static BigDecimal getInitialApproximation(BigDecimal n) {
        BigInteger integerPart = n.toBigInteger();
        int length = integerPart.toString().length();
        if (length % 2 == 0) {
            --length;
        }
        BigDecimal guess = ONE.movePointRight(length /= 2);
        return guess;
    }

    public BigDecimal sqrt(BigInteger n) {
        return this.sqrt(new BigDecimal(n));
    }

    public BigDecimal sqrt(BigDecimal n) {
        if (n.compareTo(ZERO) <= 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal initialGuess = BigSqrt.getInitialApproximation(n);
        BigDecimal lastGuess = ZERO;
        BigDecimal guess = new BigDecimal(initialGuess.toString());
        this.iterations = 0;
        boolean more = true;
        while (more) {
            lastGuess = guess;
            guess = n.divide(guess, this.scale, 4);
            guess = guess.add(lastGuess);
            guess = guess.divide(TWO, this.scale, 4);
            this.error = n.subtract(guess.multiply(guess));
            if (++this.iterations >= this.maxIterations) {
                more = false;
                continue;
            }
            if (!lastGuess.equals(guess)) continue;
            more = this.error.abs().compareTo(ONE) >= 0;
        }
        return guess;
    }
}

