/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.secstruc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.biojava.nbio.structure.secstruc.BigSqrt;
import org.biojava.nbio.structure.secstruc.BridgeType;
import org.biojava.nbio.structure.secstruc.DistEn;
import org.biojava.nbio.structure.secstruc.HBond;
import org.biojava.nbio.structure.secstruc.Ladder;
import org.biojava.nbio.structure.secstruc.SecStrucGroup;
import org.biojava.nbio.structure.secstruc.SecStrucState;
import org.biojava.nbio.structure.secstruc.SecStrucType;

public class SecStruc {
    private static final boolean debug = false;
    public static double MINDIST = 0.5;
    public static int CA_MIN_DIST = 9;
    public static int HBONDLOWENERGY = -9900;
    public static double HBONDHIGHENERGY = -500.0;
    public static double Q = -27888.0;
    private SecStrucGroup[] groups;
    List<DistEn> distVsEnergy = new ArrayList<DistEn>();
    List<Ladder> ladders = new ArrayList<Ladder>();

    public static void main(String[] args) {
        try {
            AtomCache cache = new AtomCache();
            cache.setFetchBehavior(LocalPDBDirectory.FetchBehavior.LOCAL_ONLY);
            Structure s = cache.getStructure("5pti");
            SecStruc sec = new SecStruc();
            sec.assign(s);
            System.out.println(sec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void assign(Structure s) throws StructureException {
        this.groups = SecStruc.initGroupArray(s);
        if (this.groups.length < 5) {
            throw new StructureException("not enough groups in structure to calculate secondary structure (" + this.groups.length + ")");
        }
        this.calculateHAtoms();
        this.calculateHBonds();
        this.calculateTurns();
        this.calculateDihedralAngles();
        this.buildHelices();
        this.detectBends();
        this.detectStrands();
    }

    private void detectStrands() {
        for (int i = 1; i < this.groups.length - 1; ++i) {
            this.testBridge(i);
        }
        this.connectLadders();
        this.updateSheets();
    }

    private void updateSheets() {
        for (Ladder ladder : this.ladders) {
            int lcount;
            for (int lcount2 = ladder.from; lcount2 <= ladder.to; ++lcount2) {
                SecStrucState state = this.getSecStrucState(lcount2);
                SecStrucType stype = state.getSecStruc();
                int diff = ladder.from - lcount2;
                int l2count = ladder.lfrom - diff;
                SecStrucState state2 = this.getSecStrucState(l2count);
                SecStrucType stype2 = state2.getSecStruc();
                if (ladder.from != ladder.to) {
                    if (!stype.isHelixType()) {
                        this.setSecStrucType(lcount2, SecStrucType.extended);
                    }
                    if (stype2.isHelixType()) continue;
                    this.setSecStrucType(l2count, SecStrucType.extended);
                    continue;
                }
                if (!stype.isHelixType() && !stype.equals(SecStrucType.extended)) {
                    this.setSecStrucType(lcount2, SecStrucType.bridge);
                }
                if (stype2.isHelixType() || stype2.equals(SecStrucType.extended)) continue;
                this.setSecStrucType(l2count, SecStrucType.bridge);
            }
            if (ladder.connectedTo == 0) continue;
            Ladder conladder = this.ladders.get(ladder.connectedTo);
            if (ladder.getBtype().equals(BridgeType.antiparallel)) {
                for (lcount = ladder.from; lcount <= conladder.to; ++lcount) {
                    this.testSetExtendedSecStrucState(lcount);
                }
                for (lcount = conladder.lto; lcount <= ladder.lfrom; ++lcount) {
                    this.testSetExtendedSecStrucState(lcount);
                }
                continue;
            }
            for (lcount = ladder.from; lcount <= conladder.to; ++lcount) {
                this.testSetExtendedSecStrucState(lcount);
            }
            for (lcount = ladder.lfrom; lcount <= conladder.lto; ++lcount) {
                this.testSetExtendedSecStrucState(lcount);
            }
        }
    }

    private void testSetExtendedSecStrucState(int lcount) {
        SecStrucState state = this.getSecStrucState(lcount);
        SecStrucType stype = state.getSecStruc();
        if (!stype.isHelixType()) {
            this.setSecStrucType(lcount, SecStrucType.extended);
        }
    }

    private void connectLadders() {
        for (int i = 0; i < this.ladders.size(); ++i) {
            for (int j = i; j < this.ladders.size(); ++j) {
                Ladder l2;
                Ladder l1 = this.ladders.get(i);
                if (!this.hasBulge(l1, l2 = this.ladders.get(j))) continue;
                l1.connectedTo = j;
                l2.connectedFrom = i;
            }
        }
    }

    private boolean hasBulge(Ladder l1, Ladder l2) {
        boolean bulge;
        boolean bl = bulge = l1.getBtype().equals(l2.getBtype()) && l2.from - l1.to < 6 && l1.to < l2.from && l2.connectedTo == 0;
        if (!bulge) {
            return bulge;
        }
        bulge = l1.getBtype().equals(BridgeType.parallel) ? l2.lfrom - l1.lto > 0 && (l2.lfrom - l1.lto < 6 && l2.from - l1.to < 3 || l2.lfrom - l1.lto < 3) : l1.lfrom - l2.lto > 0 && (l1.lfrom - l2.lto < 6 && l2.from - l1.to < 3 || l1.lfrom - l2.lto < 3);
        return bulge;
    }

    private void registerBridge(int start, int end, BridgeType btype) {
        if (start > end) {
            return;
        }
        boolean found = false;
        for (Ladder ladder : this.ladders) {
            if (!this.shouldExtendLadder(ladder, start, end, btype)) continue;
            found = true;
            ++ladder.to;
            if (btype.equals(BridgeType.parallel)) {
                ++ladder.lto;
                break;
            }
            --ladder.lfrom;
            break;
        }
        if (!found) {
            Ladder l = new Ladder();
            l.setFrom(start);
            l.setTo(end);
            l.setBtype(btype);
            l.setLfrom(start);
            l.setLto(end);
            this.ladders.add(l);
        }
    }

    private boolean shouldExtendLadder(Ladder ladder, int start, int end, BridgeType btype) {
        return btype.equals(ladder.getBtype()) && start == ladder.getTo() + 1 && (end == ladder.getLto() + 1 && btype.equals(BridgeType.parallel) || end == ladder.getLfrom() - 1 && btype.equals(BridgeType.parallel));
    }

    private void testBridge(int i) {
        int foundNrBridges = 0;
        for (int currpos = i + 3; foundNrBridges < 2 && currpos < this.groups.length - 1; ++currpos) {
            BridgeType btype = null;
            if (this.isBonded(i + 1, currpos) && this.isBonded(currpos, i - 1) || this.isBonded(currpos + 1, i) && this.isBonded(i, currpos - 1)) {
                btype = BridgeType.parallel;
            } else if (this.isBonded(i, currpos) && this.isBonded(currpos, i) || this.isBonded(i + 1, currpos - 1) && this.isBonded(currpos + 1, i - 1)) {
                btype = BridgeType.antiparallel;
            }
            if (btype == null) continue;
            ++foundNrBridges;
            this.registerBridge(i, currpos, btype);
        }
    }

    private void detectBends() {
        if (this.groups.length < 5) {
            return;
        }
        for (int i = 2; i < this.groups.length - 2; ++i) {
            SecStrucGroup im2 = this.groups[i - 2];
            SecStrucGroup g = this.groups[i];
            SecStrucGroup ip2 = this.groups[i + 2];
            Atom caim2 = im2.getCA();
            Atom cag = g.getCA();
            Atom caip2 = ip2.getCA();
            Atom caminus2 = Calc.subtract(caim2, cag);
            Atom caplus2 = Calc.subtract(cag, caip2);
            double angle = Calc.angle(caminus2, caplus2);
            SecStrucState state = this.getSecStrucState(i);
            state.setKappa((float)angle);
            if (!(angle > 70.0)) continue;
            if (state.getSecStruc().equals(SecStrucType.coil)) {
                state.setSecStruc(SecStrucType.bend);
            }
            state.setBend(true);
        }
    }

    private void calculateDihedralAngles() throws StructureException {
        for (int i = 0; i < this.groups.length - 1; ++i) {
            SecStrucGroup a = this.groups[i];
            SecStrucGroup b = this.groups[i + 1];
            Atom a_N = a.getN();
            Atom a_CA = a.getCA();
            Atom a_C = a.getC();
            Atom b_N = b.getN();
            Atom b_CA = b.getCA();
            Atom b_C = b.getC();
            double phi = Calc.torsionAngle(a_C, b_N, b_CA, b_C);
            double psi = Calc.torsionAngle(a_N, a_CA, a_C, b_N);
            double omega = Calc.torsionAngle(a_CA, a_C, b_N, b_CA);
            SecStrucState state1 = (SecStrucState)a.getProperty("secstruc");
            SecStrucState state2 = (SecStrucState)b.getProperty("secstruc");
            state2.setPhi(phi);
            state1.setPsi(psi);
            state1.setOmega(omega);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("  #  RESIDUE AA STRUCTURE BP1 BP2  ACC     N-H-->O    O-->H-N    N-H-->O    O-->H-N    TCO  KAPPA ALPHA  PHI     PSI     Omega    X-CA   Y-CA   Z-CA ");
        buf.append(nl);
        for (int i = 0; i < this.groups.length; ++i) {
            SecStrucGroup g = this.groups[i];
            SecStrucState state = (SecStrucState)g.getProperty("secstruc");
            buf.append(i + 1).append(" ");
            buf.append(g.getChainId()).append(" ");
            buf.append(g.getPDBName()).append(" ");
            buf.append(g.getResidueNumber().toString()).append("\t");
            boolean[] turns = state.getTurn();
            for (int t = 0; t < 3; ++t) {
                if (turns[t]) {
                    buf.append('>');
                    continue;
                }
                buf.append(' ');
            }
            buf.append(state.getSecStruc().type);
            buf.append(" ");
            if (state.isBend()) {
                buf.append('S');
            } else {
                buf.append(" ");
            }
            buf.append("                 ");
            int p1 = state.getAccept1().getPartner();
            if (p1 != 0) {
                p1 -= i;
            }
            double e1 = state.getAccept1().getEnergy() / 1000.0;
            buf.append(String.format("%6d,%4.1f", p1, e1));
            int p2 = state.getDonor1().getPartner();
            if (p2 != 0) {
                p2 -= i;
            }
            double e2 = state.getDonor1().getEnergy() / 1000.0;
            buf.append(String.format("%6d,%4.1f", p2, e2));
            int p3 = state.getAccept1().getPartner();
            if (p3 != 0) {
                p3 -= i;
            }
            double e3 = state.getAccept2().getEnergy() / 1000.0;
            buf.append(String.format("%6d,%4.1f", p3, e3));
            int p4 = state.getDonor2().getPartner();
            if (p4 != 0) {
                p4 -= i;
            }
            double e4 = state.getDonor2().getEnergy() / 1000.0;
            buf.append(String.format("%6d,%4.1f", p4, e4));
            double kappa = state.getKappa();
            double phi = state.getPhi();
            double psi = state.getPsi();
            double omega = state.getOmega();
            buf.append("        ");
            buf.append(String.format("%6.1f", kappa));
            buf.append("       ");
            buf.append(String.format("%6.1f %6.1f %6.1f", phi, psi, omega));
            buf.append(nl);
        }
        return buf.toString();
    }

    private static SecStrucGroup[] initGroupArray(Structure s) {
        ArrayList<SecStrucGroup> groupList = new ArrayList<SecStrucGroup>();
        for (Chain c : s.getChains()) {
            for (Group g : c.getAtomGroups()) {
                if (!g.hasAminoAtoms()) continue;
                SecStrucGroup sg = new SecStrucGroup();
                sg.setResidueNumber(g.getResidueNumber());
                sg.setPDBFlag(true);
                sg.setPDBName(g.getPDBName());
                sg.setChain(g.getChain());
                Atom N = g.getAtom("N");
                Atom CA = g.getAtom("CA");
                Atom C = g.getAtom("C");
                Atom O = g.getAtom("O");
                if (N == null || CA == null || C == null || O == null) continue;
                sg.setN((Atom)N.clone());
                sg.setCA((Atom)CA.clone());
                sg.setC((Atom)C.clone());
                sg.setO((Atom)O.clone());
                sg.setOriginal(g);
                SecStrucState state = new SecStrucState();
                Map<String, Object> m = sg.getProperties();
                if (m == null) {
                    m = new HashMap<String, Object>();
                    sg.setProperties(m);
                }
                m.put("secstruc", state);
                groupList.add(sg);
            }
        }
        return groupList.toArray(new SecStrucGroup[groupList.size()]);
    }

    private void calculateHAtoms() throws StructureException {
        for (int i = 0; i < this.groups.length - 1; ++i) {
            SecStrucGroup a = this.groups[i];
            SecStrucGroup b = this.groups[i + 1];
            if (b.hasAtom("H")) continue;
            Atom H = SecStruc.calcSimple_H(a.getC(), a.getO(), b.getN());
            b.setH(H);
        }
    }

    private void calculateHBonds() throws StructureException {
        if (this.groups.length < 5) {
            return;
        }
        for (int i = 1; i < this.groups.length; ++i) {
            SecStrucGroup one = this.groups[i];
            if (!one.hasAtom("H")) {
                System.out.println(" no H at " + i);
                continue;
            }
            for (int j = i + 1; j < this.groups.length; ++j) {
                SecStrucGroup two = this.groups[j];
                double dist = Calc.getDistance(one.getCA(), two.getCA());
                if (dist >= (double)CA_MIN_DIST) continue;
                this.checkAddHBond(i, j);
                if (j == i + 1) continue;
                this.checkAddHBond(j, i);
            }
        }
    }

    private void checkAddHBond(int i, int j) {
        SecStrucGroup one = this.groups[i];
        if (one.getPDBName().equals("PRO")) {
            return;
        }
        SecStrucGroup two = this.groups[j];
        if (!two.hasAtom("H")) {
            System.err.println("two has no H " + j);
            return;
        }
        double energy = 0.0;
        try {
            energy = this.calculateHBondEnergy(one, two);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.trackHBondEnergy(i, j, energy);
    }

    public double calculateHBondEnergy(SecStrucGroup one, SecStrucGroup two) throws StructureException {
        Atom N = one.getN();
        Atom H = one.getH();
        Atom O = two.getO();
        Atom C = two.getC();
        double dno = Calc.getDistance(O, N);
        double dhc = Calc.getDistance(C, H);
        double dho = Calc.getDistance(O, H);
        double dnc = Calc.getDistance(C, N);
        double contact = MINDIST;
        if (dno < contact || dhc < contact || dnc < contact || dno < contact) {
            return HBONDLOWENERGY;
        }
        double e1 = Q / dho - Q / dhc;
        double e2 = Q / dnc - Q / dno;
        double energy = e1 + e2;
        if (energy > (double)HBONDLOWENERGY) {
            return energy;
        }
        return HBONDLOWENERGY;
    }

    public static BigDecimal getPreciseDistance(Atom a, Atom b) throws StructureException {
        double x = a.getX() - b.getX();
        double y = a.getY() - b.getY();
        double z = a.getZ() - b.getZ();
        double s = x * x + y * y + z * z;
        BigSqrt sqrt = new BigSqrt();
        BigDecimal d = new BigDecimal(s);
        BigDecimal dist = sqrt.sqrt(d);
        return dist;
    }

    private void trackHBondEnergy(int i, int j, double energy) {
        HBond bond;
        SecStrucGroup one = this.groups[i];
        SecStrucGroup two = this.groups[j];
        if (one.getPDBName().equals("PRO")) {
            return;
        }
        SecStrucState stateOne = (SecStrucState)one.getProperty("secstruc");
        SecStrucState stateTwo = (SecStrucState)two.getProperty("secstruc");
        double acc1e = stateOne.getAccept1().getEnergy();
        double acc2e = stateOne.getAccept2().getEnergy();
        double don1e = stateTwo.getDonor1().getEnergy();
        double don2e = stateTwo.getDonor2().getEnergy();
        if (energy < acc1e) {
            stateOne.setAccept2(stateOne.getAccept1());
            bond = new HBond();
            bond.setEnergy(energy);
            bond.setPartner(j);
            stateOne.setAccept1(bond);
        } else if (energy < acc2e) {
            bond = new HBond();
            bond.setEnergy(energy);
            bond.setPartner(j);
            stateOne.setAccept2(bond);
        }
        if (energy < don1e) {
            stateTwo.setDonor2(stateTwo.getDonor1());
            bond = new HBond();
            bond.setEnergy(energy);
            bond.setPartner(i);
            stateTwo.setDonor1(bond);
        } else if (energy < don2e) {
            bond = new HBond();
            bond.setEnergy(energy);
            bond.setPartner(i);
            stateTwo.setDonor2(bond);
        }
    }

    private void calculateTurns() {
        int l = this.groups.length;
        for (int i = 0; i < l; ++i) {
            for (int turn = 3; turn <= 5; ++turn) {
                if (i + turn >= l || !this.isBonded(i + turn, i)) continue;
                for (int j = i; j < i + turn + 1; ++j) {
                    SecStrucGroup group = this.groups[j];
                    SecStrucState state = (SecStrucState)group.getProperty("secstruc");
                    boolean[] turns = state.getTurn();
                    turns[turn - 3] = true;
                }
            }
        }
    }

    private boolean isBonded(int i, int j) {
        SecStrucGroup one = this.groups[i];
        SecStrucState stateOne = (SecStrucState)one.getProperty("secstruc");
        double acc1e = stateOne.getAccept1().getEnergy();
        double acc2e = stateOne.getAccept2().getEnergy();
        int partnerAcc1 = stateOne.getAccept1().getPartner();
        int partnerAcc2 = stateOne.getAccept2().getPartner();
        return partnerAcc1 == j && acc1e < HBONDHIGHENERGY || partnerAcc2 == j && acc2e < HBONDHIGHENERGY;
    }

    private static Atom calc_H(Atom C, Atom N, Atom CA) throws StructureException {
        Atom nc = Calc.subtract(N, C);
        Atom nca = Calc.subtract(N, CA);
        Atom u_nc = Calc.unitVector(nc);
        Atom u_nca = Calc.unitVector(nca);
        Atom added = Calc.add(u_nc, u_nca);
        Atom U = Calc.unitVector(added);
        Atom H = Calc.add(N, U);
        H.setName("H");
        return H;
    }

    private static Atom calcSimple_H(Atom c, Atom o, Atom n) throws StructureException {
        Atom h = Calc.subtract(c, o);
        double dist = Calc.getDistance(o, c);
        double x = n.getX() + h.getX() / dist;
        double y = n.getY() + h.getY() / dist;
        double z = n.getZ() + h.getZ() / dist;
        h.setX(x);
        h.setY(y);
        h.setZ(z);
        h.setName("H");
        return h;
    }

    public SecStrucGroup[] getGroups() {
        return this.groups;
    }

    private void buildHelices() {
        if (this.groups.length < 5) {
            return;
        }
        this.checkSetHelix(4, SecStrucType.helix4);
        this.checkSetHelix(3, SecStrucType.helix3);
        this.checkSetHelix(5, SecStrucType.helix5);
        this.checkSetTurns();
    }

    private void checkSetTurns() {
        for (int i = 0; i < this.groups.length - 3; ++i) {
            SecStrucGroup g = this.groups[i];
            SecStrucState state = (SecStrucState)g.getProperty("secstruc");
            SecStrucType type = state.getSecStruc();
            if (type.isHelixType()) continue;
            boolean[] turns = state.getTurn();
            for (int t = 0; t < 3; ++t) {
                if (!turns[t]) continue;
                for (int l = i + 1; l < i + t + 3 && l < this.groups.length; ++l) {
                    SecStrucType typel = this.getSecStrucType(l);
                    if (!typel.equals(SecStrucType.coil)) continue;
                    this.setSecStrucType(l, SecStrucType.turn);
                }
            }
        }
    }

    private void checkSetHelix(int prange, SecStrucType type) {
        int range = prange - 3;
        for (int i = 1; i < this.groups.length - range - 1; ++i) {
            int curr;
            SecStrucGroup g = this.groups[i];
            SecStrucState state = (SecStrucState)g.getProperty("secstruc");
            SecStrucGroup prevG = this.groups[i - 1];
            SecStrucState prevState = (SecStrucState)prevG.getProperty("secstruc");
            SecStrucGroup nextG = this.groups[i + 1];
            SecStrucState nextState = (SecStrucState)nextG.getProperty("secstruc");
            boolean[] turns = state.getTurn();
            boolean[] pturns = prevState.getTurn();
            boolean[] nturns = nextState.getTurn();
            if (!turns[range] || !pturns[range] || !nturns[range]) continue;
            boolean empty = true;
            for (curr = i; curr <= i + range; ++curr) {
                SecStrucType cstate = this.getSecStrucType(curr);
                if (!cstate.isHelixType()) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            for (curr = i; curr <= i + range; ++curr) {
                this.setSecStrucType(curr, type);
            }
        }
    }

    private void setSecStrucType(int pos, SecStrucType state) {
        SecStrucGroup g = this.groups[pos];
        SecStrucState s = (SecStrucState)g.getProperty("secstruc");
        s.setSecStruc(state);
    }

    private SecStrucType getSecStrucType(int pos) {
        SecStrucState s = this.getSecStrucState(pos);
        return s.getSecStruc();
    }

    private SecStrucState getSecStrucState(int pos) {
        SecStrucGroup g = this.groups[pos];
        SecStrucState state = (SecStrucState)g.getProperty("secstruc");
        return state;
    }
}

