/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.List;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.symmetry.utils.Graph;
import org.biojava.nbio.structure.symmetry.utils.SimpleGraph;

public class SubunitGraph {
    private static double DISTANCE_CUTOFF = 8.0;
    private static int MIN_CONTACTS = 10;
    private List<Point3d[]> caCoords = null;

    public SubunitGraph(List<Point3d[]> caCoords) {
        this.caCoords = caCoords;
    }

    public Graph<Integer> getProteinGraph() {
        int i;
        int n = this.caCoords.size();
        SimpleGraph<Integer> graph = new SimpleGraph<Integer>();
        for (i = 0; i < n; ++i) {
            graph.addVertex(i);
        }
        for (i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.calcContactNumber(this.caCoords.get(i), this.caCoords.get(j)) < MIN_CONTACTS) continue;
                graph.addEdge(i, j);
            }
        }
        return graph;
    }

    private int calcContactNumber(Point3d[] a, Point3d[] b) {
        double distCutoffSq = DISTANCE_CUTOFF * DISTANCE_CUTOFF;
        int contacts = 0;
        for (Point3d pa : a) {
            for (Point3d pb : b) {
                if (!(pa.distanceSquared(pb) < distCutoffSq)) continue;
                ++contacts;
            }
        }
        return contacts;
    }
}

