/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.symmetry.geometry.MomentsOfInertia;
import org.biojava.nbio.structure.symmetry.geometry.SuperPosition;

public class Subunits {
    private List<Point3d[]> caCoords = Collections.emptyList();
    private List<Integer> sequenceClusterIds = Collections.emptyList();
    private List<Boolean> pseudoStoichiometry = Collections.emptyList();
    private List<Double> minSequenceIdentity = Collections.emptyList();
    private List<Double> maxSequenceIdentity = Collections.emptyList();
    private List<String> chainIds = Collections.emptyList();
    private List<Integer> modelNumbers = Collections.emptyList();
    private List<Integer> folds = Collections.emptyList();
    private List<Point3d> originalCenters = new ArrayList<Point3d>();
    private List<Point3d> centers = new ArrayList<Point3d>();
    private List<Vector3d> unitVectors = new ArrayList<Vector3d>();
    private int nucleicAcidChainCount = 0;
    private boolean pseudoSymmetric = false;
    private Point3d centroid;
    private MomentsOfInertia momentsOfInertia = new MomentsOfInertia();

    public Subunits(List<Point3d[]> caCoords, List<Integer> sequenceClusterIds, List<Boolean> pseudoStoichiometry, List<Double> minSequenceIdentity, List<Double> maxSequenceIdentity, List<Integer> folds, List<String> chainIds, List<Integer> modelNumbers) {
        this.caCoords = caCoords;
        this.sequenceClusterIds = sequenceClusterIds;
        this.pseudoStoichiometry = pseudoStoichiometry;
        this.minSequenceIdentity = minSequenceIdentity;
        this.maxSequenceIdentity = maxSequenceIdentity;
        this.folds = folds;
        this.chainIds = chainIds;
        this.modelNumbers = modelNumbers;
    }

    public List<Point3d[]> getTraces() {
        return this.caCoords;
    }

    public int getSubunitCount() {
        this.run();
        if (this.centers == null) {
            return 0;
        }
        return this.centers.size();
    }

    public List<Integer> getSequenceClusterIds() {
        return this.sequenceClusterIds;
    }

    public boolean isPseudoStoichiometric() {
        for (Boolean b : this.pseudoStoichiometry) {
            if (!b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isPseudoSymmetric() {
        return this.pseudoSymmetric;
    }

    public void setPseudoSymmetric(boolean pseudoSymmetric) {
        this.pseudoSymmetric = pseudoSymmetric;
    }

    public double getMinSequenceIdentity() {
        double minId = 1.0;
        for (double seqId : this.minSequenceIdentity) {
            minId = Math.min(seqId, minId);
        }
        return minId;
    }

    public double getMaxSequenceIdentity() {
        double maxId = 1.0;
        for (double seqId : this.maxSequenceIdentity) {
            maxId = Math.min(seqId, maxId);
        }
        return maxId;
    }

    public List<String> getChainIds() {
        return this.chainIds;
    }

    public List<Integer> getModelNumbers() {
        return this.modelNumbers;
    }

    public List<Integer> getFolds() {
        return this.folds;
    }

    public String getStoichiometry() {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        for (Integer id : this.sequenceClusterIds) {
            Integer value = (Integer)map.get(id);
            if (value == null) {
                value = new Integer(1);
            } else {
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
            }
            map.put(id, value);
        }
        String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder formula = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            String key = "?";
            int id = (Integer)entry.getKey();
            if (id < alpha.length()) {
                key = alpha.substring(id, id + 1);
            }
            formula.append(key);
            if ((Integer)entry.getValue() <= 1) continue;
            formula.append(entry.getValue());
        }
        return formula.toString();
    }

    public int getCalphaCount() {
        int count = 0;
        for (Point3d[] trace : this.caCoords) {
            count += trace.length;
        }
        return count;
    }

    public int getLargestSubunit() {
        int index = -1;
        int maxLength = 0;
        for (int i = 0; i < this.caCoords.size(); ++i) {
            int length = this.caCoords.get(i).length;
            if (length <= maxLength) continue;
            index = i;
        }
        return index;
    }

    public List<Point3d> getCenters() {
        this.run();
        return this.centers;
    }

    public List<Vector3d> getUnitVectors() {
        this.run();
        return this.unitVectors;
    }

    public List<Point3d> getOriginalCenters() {
        this.run();
        return this.originalCenters;
    }

    public Point3d getCentroid() {
        this.run();
        return this.centroid;
    }

    public MomentsOfInertia getMomentsOfInertia() {
        this.run();
        return this.momentsOfInertia;
    }

    public int getNucleicAcidChainCount() {
        this.run();
        return this.nucleicAcidChainCount;
    }

    public void setNucleicAcidChainCount(int nucleicAcidChainCount) {
        this.nucleicAcidChainCount = nucleicAcidChainCount;
    }

    public boolean overlaps(Subunits subunits) {
        Set<String> set1 = Subunits.getSignatures(this);
        Set<String> set2 = Subunits.getSignatures(subunits);
        set1.retainAll(set2);
        return set1.size() > 0;
    }

    public boolean contains(Subunits subunits) {
        Set<String> set1 = Subunits.getSignatures(this);
        Set<String> set2 = Subunits.getSignatures(subunits);
        return set1.containsAll(set2);
    }

    private static Set<String> getSignatures(Subunits subunits) {
        HashSet<String> set = new HashSet<String>(subunits.getSubunitCount());
        for (int i = 0; i < subunits.getSubunitCount(); ++i) {
            set.add(subunits.getChainIds().get(i) + "_" + subunits.getModelNumbers().get(i));
        }
        return set;
    }

    private void run() {
        if (this.centers.size() > 0) {
            return;
        }
        this.calcOriginalCenters();
        this.calcCentroid();
        this.calcCenters();
        this.calcMomentsOfIntertia();
    }

    private void calcOriginalCenters() {
        for (Point3d[] trace : this.caCoords) {
            Point3d com = SuperPosition.centroid(trace);
            this.originalCenters.add(com);
        }
    }

    private void calcCentroid() {
        Point3d[] orig = this.originalCenters.toArray(new Point3d[this.originalCenters.size()]);
        this.centroid = SuperPosition.centroid(orig);
    }

    private void calcCenters() {
        for (Point3d p : this.originalCenters) {
            Point3d c = new Point3d(p);
            c.sub((Tuple3d)this.centroid);
            this.centers.add(c);
            Vector3d v = new Vector3d((Tuple3d)c);
            v.normalize();
            this.unitVectors.add(v);
        }
    }

    public Point3d getLowerBound() {
        Point3d lower = new Point3d();
        for (Point3d p : this.centers) {
            if (p.x < lower.x) {
                lower.x = p.x;
            }
            if (p.y < lower.y) {
                lower.y = p.y;
            }
            if (!(p.z < lower.z)) continue;
            lower.z = p.z;
        }
        return lower;
    }

    public Point3d getUpperBound() {
        Point3d upper = new Point3d();
        for (Point3d p : this.centers) {
            if (p.x > upper.x) {
                upper.x = p.x;
            }
            if (p.y > upper.y) {
                upper.y = p.y;
            }
            if (!(p.z > upper.z)) continue;
            upper.z = p.z;
        }
        return upper;
    }

    private void calcMomentsOfIntertia() {
        for (Point3d[] trace : this.caCoords) {
            for (Point3d p : trace) {
                this.momentsOfInertia.addPoint(p, 1.0);
            }
        }
    }
}

