/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biojava.nbio.structure.symmetry.utils.Graph;
import org.biojava.nbio.structure.symmetry.utils.SimpleGraph;

public class ComponentFinder<V> {
    private Graph<V> graph;
    private boolean[] encounter = new boolean[128];
    private List<List<V>> components;

    public void setGraph(Graph<V> graph) {
        this.graph = graph;
        this.ensureCapacity();
        this.clearComponents();
        this.findComponents();
    }

    public List<V> getComponent(int index) {
        return this.components.get(index);
    }

    public List<List<V>> getComponents() {
        return this.components;
    }

    public List<V> getLargestComponent() {
        if (this.components.size() == 0) {
            this.components.add(new ArrayList(0));
        }
        int largest = 0;
        int index = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            int size = this.components.get(i).size();
            if (size <= largest) continue;
            largest = size;
            index = i;
        }
        return this.components.get(index);
    }

    public int getComponentCount() {
        if (this.components == null) {
            return 0;
        }
        return this.components.size();
    }

    private void findComponents() {
        Arrays.fill(this.encounter, 0, this.graph.size(), false);
        for (int i = 0; i < this.graph.size(); ++i) {
            if (this.encounter[i]) continue;
            ArrayList<V> fragment = new ArrayList<V>();
            this.components.add(fragment);
            fragment.add(this.graph.getVertex(i));
            this.encounter[i] = true;
            this.traverse(i, fragment);
        }
    }

    private void traverse(int start, List<V> fragment) {
        List<Integer> neighbors = this.graph.getNeighborIndices(start);
        if (neighbors.size() == 0) {
            return;
        }
        for (int neighbor : neighbors) {
            if (this.encounter[neighbor]) continue;
            fragment.add(this.graph.getVertex(neighbor));
            this.encounter[neighbor] = true;
            this.traverse(neighbor, fragment);
        }
    }

    private void clearComponents() {
        this.components = null;
        this.components = new ArrayList<List<V>>();
        Arrays.fill(this.encounter, false);
    }

    private void ensureCapacity() {
        if (this.encounter.length < this.graph.size()) {
            this.encounter = null;
            this.encounter = new boolean[this.graph.size()];
        }
    }

    public static void main(String[] args) {
        String va = "A";
        String vb = "B";
        String vc = "C";
        String vd = "D";
        String ve = "E";
        SimpleGraph<String> g1 = new SimpleGraph<String>();
        g1.addVertex(va);
        g1.addVertex(vb);
        g1.addVertex(vc);
        g1.addVertex(vd);
        g1.addVertex(ve);
        g1.addEdge(va, vb);
        g1.addEdge(vb, vc);
        g1.addEdge(vc, vd);
        g1.addEdge(vd, vb);
        g1.addEdge(vc, ve);
        System.out.println(g1);
    }
}

