/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.structure.symmetry.utils.Edge;
import org.biojava.nbio.structure.symmetry.utils.Graph;

public class SimpleGraph<V>
implements Graph<V>,
Cloneable {
    private List<V> vertices = new ArrayList<V>();
    private List<ArrayList<Integer>> vertexMap = new ArrayList<ArrayList<Integer>>();

    @Override
    public boolean addEdge(V vertex1, V vertex2) {
        int index1 = this.vertices.indexOf(vertex1);
        int index2 = this.vertices.indexOf(vertex2);
        if (index1 == -1 || index2 == -1) {
            return false;
        }
        this.vertexMap.get(index1).add(index2);
        this.vertexMap.get(index2).add(index1);
        return true;
    }

    @Override
    public boolean addEdge(Edge<V> edge) {
        return this.addEdge(edge.getVertex1(), edge.getVertex2());
    }

    @Override
    public int size() {
        return this.vertices.size();
    }

    @Override
    public int getEdgeCount() {
        int edgeCount = 0;
        for (int i = 0; i < this.size(); ++i) {
            edgeCount += this.getValence(i);
        }
        return edgeCount / 2;
    }

    @Override
    public int getValence(V vertex) {
        return this.getValence(this.indexOf(vertex));
    }

    @Override
    public int getValence(int index) {
        if (index != -1) {
            return this.vertexMap.get(index).size();
        }
        return 0;
    }

    @Override
    public boolean addVertex(V vertex) {
        if (this.vertices == null) {
            this.vertices = new ArrayList<V>();
        }
        if (this.containsVertex(vertex)) {
            return false;
        }
        this.vertices.add(vertex);
        if (this.vertexMap == null) {
            this.vertexMap = new ArrayList<ArrayList<Integer>>();
        }
        this.vertexMap.add(new ArrayList());
        return true;
    }

    @Override
    public boolean containsVertex(V vertex) {
        return this.vertices.contains(vertex);
    }

    @Override
    public void setVertices(List<V> list) {
        this.vertices = list;
        this.vertexMap = new ArrayList<ArrayList<Integer>>(this.vertices.size());
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertexMap.add(new ArrayList());
        }
    }

    @Override
    public List<V> getVertices() {
        return this.vertices;
    }

    @Override
    public List<Edge<V>> getEdges() {
        ArrayList<Edge<V>> edges = new ArrayList<Edge<V>>();
        for (int index1 = 0; index1 < this.size(); ++index1) {
            for (int index2 : this.getNeighborIndices(index1)) {
                if (index1 >= index2) continue;
                Edge<V> e = new Edge<V>(this.vertices.get(index1), this.vertices.get(index2));
                edges.add(e);
            }
        }
        return edges;
    }

    @Override
    public V getVertex(int index) {
        return this.vertices.get(index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.vertices.size(); ++i) {
            sb.append(this.vertices.get(i));
            sb.append(" [");
            List neighbors = this.vertexMap.get(i);
            if (neighbors != null) {
                for (int j = 0; j < neighbors.size(); ++j) {
                    sb.append(this.vertices.get((Integer)neighbors.get(j)));
                    if (j >= neighbors.size() - 1) continue;
                    sb.append(",");
                }
            }
            sb.append("]; ");
        }
        return sb.toString();
    }

    @Override
    public int indexOf(V vertex) {
        return this.vertices.indexOf(vertex);
    }

    @Override
    public List<Integer> getNeighborIndices(int index) {
        return this.vertexMap.get(index);
    }

    @Override
    public boolean removeEdge(int index1, int index2) {
        if (index1 < 0 || index2 < 0) {
            return false;
        }
        List<Integer> neighbors = this.getNeighborIndices(index1);
        int index = neighbors.indexOf(index2);
        if (index < 0) {
            return false;
        }
        neighbors.remove(neighbors.indexOf(index2));
        neighbors = this.getNeighborIndices(index2);
        index = neighbors.indexOf(index1);
        if (index < 0) {
            return false;
        }
        neighbors.remove(neighbors.indexOf(index1));
        return true;
    }

    @Override
    public boolean removeEdge(V vertex1, V vertex2) {
        return this.removeEdge(this.indexOf(vertex1), this.indexOf(vertex2));
    }

    @Override
    public Object clone() {
        SimpleGraph<V> graph = new SimpleGraph<V>();
        for (int i = 0; i < this.vertices.size(); ++i) {
            V vertex = this.vertices.get(i);
            graph.addVertex(vertex);
            List neighbors = this.vertexMap.get(i);
            if (neighbors.size() <= 0) continue;
            Iterator i$ = neighbors.iterator();
            while (i$.hasNext()) {
                int n = (Integer)i$.next();
                graph.addEdge(vertex, this.vertices.get(n));
            }
        }
        return graph;
    }

    @Override
    public boolean containsEdge(int index1, int index2) {
        if (index1 < 0 || index2 < 0) {
            return false;
        }
        List<Integer> neighbors = this.getNeighborIndices(index1);
        int index = neighbors.indexOf(index2);
        return index >= 0;
    }

    @Override
    public SimpleGraph<V> extractSubGraph(List<Integer> indices) {
        SimpleGraph<V> graph = new SimpleGraph<V>();
        for (int index : indices) {
            V vertex = this.vertices.get(index);
            graph.addVertex(vertex);
            List<Integer> neighbors = this.getNeighborIndices(index);
            for (int n : neighbors) {
                if (!indices.contains(n)) continue;
                graph.addEdge(vertex, this.vertices.get(n));
            }
        }
        return graph;
    }
}

