/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;

public class Bond
implements Serializable {
    private static final long serialVersionUID = 8836120946858134380L;
    private Atom atomA;
    private Atom atomB;
    private int bondOrder;

    public Bond(Atom atomA, Atom atomB, int bondOrder) {
        this(atomA, atomB, bondOrder, true);
    }

    public Bond(Atom atomA, Atom atomB, int bondOrder, boolean addSelfToAtoms) {
        this.atomA = atomA;
        this.atomB = atomB;
        this.bondOrder = bondOrder;
        if (addSelfToAtoms) {
            this.addSelfToAtoms();
        }
    }

    public void addSelfToAtoms() {
        this.atomA.addBond(this);
        this.atomB.addBond(this);
    }

    public Atom getAtomA() {
        return this.atomA;
    }

    public Atom getAtomB() {
        return this.atomB;
    }

    public Atom getOther(Atom exclude) {
        if (exclude != this.atomA && exclude != this.atomB) {
            throw new IllegalArgumentException("Atom to exclude is not in bond.");
        }
        if (exclude == this.atomA) {
            return this.atomB;
        }
        return this.atomA;
    }

    public int getBondOrder() {
        return this.bondOrder;
    }

    public double getLength() {
        return Calc.getDistance(this.atomA, this.atomB);
    }

    public String toString() {
        return "Bond [atomA=" + this.atomA + ", atomB=" + this.atomB + ", bondOrder=" + this.bondOrder + "]";
    }
}

