/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Compound;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.io.FileConvert;
import org.biojava.nbio.structure.io.SeqRes2AtomAligner;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.mmcif.chem.PolymerType;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainImpl
implements Chain,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ChainImpl.class);
    private static final long serialVersionUID = 1990171805277911840L;
    public static String DEFAULT_CHAIN_ID = "A";
    private String swissprot_id;
    private String chainID = DEFAULT_CHAIN_ID;
    private List<Group> groups = new ArrayList<Group>();
    private List<Group> seqResGroups = new ArrayList<Group>();
    private Long id;
    private Compound mol;
    private Structure parent;
    private Map<String, Integer> pdbResnumMap = new HashMap<String, Integer>();
    private String internalChainID = null;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setParent(Structure parent) {
        this.parent = parent;
    }

    @Override
    public Structure getParent() {
        return this.parent;
    }

    @Override
    public Object clone() {
        ChainImpl n = new ChainImpl();
        n.setChainID(this.getChainID());
        n.setSwissprotId(this.getSwissprotId());
        n.setCompound(this.mol);
        n.setInternalChainID(this.internalChainID);
        for (Group group : this.groups) {
            Group g = (Group)group.clone();
            n.addGroup(g);
            g.setChain(n);
        }
        if (!this.seqResGroups.isEmpty()) {
            ArrayList<Group> tmpSeqRes = new ArrayList<Group>();
            for (Group seqResGroup : this.seqResGroups) {
                Group g = (Group)seqResGroup.clone();
                g.setChain(n);
                tmpSeqRes.add(g);
            }
            ChainImpl tmp = new ChainImpl();
            tmp.setAtomGroups(tmpSeqRes);
            SeqRes2AtomAligner seqresaligner = new SeqRes2AtomAligner();
            seqresaligner.mapSeqresRecords(n, tmp);
        }
        return n;
    }

    @Override
    public void setCompound(Compound mol) {
        this.mol = mol;
    }

    @Override
    public Compound getCompound() {
        return this.mol;
    }

    @Override
    public void setSwissprotId(String sp_id) {
        this.swissprot_id = sp_id;
    }

    @Override
    public String getSwissprotId() {
        return this.swissprot_id;
    }

    @Override
    public void addGroup(Group group) {
        group.setChain(this);
        this.groups.add(group);
        String pdbResnum = null;
        ResidueNumber resNum = group.getResidueNumber();
        if (resNum != null) {
            pdbResnum = resNum.toString();
        }
        if (pdbResnum != null) {
            Integer pos = this.groups.size() - 1;
            if (this.pdbResnumMap.containsKey(pdbResnum)) {
                if (group instanceof AminoAcid) {
                    this.pdbResnumMap.put(pdbResnum, pos);
                }
            } else {
                this.pdbResnumMap.put(pdbResnum, pos);
            }
        }
    }

    @Override
    public Group getAtomGroup(int position) {
        return this.groups.get(position);
    }

    @Override
    public List<Group> getAtomGroups(GroupType type) {
        ArrayList<Group> tmp = new ArrayList<Group>();
        for (Group g : this.groups) {
            if (!g.getType().equals((Object)type)) continue;
            tmp.add(g);
        }
        return tmp;
    }

    @Override
    public List<Group> getAtomGroups() {
        return this.groups;
    }

    @Override
    public void setAtomGroups(List<Group> groups) {
        for (Group g : groups) {
            g.setChain(this);
        }
        this.groups = groups;
    }

    @Override
    @Deprecated
    public Group[] getGroupsByPDB(ResidueNumber start, ResidueNumber end, boolean ignoreMissing) throws StructureException {
        if (!ignoreMissing) {
            return this.getGroupsByPDB(start, end);
        }
        ArrayList<Group> retlst = new ArrayList<Group>();
        String pdbresnumStart = start.toString();
        String pdbresnumEnd = end.toString();
        int startPos = Integer.MIN_VALUE;
        int endPos = Integer.MAX_VALUE;
        startPos = start.getSeqNum();
        endPos = end.getSeqNum();
        boolean adding = false;
        boolean foundStart = false;
        for (Group g : this.groups) {
            int pos;
            if (g.getResidueNumber().toString().equals(pdbresnumStart)) {
                adding = true;
                foundStart = true;
            }
            if (!(foundStart && adding || (pos = g.getResidueNumber().getSeqNum().intValue()) < startPos)) {
                foundStart = true;
                adding = true;
            }
            if (adding) {
                retlst.add(g);
            }
            if (g.getResidueNumber().toString().equals(pdbresnumEnd)) {
                if (!adding) {
                    throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.chainID);
                }
                adding = false;
                break;
            }
            if (!adding || (pos = g.getResidueNumber().getSeqNum().intValue()) < endPos) continue;
            adding = false;
            break;
        }
        if (!foundStart) {
            throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.chainID);
        }
        return retlst.toArray(new Group[retlst.size()]);
    }

    @Override
    public Group getGroupByPDB(ResidueNumber resNum) throws StructureException {
        String pdbresnum = resNum.toString();
        if (this.pdbResnumMap.containsKey(pdbresnum)) {
            Integer pos = this.pdbResnumMap.get(pdbresnum);
            return this.groups.get(pos);
        }
        throw new StructureException("unknown PDB residue number " + pdbresnum + " in chain " + this.chainID);
    }

    @Override
    public Group[] getGroupsByPDB(ResidueNumber start, ResidueNumber end) throws StructureException {
        String pdbresnumStart = start.toString();
        String pdbresnumEnd = end.toString();
        ArrayList<Group> retlst = new ArrayList<Group>();
        Iterator<Group> iter = this.groups.iterator();
        boolean adding = false;
        boolean foundStart = false;
        while (iter.hasNext()) {
            Group g = iter.next();
            if (g.getResidueNumber().toString().equals(pdbresnumStart)) {
                adding = true;
                foundStart = true;
            }
            if (adding) {
                retlst.add(g);
            }
            if (!g.getResidueNumber().toString().equals(pdbresnumEnd)) continue;
            if (!adding) {
                throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.chainID);
            }
            adding = false;
            break;
        }
        if (!foundStart) {
            throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.chainID);
        }
        if (adding) {
            throw new StructureException("did not find end PDB residue number " + pdbresnumEnd + " in chain " + this.chainID);
        }
        return retlst.toArray(new Group[retlst.size()]);
    }

    @Override
    public int getSeqResLength() {
        return this.seqResGroups.size();
    }

    @Override
    public void setChainID(String nam) {
        this.chainID = nam;
    }

    @Override
    public String getChainID() {
        return this.chainID;
    }

    @Override
    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuilder str = new StringBuilder();
        str.append("Chain >").append(this.getChainID()).append("<").append(newline);
        if (this.mol != null && this.mol.getMolName() != null) {
            str.append(this.mol.getMolName()).append(newline);
        }
        str.append("total SEQRES length: ").append(this.getSeqResGroups().size()).append(" total ATOM length:").append(this.getAtomLength()).append(" residues ").append(newline);
        return str.toString();
    }

    @Override
    public Sequence<?> getBJSequence() {
        String seq = this.getSeqResSequence();
        ProteinSequence s = null;
        try {
            s = new ProteinSequence(seq);
        }
        catch (CompoundNotFoundException e) {
            logger.error("Could not create sequence object from seqres sequence. Some unknown compound: {}", (Object)e.getMessage());
        }
        return s;
    }

    @Override
    public String getAtomSequence() {
        String prop = System.getProperty("loadChemCompInfo");
        if (prop != null && prop.equalsIgnoreCase("true")) {
            List<Group> groups = this.getAtomGroups();
            StringBuilder sequence = new StringBuilder();
            for (Group g : groups) {
                ChemComp cc = g.getChemComp();
                if (!PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType()) && !PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType())) continue;
                String oneLetter = ChemCompGroupFactory.getOneLetterCode(cc);
                if (oneLetter == null) {
                    oneLetter = "X";
                }
                sequence.append(oneLetter);
            }
            return sequence.toString();
        }
        List<Group> aminos = this.getAtomGroups(GroupType.AMINOACID);
        StringBuilder sequence = new StringBuilder();
        for (Group amino : aminos) {
            AminoAcid a = (AminoAcid)amino;
            sequence.append(a.getAminoType());
        }
        return sequence.toString();
    }

    @Override
    public String getSeqResSequence() {
        String prop = System.getProperty("loadChemCompInfo");
        if (prop != null && prop.equalsIgnoreCase("true")) {
            StringBuilder str = new StringBuilder();
            for (Group g : this.seqResGroups) {
                ChemComp cc = g.getChemComp();
                if (cc == null) {
                    logger.warn("Could not load ChemComp for group: ", (Object)g);
                    str.append("X");
                    continue;
                }
                if (PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType()) || PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType())) {
                    String oneLetter = ChemCompGroupFactory.getOneLetterCode(cc);
                    if (oneLetter == null || oneLetter.isEmpty() || oneLetter.equals("?")) {
                        oneLetter = "X";
                    }
                    str.append(oneLetter);
                    continue;
                }
                str.append("X");
            }
            return str.toString();
        }
        StringBuilder str = new StringBuilder();
        for (Group group : this.seqResGroups) {
            if (group instanceof AminoAcid) {
                AminoAcid aa = (AminoAcid)group;
                str.append(aa.getAminoType());
                continue;
            }
            str.append("X");
        }
        return str.toString();
    }

    @Override
    public Group getSeqResGroup(int position) {
        return this.seqResGroups.get(position);
    }

    @Override
    public List<Group> getSeqResGroups(GroupType type) {
        ArrayList<Group> tmp = new ArrayList<Group>();
        for (Group g : this.seqResGroups) {
            if (!g.getType().equals((Object)type)) continue;
            tmp.add(g);
        }
        return tmp;
    }

    @Override
    public List<Group> getSeqResGroups() {
        return this.seqResGroups;
    }

    @Override
    public void setSeqResGroups(List<Group> groups) {
        for (Group g : groups) {
            g.setChain(this);
        }
        this.seqResGroups = groups;
    }

    protected void addSeqResGroup(Group g) {
        this.seqResGroups.add(g);
    }

    @Override
    public int getAtomLength() {
        return this.groups.size();
    }

    @Override
    public List<Group> getAtomLigands() {
        ArrayList<Group> ligands = new ArrayList<Group>();
        for (Group g : this.groups) {
            if (this.seqResGroups.contains(g) || g.isWater()) continue;
            ligands.add(g);
        }
        return ligands;
    }

    @Override
    public String getInternalChainID() {
        return this.internalChainID;
    }

    @Override
    public void setInternalChainID(String internalChainID) {
        this.internalChainID = internalChainID;
    }

    @Override
    public String toPDB() {
        return FileConvert.toPDB(this);
    }

    @Override
    public String toMMCIF() {
        return FileConvert.toMMCIF(this, true);
    }
}

