/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compound
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Compound.class);
    private static final long serialVersionUID = 2991897825657586356L;
    private List<Chain> chains = new ArrayList<Chain>();
    private int molId;
    private Map<String, Map<ResidueNumber, Integer>> chains2pdbResNums2ResSerials = new HashMap<String, Map<ResidueNumber, Integer>>();
    private String refChainId;
    private String molName = null;
    private String title = null;
    private List<String> synonyms = null;
    private List<String> ecNums = null;
    private String engineered = null;
    private String mutation = null;
    private String biologicalUnit = null;
    private String details = null;
    private String numRes = null;
    private String resNames = null;
    private String headerVars = null;
    private String synthetic = null;
    private String fragment = null;
    private String organismScientific = null;
    private String organismTaxId = null;
    private String organismCommon = null;
    private String strain = null;
    private String variant = null;
    private String cellLine = null;
    private String atcc = null;
    private String organ = null;
    private String tissue = null;
    private String cell = null;
    private String organelle = null;
    private String secretion = null;
    private String gene = null;
    private String cellularLocation = null;
    private String expressionSystem = null;
    private String expressionSystemTaxId = null;
    private String expressionSystemStrain = null;
    private String expressionSystemVariant = null;
    private String expressionSystemCellLine = null;
    private String expressionSystemAtccNumber = null;
    private String expressionSystemOrgan = null;
    private String expressionSystemTissue = null;
    private String expressionSystemCell = null;
    private String expressionSystemOrganelle = null;
    private String expressionSystemCellularLocation = null;
    private String expressionSystemVectorType = null;
    private String expressionSystemVector = null;
    private String expressionSystemPlasmid = null;
    private String expressionSystemGene = null;
    private String expressionSystemOtherDetails = null;
    private Long id;

    public Compound() {
        this.molId = -1;
    }

    public Compound(Compound c) {
        this.molId = c.molId;
        this.refChainId = c.refChainId;
        this.molName = c.molName;
        this.title = c.title;
        if (c.synonyms != null) {
            this.synonyms = new ArrayList<String>();
            this.synonyms.addAll(c.synonyms);
        }
        if (c.ecNums != null) {
            this.ecNums = new ArrayList<String>();
            this.ecNums.addAll(c.ecNums);
        }
        this.engineered = c.engineered;
        this.mutation = c.mutation;
        this.biologicalUnit = c.biologicalUnit;
        this.details = c.details;
        this.numRes = c.numRes;
        this.resNames = c.resNames;
        this.headerVars = c.headerVars;
        this.synthetic = c.synthetic;
        this.fragment = c.fragment;
        this.organismScientific = c.organismScientific;
        this.organismTaxId = c.organismTaxId;
        this.organismCommon = c.organismCommon;
        this.strain = c.strain;
        this.variant = c.variant;
        this.cellLine = c.cellLine;
        this.atcc = c.atcc;
        this.organ = c.organ;
        this.tissue = c.tissue;
        this.cell = c.cell;
        this.organelle = c.organelle;
        this.secretion = c.secretion;
        this.gene = c.gene;
        this.cellularLocation = c.cellularLocation;
        this.expressionSystem = c.expressionSystem;
        this.expressionSystemTaxId = c.expressionSystemTaxId;
        this.expressionSystemStrain = c.expressionSystemStrain;
        this.expressionSystemVariant = c.expressionSystemVariant;
        this.expressionSystemCellLine = c.expressionSystemCellLine;
        this.expressionSystemAtccNumber = c.expressionSystemAtccNumber;
        this.expressionSystemOrgan = c.expressionSystemOrgan;
        this.expressionSystemTissue = c.expressionSystemTissue;
        this.expressionSystemCell = c.expressionSystemCell;
        this.expressionSystemOrganelle = c.expressionSystemOrganelle;
        this.expressionSystemCellularLocation = c.expressionSystemCellularLocation;
        this.expressionSystemVectorType = c.expressionSystemVectorType;
        this.expressionSystemVector = c.expressionSystemVector;
        this.expressionSystemPlasmid = c.expressionSystemPlasmid;
        this.expressionSystemGene = c.expressionSystemGene;
        this.expressionSystemOtherDetails = c.expressionSystemOtherDetails;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Compound: ").append(this.molId).append(" ");
        buf.append(this.molName == null ? "(no name)" : "(" + this.molName + ")");
        buf.append(" chains: ");
        if (this.chains != null) {
            for (int i = 0; i < this.chains.size(); ++i) {
                buf.append(this.chains.get(i).getChainID());
                if (i == this.chains.size() - 1) continue;
                buf.append(",");
            }
        } else {
            buf.append("no chains");
        }
        return buf.toString();
    }

    public Chain getRepresentative() {
        ArrayList<String> chainIds = new ArrayList<String>();
        for (Chain chain : this.chains) {
            chainIds.add(chain.getChainID());
        }
        Collections.sort(chainIds, String.CASE_INSENSITIVE_ORDER);
        for (Chain chain : this.chains) {
            if (!chain.getChainID().equals(chainIds.get(0))) continue;
            return chain;
        }
        logger.error("Could not find a representative chain for compound '{}'", (Object)this.toString());
        return null;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void showHeader() {
        this.showCompound();
        this.showSource();
    }

    public void showCompound() {
        System.out.println("COMPOUND INFO:");
        if (this.molId != -1) {
            System.out.println("Mol ID: " + this.molId);
        }
        if (this.chains != null) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.chains.size(); ++i) {
                buf.append(this.chains.get(i).getChainID());
                if (i == this.chains.size() - 1) continue;
                buf.append(",");
            }
            System.out.println("Chains: " + buf.toString());
        }
        if (this.molName != null) {
            System.out.println("Mol Name: " + this.molName);
        }
        if (this.title != null) {
            System.out.println("Title: " + this.title);
        }
        if (this.synonyms != null) {
            for (String x : this.synonyms) {
                System.out.println("Synomym: " + x);
            }
        }
        if (this.ecNums != null) {
            for (String x : this.ecNums) {
                System.out.println("EC: " + x);
            }
        }
        if (this.fragment != null) {
            System.out.println("Fragment? " + this.fragment);
        }
        if (this.engineered != null) {
            System.out.println("Engineered? " + this.engineered);
        }
        if (this.mutation != null) {
            System.out.println("Mutation? " + this.mutation);
        }
        if (this.biologicalUnit != null) {
            System.out.println("Biological Unit: " + this.biologicalUnit);
        }
        if (this.details != null) {
            System.out.println("Details: " + this.details);
        }
        if (this.numRes != null) {
            System.out.println("No. Residues: " + this.numRes);
        }
    }

    public void showSource() {
        System.out.println("SOURCE INFO:");
        if (this.synthetic != null) {
            System.out.println("Synthetic? " + this.synthetic);
        }
        if (this.fragment != null) {
            System.out.println("Fragment? " + this.fragment);
        }
        if (this.organismScientific != null) {
            System.out.println("Organism Scientific: " + this.organismScientific);
        }
        if (this.organismTaxId != null) {
            System.out.println("Organism Tax Id: " + this.organismTaxId);
        }
        if (this.organismCommon != null) {
            System.out.println("Organism Common: " + this.organismCommon);
        }
        if (this.strain != null) {
            System.out.println("Strain: " + this.strain);
        }
        if (this.variant != null) {
            System.out.println("Variant: " + this.variant);
        }
        if (this.cellLine != null) {
            System.out.println("Cell Line: " + this.cellLine);
        }
        if (this.atcc != null) {
            System.out.println("ATCC: " + this.atcc);
        }
        if (this.organ != null) {
            System.out.println("Organ: " + this.organ);
        }
        if (this.tissue != null) {
            System.out.println("Tissue: " + this.tissue);
        }
        if (this.cell != null) {
            System.out.println("Cell: " + this.cell);
        }
        if (this.organelle != null) {
            System.out.println("Organelle: " + this.organelle);
        }
        if (this.secretion != null) {
            System.out.println("Secretion: " + this.secretion);
        }
        if (this.gene != null) {
            System.out.println("Gene: " + this.gene);
        }
        if (this.cellularLocation != null) {
            System.out.println("Cellular Location: " + this.cellularLocation);
        }
        if (this.expressionSystem != null) {
            System.out.println("Expression System: " + this.expressionSystem);
        }
        if (this.expressionSystemTaxId != null) {
            System.out.println("Expression System Tax Id: " + this.expressionSystemTaxId);
        }
        if (this.expressionSystemStrain != null) {
            System.out.println("Expression System Strain: " + this.expressionSystemStrain);
        }
        if (this.expressionSystemVariant != null) {
            System.out.println("Expression System Variant: " + this.expressionSystemVariant);
        }
        if (this.expressionSystemCellLine != null) {
            System.out.println("Expression System Cell Line: " + this.expressionSystemCellLine);
        }
        if (this.expressionSystemAtccNumber != null) {
            System.out.println("Expression System ATCC Number: " + this.expressionSystemAtccNumber);
        }
        if (this.expressionSystemOrgan != null) {
            System.out.println("Expression System Organ: " + this.expressionSystemOrgan);
        }
        if (this.expressionSystemTissue != null) {
            System.out.println("Expression System Tissue: " + this.expressionSystemTissue);
        }
        if (this.expressionSystemCell != null) {
            System.out.println("Expression System Cell: " + this.expressionSystemCell);
        }
        if (this.expressionSystemOrganelle != null) {
            System.out.println("Expression System Organelle: " + this.expressionSystemOrganelle);
        }
        if (this.expressionSystemCellularLocation != null) {
            System.out.println("Expression System Cellular Location: " + this.expressionSystemCellularLocation);
        }
        if (this.expressionSystemVectorType != null) {
            System.out.println("Expression System Vector Type: " + this.expressionSystemVectorType);
        }
        if (this.expressionSystemVector != null) {
            System.out.println("Expression System Vector: " + this.expressionSystemVector);
        }
        if (this.expressionSystemPlasmid != null) {
            System.out.println("Expression System Plasmid: " + this.expressionSystemPlasmid);
        }
        if (this.expressionSystemGene != null) {
            System.out.println("Expression System Gene: " + this.expressionSystemGene);
        }
        if (this.expressionSystemOtherDetails != null) {
            System.out.println("Expression System Other Details: " + this.expressionSystemOtherDetails);
        }
    }

    public List<String> getChainIds() {
        TreeSet<String> uniqChainIds = new TreeSet<String>();
        for (int i = 0; i < this.getChains().size(); ++i) {
            uniqChainIds.add(this.getChains().get(i).getChainID());
        }
        return new ArrayList<String>(uniqChainIds);
    }

    public int getAlignedResIndex(Group g, Chain c) {
        Integer alignedSerial;
        Map<ResidueNumber, Integer> map;
        boolean contained = false;
        for (Chain member : this.getChains()) {
            if (!c.getChainID().equals(member.getChainID())) continue;
            contained = true;
            break;
        }
        if (!contained) {
            throw new IllegalArgumentException("Given chain " + c.getChainID() + " is not a member of this Compound (entity): " + this.getChainIds().toString());
        }
        if (!this.chains2pdbResNums2ResSerials.containsKey(c.getChainID())) {
            this.initResSerialsMap(c);
        }
        int serial = (map = this.chains2pdbResNums2ResSerials.get(c.getChainID())) != null ? ((alignedSerial = map.get(g.getResidueNumber())) == null ? -1 : alignedSerial) : g.getResidueNumber().getSeqNum();
        return serial;
    }

    private void initResSerialsMap(Chain c) {
        if (c.getSeqResGroups() == null || c.getSeqResGroups().isEmpty()) {
            logger.warn("No SEQRES groups found in chain {}, will use residue numbers as given (no insertion codes, not necessarily aligned). Make sure your structure has SEQRES records and that you use FileParsingParameters.setAlignSeqRes(true)", (Object)c.getChainID());
            return;
        }
        HashMap<ResidueNumber, Integer> resNums2ResSerials = new HashMap<ResidueNumber, Integer>();
        this.chains2pdbResNums2ResSerials.put(c.getChainID(), resNums2ResSerials);
        for (int i = 0; i < c.getSeqResGroups().size(); ++i) {
            resNums2ResSerials.put(c.getSeqResGroup(i).getResidueNumber(), i + 1);
        }
    }

    public String getRefChainId() {
        return this.refChainId;
    }

    public void setRefChainId(String refChainId) {
        this.refChainId = refChainId;
    }

    public int getMolId() {
        return this.molId;
    }

    public void setMolId(int molId) {
        this.molId = molId;
    }

    public String getMolName() {
        return this.molName;
    }

    public void setMolName(String molName) {
        this.molName = molName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(List<String> synonyms) {
        this.synonyms = synonyms;
    }

    public List<String> getEcNums() {
        return this.ecNums;
    }

    public void setEcNums(List<String> ecNums) {
        this.ecNums = ecNums;
    }

    public String getEngineered() {
        return this.engineered;
    }

    public void setEngineered(String engineered) {
        this.engineered = engineered;
    }

    public String getMutation() {
        return this.mutation;
    }

    public void setMutation(String mutation) {
        this.mutation = mutation;
    }

    public String getBiologicalUnit() {
        return this.biologicalUnit;
    }

    public void setBiologicalUnit(String biologicalUnit) {
        this.biologicalUnit = biologicalUnit;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getNumRes() {
        return this.numRes;
    }

    public void setNumRes(String numRes) {
        this.numRes = numRes;
    }

    public String getResNames() {
        return this.resNames;
    }

    public void setResNames(String resNames) {
        this.resNames = resNames;
    }

    public String getHeaderVars() {
        return this.headerVars;
    }

    public void setHeaderVars(String headerVars) {
        this.headerVars = headerVars;
    }

    public String getSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(String synthetic) {
        this.synthetic = synthetic;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public String getOrganismScientific() {
        return this.organismScientific;
    }

    public void setOrganismScientific(String organismScientific) {
        this.organismScientific = organismScientific;
    }

    public String getOrganismTaxId() {
        return this.organismTaxId;
    }

    public void setOrganismTaxId(String organismTaxId) {
        this.organismTaxId = organismTaxId;
    }

    public String getOrganismCommon() {
        return this.organismCommon;
    }

    public void setOrganismCommon(String organismCommon) {
        this.organismCommon = organismCommon;
    }

    public String getStrain() {
        return this.strain;
    }

    public void setStrain(String strain) {
        this.strain = strain;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getCellLine() {
        return this.cellLine;
    }

    public void setCellLine(String cellLine) {
        this.cellLine = cellLine;
    }

    public String getAtcc() {
        return this.atcc;
    }

    public void setAtcc(String atcc) {
        this.atcc = atcc;
    }

    public String getOrgan() {
        return this.organ;
    }

    public void setOrgan(String organ) {
        this.organ = organ;
    }

    public String getTissue() {
        return this.tissue;
    }

    public void setTissue(String tissue) {
        this.tissue = tissue;
    }

    public String getCell() {
        return this.cell;
    }

    public void setCell(String cell) {
        this.cell = cell;
    }

    public String getOrganelle() {
        return this.organelle;
    }

    public void setOrganelle(String organelle) {
        this.organelle = organelle;
    }

    public String getSecretion() {
        return this.secretion;
    }

    public void setSecretion(String secretion) {
        this.secretion = secretion;
    }

    public String getGene() {
        return this.gene;
    }

    public void setGene(String gene) {
        this.gene = gene;
    }

    public String getCellularLocation() {
        return this.cellularLocation;
    }

    public void setCellularLocation(String cellularLocation) {
        this.cellularLocation = cellularLocation;
    }

    public String getExpressionSystem() {
        return this.expressionSystem;
    }

    public String getExpressionSystemTaxId() {
        return this.expressionSystemTaxId;
    }

    public void setExpressionSystemTaxId(String expressionSystemTaxId) {
        this.expressionSystemTaxId = expressionSystemTaxId;
    }

    public void setExpressionSystem(String expressionSystem) {
        this.expressionSystem = expressionSystem;
    }

    public String getExpressionSystemStrain() {
        return this.expressionSystemStrain;
    }

    public void setExpressionSystemStrain(String expressionSystemStrain) {
        this.expressionSystemStrain = expressionSystemStrain;
    }

    public String getExpressionSystemVariant() {
        return this.expressionSystemVariant;
    }

    public void setExpressionSystemVariant(String expressionSystemVariant) {
        this.expressionSystemVariant = expressionSystemVariant;
    }

    public String getExpressionSystemCellLine() {
        return this.expressionSystemCellLine;
    }

    public void setExpressionSystemCellLine(String expressionSystemCellLine) {
        this.expressionSystemCellLine = expressionSystemCellLine;
    }

    public String getExpressionSystemAtccNumber() {
        return this.expressionSystemAtccNumber;
    }

    public void setExpressionSystemAtccNumber(String expressionSystemAtccNumber) {
        this.expressionSystemAtccNumber = expressionSystemAtccNumber;
    }

    public String getExpressionSystemOrgan() {
        return this.expressionSystemOrgan;
    }

    public void setExpressionSystemOrgan(String expressionSystemOrgan) {
        this.expressionSystemOrgan = expressionSystemOrgan;
    }

    public String getExpressionSystemTissue() {
        return this.expressionSystemTissue;
    }

    public void setExpressionSystemTissue(String expressionSystemTissue) {
        this.expressionSystemTissue = expressionSystemTissue;
    }

    public String getExpressionSystemCell() {
        return this.expressionSystemCell;
    }

    public void setExpressionSystemCell(String expressionSystemCell) {
        this.expressionSystemCell = expressionSystemCell;
    }

    public String getExpressionSystemOrganelle() {
        return this.expressionSystemOrganelle;
    }

    public void setExpressionSystemOrganelle(String expressionSystemOrganelle) {
        this.expressionSystemOrganelle = expressionSystemOrganelle;
    }

    public String getExpressionSystemCellularLocation() {
        return this.expressionSystemCellularLocation;
    }

    public void setExpressionSystemCellularLocation(String expressionSystemCellularLocation) {
        this.expressionSystemCellularLocation = expressionSystemCellularLocation;
    }

    public String getExpressionSystemVectorType() {
        return this.expressionSystemVectorType;
    }

    public void setExpressionSystemVectorType(String expressionSystemVectorType) {
        this.expressionSystemVectorType = expressionSystemVectorType;
    }

    public String getExpressionSystemVector() {
        return this.expressionSystemVector;
    }

    public void setExpressionSystemVector(String expressionSystemVector) {
        this.expressionSystemVector = expressionSystemVector;
    }

    public String getExpressionSystemPlasmid() {
        return this.expressionSystemPlasmid;
    }

    public void setExpressionSystemPlasmid(String expressionSystemPlasmid) {
        this.expressionSystemPlasmid = expressionSystemPlasmid;
    }

    public String getExpressionSystemGene() {
        return this.expressionSystemGene;
    }

    public void setExpressionSystemGene(String expressionSystemGene) {
        this.expressionSystemGene = expressionSystemGene;
    }

    public String getExpressionSystemOtherDetails() {
        return this.expressionSystemOtherDetails;
    }

    public void setExpressionSystemOtherDetails(String expressionSystemOtherDetails) {
        this.expressionSystemOtherDetails = expressionSystemOtherDetails;
    }

    public List<Chain> getChains() {
        return this.chains;
    }

    public void addChain(Chain chain) {
        this.chains.add(chain);
    }

    public void setChains(List<Chain> chains) {
        this.chains = chains;
    }
}

