/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.IOException;
import java.util.List;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyBuilder;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.quaternary.io.BioUnitDataProvider;
import org.biojava.nbio.structure.quaternary.io.BioUnitDataProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureIO {
    private static final Logger logger = LoggerFactory.getLogger(StructureIO.class);
    private static AtomCache cache;
    private static final String FILE_SEPARATOR;

    public static Structure getStructure(String name) throws IOException, StructureException {
        StructureIO.checkInitAtomCache();
        return cache.getStructure(name);
    }

    private static void checkInitAtomCache() {
        if (cache == null) {
            cache = new AtomCache();
        }
    }

    public static void setAtomCache(AtomCache c) {
        cache = c;
    }

    public static Structure getBiologicalAssembly(String pdbId) throws IOException, StructureException {
        return StructureIO.getBiologicalAssembly(pdbId, 1);
    }

    public static Structure getBiologicalAssembly(String pdbId, int biolAssemblyNr) throws IOException, StructureException {
        pdbId = pdbId.toLowerCase();
        BioUnitDataProvider provider = BioUnitDataProviderFactory.getBioUnitDataProvider();
        StructureIO.checkInitAtomCache();
        provider.setAtomCache(cache);
        Structure asymUnit = provider.getAsymUnit(pdbId);
        if (biolAssemblyNr == 0) {
            logger.info("Requested biological assembly 0, returning asymmetric unit");
            return asymUnit;
        }
        List<BiologicalAssemblyTransformation> transformations = asymUnit.getPDBHeader().getBioAssemblies().get(biolAssemblyNr).getTransforms();
        provider.setAsymUnit(null);
        provider.setAtomCache(null);
        if (transformations == null || transformations.size() == 0) {
            throw new StructureException("Could not load transformations to recreate biological assembly nr " + biolAssemblyNr + " of " + pdbId);
        }
        BiologicalAssemblyBuilder builder = new BiologicalAssemblyBuilder();
        return builder.rebuildQuaternaryStructure(asymUnit, transformations);
    }

    public static boolean hasBiologicalAssembly(String pdbId) {
        pdbId = pdbId.toLowerCase();
        BioUnitDataProvider provider = BioUnitDataProviderFactory.getBioUnitDataProvider();
        StructureIO.checkInitAtomCache();
        provider.setAtomCache(cache);
        return provider.hasBiolAssembly(pdbId);
    }

    public static int getNrBiologicalAssemblies(String pdbId) {
        pdbId = pdbId.toLowerCase();
        BioUnitDataProvider provider = BioUnitDataProviderFactory.getBioUnitDataProvider();
        StructureIO.checkInitAtomCache();
        provider.setAtomCache(cache);
        return provider.getNrBiolAssemblies(pdbId);
    }

    public static void setPdbPath(String pathToPDBFiles) {
        if (!pathToPDBFiles.endsWith(FILE_SEPARATOR)) {
            pathToPDBFiles = pathToPDBFiles + FILE_SEPARATOR;
        }
    }

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
    }
}

