/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.Callable;
import java.util.zip.GZIPOutputStream;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.StructureAlignmentFactory;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.client.PdbPair;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.SynchronizedOutFile;
import org.biojava.nbio.structure.align.xml.AFPChainXMLConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableStructureAlignment
implements Callable<AFPChain> {
    private static final Logger logger = LoggerFactory.getLogger(CallableStructureAlignment.class);
    private PdbPair pair;
    private AtomCache cache;
    private Atom[] ca1;
    private Atom[] ca2;
    private SynchronizedOutFile outFile;
    private File outFileDir;
    private String algorithmName;
    private ConfigStrucAligParams params;

    public CallableStructureAlignment() {
    }

    public CallableStructureAlignment(Atom[] ca1, Atom[] ca2, String algorithmName) {
        this.ca1 = ca1;
        this.ca2 = ca2;
        this.algorithmName = algorithmName;
    }

    @Override
    public AFPChain call() throws Exception {
        StructureAlignment algorithm = StructureAlignmentFactory.getAlgorithm(this.algorithmName);
        if (this.params != null) {
            algorithm.setParameters(this.params);
        }
        AFPChain afpChain = null;
        try {
            if (this.ca1 == null) {
                Structure structure1 = this.cache.getStructure(this.pair.getName1());
                this.ca1 = StructureTools.getRepresentativeAtomArray(structure1);
            } else {
                this.ca1 = StructureTools.cloneAtomArray(this.ca1);
            }
            Structure structure2 = null;
            if (this.ca2 == null) {
                structure2 = this.cache.getStructure(this.pair.getName2());
                this.ca2 = StructureTools.getRepresentativeAtomArray(structure2);
            } else {
                this.ca2 = StructureTools.cloneAtomArray(this.ca2);
            }
            afpChain = algorithm.align(this.ca1, this.ca2);
            if (this.pair != null) {
                afpChain.setName1(this.pair.getName1());
                afpChain.setName2(this.pair.getName2());
            }
            if (this.outFile != null && this.outFileDir != null) {
                String desc2 = structure2.getPDBHeader().getDescription();
                if (desc2 == null) {
                    desc2 = "";
                }
                afpChain.setDescription2(desc2);
                String result = afpChain.toDBSearchResult();
                logger.info("{}", (Object)result);
                this.outFile.write(result);
                String xml = AFPChainXMLConverter.toXML(afpChain, this.ca1, this.ca2);
                this.writeXML(this.outFileDir, this.pair.getName1(), this.pair.getName2(), xml);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return afpChain;
    }

    public PdbPair getPair() {
        return this.pair;
    }

    public void setPair(PdbPair pair) {
        this.pair = pair;
    }

    public AtomCache getCache() {
        return this.cache;
    }

    public void setCache(AtomCache cache) {
        this.cache = cache;
    }

    public SynchronizedOutFile getOutFile() {
        return this.outFile;
    }

    public void setOutFile(SynchronizedOutFile outFile) {
        this.outFile = outFile;
    }

    public Atom[] getCa1() {
        return this.ca1;
    }

    public void setCa1(Atom[] ca1) {
        this.ca1 = ca1;
    }

    private void writeXML(File outFileF, String name1, String name2, String xml) {
        try {
            File newF = new File(outFileF, "dbsearch_" + name1 + "_" + name2 + ".xml.gz");
            FileOutputStream fstream = new FileOutputStream(newF);
            GZIPOutputStream gz = new GZIPOutputStream(fstream);
            OutputStreamWriter writer = new OutputStreamWriter(gz);
            writer.write(xml);
            writer.close();
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    public void setOutputDir(File outFileF) {
        this.outFileDir = outFileF;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public void setParameters(ConfigStrucAligParams parameters) {
        this.params = parameters;
    }
}

