/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.ce;

import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.AbstractStructureAlignment;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.ce.CECalculator;
import org.biojava.nbio.structure.align.ce.CeParameters;
import org.biojava.nbio.structure.align.ce.CeUserArgumentProcessor;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.jama.Matrix;

public class CeMain
extends AbstractStructureAlignment
implements StructureAlignment {
    public static final String algorithmName = "jCE";
    public static final String version = "1.2";
    protected CeParameters params = new CeParameters();
    protected CECalculator calculator = new CECalculator(this.params);
    private Atom[] ca2clone;

    public static void main(String[] args) throws Exception {
        CeUserArgumentProcessor processor = new CeUserArgumentProcessor();
        processor.process(args);
    }

    @Override
    public AFPChain align(Atom[] ca1, Atom[] ca2, Object param) throws StructureException {
        if (!(param instanceof CeParameters)) {
            throw new IllegalArgumentException("CE algorithm needs an object of call CeParameters as argument.");
        }
        this.params = (CeParameters)param;
        this.ca2clone = new Atom[ca2.length];
        int pos = 0;
        for (Atom a : ca2) {
            Group g = (Group)a.getGroup().clone();
            this.ca2clone[pos] = g.getAtom(a.getName());
            ++pos;
        }
        this.calculator = new CECalculator(this.params);
        AFPChain afpChain = new AFPChain();
        afpChain = this.calculator.extractFragments(afpChain, ca1, this.ca2clone);
        this.calculator.traceFragmentMatrix(afpChain, ca1, this.ca2clone);
        this.calculator.nextStep(afpChain, ca1, this.ca2clone);
        afpChain.setAlgorithmName(this.getAlgorithmName());
        afpChain.setVersion(version);
        if (ca1.length != 0 && ca1[0].getGroup().getChain() != null && ca1[0].getGroup().getChain().getParent() != null) {
            afpChain.setName1(ca1[0].getGroup().getChain().getParent().getName());
        }
        if (ca2.length != 0 && ca2[0].getGroup().getChain() != null && ca2[0].getGroup().getChain().getParent() != null) {
            afpChain.setName2(ca2[0].getGroup().getChain().getParent().getName());
        }
        if (afpChain.getNrEQR() == 0) {
            return afpChain;
        }
        int winSize = this.params.getWinSize();
        int winSizeComb1 = (winSize - 1) * (winSize - 2) / 2;
        double[][] m = this.calculator.initSumOfDistances(ca1.length, ca2.length, winSize, winSizeComb1, ca1, this.ca2clone);
        afpChain.setDistanceMatrix(new Matrix(m));
        afpChain.setSequentialAlignment(true);
        return afpChain;
    }

    @Override
    public AFPChain align(Atom[] ca1, Atom[] ca2) throws StructureException {
        if (this.params == null) {
            this.params = new CeParameters();
        }
        return this.align(ca1, ca2, this.params);
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public ConfigStrucAligParams getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(ConfigStrucAligParams params) {
        if (!(params instanceof CeParameters)) {
            throw new IllegalArgumentException("provided parameter object is not of type CeParameter");
        }
        this.params = (CeParameters)params;
    }

    @Override
    public String getVersion() {
        return version;
    }

    public CECalculator getCECalculator() {
        return this.calculator;
    }
}

