/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.cemc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.CallableStructureAlignment;
import org.biojava.nbio.structure.align.MultipleStructureAligner;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.cemc.CeMcOptimizer;
import org.biojava.nbio.structure.align.cemc.CeMcParameters;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.BlockImpl;
import org.biojava.nbio.structure.align.multiple.BlockSetImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsemble;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsembleImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentImpl;
import org.biojava.nbio.structure.align.multiple.ReferenceSuperimposer;

public class CeMcMain
implements MultipleStructureAligner {
    public static final String version = "2.0";
    public static final String algorithmName = "jCEMC";
    private CeMcParameters params = new CeMcParameters();
    private MultipleAlignmentEnsemble ensemble = null;
    int reference = 0;

    private MultipleAlignment generateSeed(List<Atom[]> atomArrays) throws InterruptedException, ExecutionException, StructureException {
        int size = atomArrays.size();
        ArrayList<List<AFPChain>> afpAlignments = new ArrayList<List<AFPChain>>();
        for (int i = 0; i < size; ++i) {
            afpAlignments.add(new ArrayList());
            for (int j = 0; j < size; ++j) {
                ((List)afpAlignments.get(i)).add(null);
            }
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList<Future<AFPChain>> afpFuture = new ArrayList<Future<AFPChain>>();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                CallableStructureAlignment worker = new CallableStructureAlignment(atomArrays.get(i), atomArrays.get(j), "jCE Circular Permutation");
                Future<AFPChain> submit = executor.submit(worker);
                afpFuture.add(submit);
            }
        }
        int index = 0;
        for (int i = 0; i < size; ++i) {
            for (int j = i; j < size; ++j) {
                if (i == j) continue;
                ((List)afpAlignments.get(i)).add(j, ((Future)afpFuture.get(index)).get());
                ((List)afpAlignments.get(j)).add(i, ((Future)afpFuture.get(index)).get());
                ++index;
            }
        }
        executor.shutdown();
        this.reference = CeMcMain.chooseReferenceRMSD(afpAlignments);
        return CeMcMain.combineReferenceAlignments((List)afpAlignments.get(this.reference), atomArrays, this.reference);
    }

    private static int chooseReferenceRMSD(List<List<AFPChain>> afpAlignments) {
        int size = afpAlignments.size();
        ArrayList<Double> RMSDs = new ArrayList<Double>();
        for (int i = 0; i < afpAlignments.size(); ++i) {
            double rmsd = 0.0;
            for (int j = 0; j < size; ++j) {
                if (i == j) continue;
                rmsd += afpAlignments.get(i).get(j).getTotalRmsdOpt();
            }
            RMSDs.add(rmsd);
        }
        int reference = 0;
        for (int i = 1; i < size; ++i) {
            if (!((Double)RMSDs.get(i) < (Double)RMSDs.get(reference))) continue;
            reference = i;
        }
        return reference;
    }

    private static MultipleAlignment combineReferenceAlignments(List<AFPChain> afpList, List<Atom[]> atomArrays, int ref) throws StructureException {
        int str;
        int size = atomArrays.size();
        int length = 0;
        length = ref == 0 ? afpList.get(1).getCa1Length() : afpList.get(0).getCa2Length();
        ArrayList equivalencies = new ArrayList();
        for (str = 0; str < size; ++str) {
            equivalencies.add(new ArrayList());
            for (int res = 0; res < length; ++res) {
                if (str == ref) {
                    ((List)equivalencies.get(str)).add(res);
                    continue;
                }
                ((List)equivalencies.get(str)).add(null);
            }
        }
        for (str = 0; str < size; ++str) {
            if (str == ref) continue;
            for (int bk = 0; bk < afpList.get(str).getBlockNum(); ++bk) {
                for (int i = 0; i < afpList.get(str).getOptLen()[bk]; ++i) {
                    int res1 = 0;
                    int res2 = 0;
                    if (str > ref) {
                        res1 = afpList.get(str).getOptAln()[bk][0][i];
                        res2 = afpList.get(str).getOptAln()[bk][1][i];
                    } else if (str < ref) {
                        res1 = afpList.get(str).getOptAln()[bk][1][i];
                        res2 = afpList.get(str).getOptAln()[bk][0][i];
                    }
                    ((List)equivalencies.get(str)).set(res1, res2);
                }
            }
        }
        MultipleAlignmentImpl seed = new MultipleAlignmentImpl();
        seed.getEnsemble().setAtomArrays(atomArrays);
        BlockSetImpl blockSet = new BlockSetImpl(seed);
        new BlockImpl(blockSet);
        int[] lastResidues = new int[size];
        Arrays.fill(lastResidues, -1);
        for (int pos = 0; pos < length; ++pos) {
            int str2;
            boolean cp = false;
            for (str2 = 0; str2 < size; ++str2) {
                if (((List)equivalencies.get(str2)).get(pos) == null) continue;
                if ((Integer)((List)equivalencies.get(str2)).get(pos) < lastResidues[str2]) {
                    cp = true;
                    break;
                }
                lastResidues[str2] = (Integer)((List)equivalencies.get(str2)).get(pos);
            }
            if (cp) {
                new BlockImpl(blockSet);
                Arrays.fill(lastResidues, -1);
            }
            for (str2 = 0; str2 < size; ++str2) {
                if (blockSet.getBlocks().get(blockSet.getBlocks().size() - 1).getAlignRes() == null) {
                    ArrayList<List<Integer>> alnRes = new ArrayList<List<Integer>>(size);
                    for (int k = 0; k < size; ++k) {
                        alnRes.add(new ArrayList());
                    }
                    blockSet.getBlocks().get(blockSet.getBlocks().size() - 1).setAlignRes(alnRes);
                }
                blockSet.getBlocks().get(blockSet.getBlocks().size() - 1).getAlignRes().get(str2).add((Integer)((List)equivalencies.get(str2)).get(pos));
            }
        }
        ReferenceSuperimposer imposer = new ReferenceSuperimposer(ref);
        imposer.superimpose(seed);
        return seed;
    }

    @Override
    public MultipleAlignment align(List<Atom[]> atomArrays, Object params) throws StructureException {
        MultipleAlignment result = null;
        this.ensemble = new MultipleAlignmentEnsembleImpl();
        this.ensemble.setAtomArrays(atomArrays);
        try {
            result = this.generateSeed(atomArrays);
            ExecutorService executor = Executors.newCachedThreadPool();
            ArrayList<Future<MultipleAlignment>> afpFuture = new ArrayList<Future<MultipleAlignment>>();
            int seed = 0;
            for (int i = 0; i < 1; ++i) {
                CeMcOptimizer worker = new CeMcOptimizer(result, seed + i, this.reference);
                Future<MultipleAlignment> submit = executor.submit(worker);
                afpFuture.add(submit);
            }
            double maxScore = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < afpFuture.size(); ++i) {
                MultipleAlignment align = (MultipleAlignment)((Future)afpFuture.get(i)).get();
                double score = align.getScore("CEMCscore");
                if (!(score > maxScore)) continue;
                result = align;
                maxScore = score;
            }
            this.ensemble.addMultipleAlignment(result);
            executor.shutdown();
            return result;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public MultipleAlignment align(List<Atom[]> atomArrays) throws StructureException {
        CeMcParameters params = new CeMcParameters();
        return this.align(atomArrays, params);
    }

    @Override
    public ConfigStrucAligParams getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(ConfigStrucAligParams parameters) {
        if (!(this.params instanceof CeMcParameters)) {
            throw new IllegalArgumentException("Provided parameter object is not of type CeMcParameter");
        }
        this.params = this.params;
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public String getVersion() {
        return version;
    }
}

