/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.cemc;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentScorer;
import org.biojava.nbio.structure.align.multiple.MultipleSuperimposer;
import org.biojava.nbio.structure.align.multiple.ReferenceSuperimposer;

public class CeMcOptimizer
implements Callable<MultipleAlignment> {
    private static final boolean debug = true;
    private Random rnd;
    private MultipleSuperimposer imposer;
    private int Rmin = 2;
    private static final int Lmin = 15;
    private static final int iterFactor = 100;
    private static final double C = 20.0;
    private MultipleAlignment msa;
    private int size;
    private int blockNr;
    private BlockSet block;
    private List<SortedSet<Integer>> freePool;
    private double mcScore;
    private List<Atom[]> atomArrays;
    private List<Integer> structureLengths;
    private List<Integer> lengthHistory;
    private List<Double> rmsdHistory;
    private List<Double> scoreHistory;

    public CeMcOptimizer(MultipleAlignment seedAln, long randomSeed, int reference) throws StructureException {
        this.rnd = new Random(randomSeed);
        this.imposer = new ReferenceSuperimposer(reference);
        this.initialize(seedAln);
    }

    @Override
    public MultipleAlignment call() throws Exception {
        this.optimizeMC(100 * Collections.min(this.structureLengths) * this.size);
        try {
            this.saveHistory("/scratch/cemc/CeMcOptimizationHistory.csv");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return this.msa;
    }

    private void initialize(MultipleAlignment seed) throws StructureException {
        int i;
        this.msa = seed.clone();
        this.size = seed.size();
        this.Rmin = Math.max(this.size / 3, 2);
        this.atomArrays = this.msa.getEnsemble().getAtomArrays();
        this.structureLengths = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.structureLengths.add(this.atomArrays.get(i2).length);
        }
        this.block = this.msa.getBlockSets().get(0);
        this.blockNr = this.block.getBlocks().size();
        this.freePool = new ArrayList<SortedSet<Integer>>();
        ArrayList aligned = new ArrayList();
        for (i = 0; i < this.size; ++i) {
            ArrayList<Integer> residues = new ArrayList<Integer>();
            for (BlockSet bs : this.msa.getBlockSets()) {
                for (Block b : bs.getBlocks()) {
                    for (int l = 0; l < b.length(); ++l) {
                        Integer residue = b.getAlignRes().get(i).get(l);
                        if (residue == null) continue;
                        residues.add(residue);
                    }
                }
            }
            aligned.add(residues);
            this.freePool.add(new TreeSet());
        }
        for (i = 0; i < this.size; ++i) {
            for (int k = 0; k < this.atomArrays.get(i).length; ++k) {
                if (((List)aligned.get(i)).contains(k)) continue;
                this.freePool.get(i).add(k);
            }
        }
        this.checkGaps();
        this.block.clear();
        this.msa.setBlockSets(Arrays.asList(this.block));
        this.imposer.superimpose(this.msa);
        this.mcScore = MultipleAlignmentScorer.getCEMCScore(this.msa);
    }

    private void optimizeMC(int maxIter) throws StructureException {
        this.lengthHistory = new ArrayList<Integer>();
        this.rmsdHistory = new ArrayList<Double>();
        this.scoreHistory = new ArrayList<Double>();
        int conv = 0;
        int stepsToConverge = Math.max(maxIter / 50, 1000);
        for (int i = 1; i < maxIter && conv < stepsToConverge; ++i) {
            BlockSet lastBlock = this.block.clone();
            ArrayList<SortedSet<Integer>> lastFreePool = new ArrayList<SortedSet<Integer>>();
            for (int k = 0; k < this.size; ++k) {
                TreeSet<Integer> p = new TreeSet<Integer>();
                for (Integer l : this.freePool.get(k)) {
                    p.add(l);
                }
                lastFreePool.add(p);
            }
            double lastScore = this.mcScore;
            boolean moved = false;
            while (!moved) {
                int move = this.rnd.nextInt(4);
                switch (move) {
                    case 0: {
                        moved = this.shiftRow();
                        System.out.println("did shift");
                        break;
                    }
                    case 1: {
                        moved = this.expandBlock();
                        System.out.println("did expand");
                        break;
                    }
                    case 2: {
                        moved = this.shrinkBlock();
                        System.out.println("did shrink");
                        break;
                    }
                    case 3: {
                        moved = this.insertGap();
                        System.out.println("did insert gap");
                    }
                }
            }
            this.block.clear();
            this.msa.setBlockSets(Arrays.asList(this.block));
            this.imposer.superimpose(this.msa);
            this.mcScore = MultipleAlignmentScorer.getCEMCScore(this.msa);
            double AS = this.mcScore - lastScore;
            double prob = 1.0;
            if (AS < 0.0) {
                prob = this.probabilityFunction(AS, i, maxIter);
                double p = this.rnd.nextDouble();
                if (p > prob) {
                    this.block = lastBlock;
                    this.freePool = lastFreePool;
                    this.mcScore = lastScore;
                    ++conv;
                } else {
                    conv = 0;
                }
            } else {
                conv = 0;
            }
            System.out.println("Step: " + i + ": --prob: " + prob + ", --score: " + AS + ", --conv: " + conv);
            if (i % 100 != 1) continue;
            this.msa.setBlockSets(Arrays.asList(this.block));
            this.imposer.superimpose(this.msa);
            this.lengthHistory.add(this.block.length());
            this.rmsdHistory.add(MultipleAlignmentScorer.getRMSD(this.msa));
            this.scoreHistory.add(this.mcScore);
        }
        this.msa.setBlockSets(Arrays.asList(this.block));
        this.imposer.superimpose(this.msa);
        MultipleAlignmentScorer.calculateScores(this.msa);
        this.msa.putScore("CEMCscore", this.mcScore);
    }

    private boolean checkGaps() {
        boolean shrinkedAny = false;
        ArrayList shrinkColumns = new ArrayList();
        for (Block b : this.block.getBlocks()) {
            ArrayList<Integer> shrinkCol = new ArrayList<Integer>();
            for (int res = 0; res < b.length(); ++res) {
                int gapCount = 0;
                for (int su = 0; su < this.size; ++su) {
                    if (b.getAlignRes().get(su).get(res) != null) continue;
                    ++gapCount;
                }
                if (this.size - gapCount >= this.Rmin) continue;
                shrinkCol.add(res);
            }
            shrinkColumns.add(shrinkCol);
        }
        for (int b = 0; b < this.blockNr; ++b) {
            for (int col = ((List)shrinkColumns.get(b)).size() - 1; col >= 0; --col) {
                for (int str = 0; str < this.size; ++str) {
                    Integer residue = this.block.getBlocks().get(b).getAlignRes().get(str).get((Integer)((List)shrinkColumns.get(b)).get(col));
                    this.block.getBlocks().get(b).getAlignRes().get(str).remove((Integer)((List)shrinkColumns.get(b)).get(col));
                    if (residue == null) continue;
                    this.freePool.get(str).add(residue);
                }
                shrinkedAny = true;
            }
        }
        return shrinkedAny;
    }

    private boolean insertGap() {
        int str = this.rnd.nextInt(this.size);
        int bk = this.rnd.nextInt(this.blockNr);
        if (this.block.getBlocks().get(bk).length() <= 15) {
            return false;
        }
        int res = this.rnd.nextInt(this.block.getBlocks().get(bk).length());
        Integer residueL = this.block.getBlocks().get(bk).getAlignRes().get(str).get(res);
        if (residueL == null) {
            return false;
        }
        this.freePool.get(str).add(residueL);
        this.block.getBlocks().get(bk).getAlignRes().get(str).set(res, null);
        this.checkGaps();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shiftRow() {
        int str = this.rnd.nextInt(this.size);
        int rl = this.rnd.nextInt(2);
        int bk = this.rnd.nextInt(this.blockNr);
        int res = this.rnd.nextInt(this.block.getBlocks().get(bk).length());
        Block currentBlock = this.block.getBlocks().get(bk);
        if (currentBlock.getAlignRes().get(str).get(res) == null) {
            int rightRes;
            int leftRes = res;
            for (rightRes = res; currentBlock.getAlignRes().get(str).get(rightRes) == null && rightRes < currentBlock.length() - 1; ++rightRes) {
            }
            while (currentBlock.getAlignRes().get(str).get(leftRes) == null && leftRes > 0) {
                --leftRes;
            }
            if (currentBlock.getAlignRes().get(str).get(leftRes) == null && currentBlock.getAlignRes().get(str).get(rightRes) == null) {
                return false;
            }
            if (currentBlock.getAlignRes().get(str).get(leftRes) == null) {
                Integer residue = currentBlock.getAlignRes().get(str).get(rightRes) - 1;
                if (!this.freePool.get(str).contains(residue)) return false;
                currentBlock.getAlignRes().get(str).set(res, residue);
                this.freePool.get(str).remove(residue);
                return true;
            } else if (currentBlock.getAlignRes().get(str).get(rightRes) == null) {
                Integer residue = currentBlock.getAlignRes().get(str).get(leftRes) + 1;
                if (!this.freePool.contains(residue)) return false;
                currentBlock.getAlignRes().get(str).set(res, residue);
                this.freePool.get(str).remove(residue);
                return true;
            } else {
                if (currentBlock.getAlignRes().get(str).get(rightRes) == currentBlock.getAlignRes().get(str).get(leftRes) + 1) {
                    return false;
                }
                Integer residue = this.rnd.nextInt(currentBlock.getAlignRes().get(str).get(rightRes) - currentBlock.getAlignRes().get(str).get(leftRes) - 1) + currentBlock.getAlignRes().get(str).get(leftRes) + 1;
                if (!this.freePool.get(str).contains(residue)) throw new IllegalStateException("The freePool does not contain a residue in between two non-consecutive aligned positions");
                currentBlock.getAlignRes().get(str).set(res, residue);
                this.freePool.get(str).remove(residue);
            }
            return true;
        }
        switch (rl) {
            case 0: {
                int leftBoundary = res - 1;
                int leftPrevRes = res;
                while (leftBoundary >= 0 && currentBlock.getAlignRes().get(str).get(leftBoundary) != null && currentBlock.getAlignRes().get(str).get(leftPrevRes) <= currentBlock.getAlignRes().get(str).get(leftBoundary) + 1) {
                    leftPrevRes = leftBoundary--;
                }
                ++leftBoundary;
                int rightBoundary = res + 1;
                int rightPrevRes = res;
                while (rightBoundary != currentBlock.length() && currentBlock.getAlignRes().get(str).get(rightBoundary) != null && currentBlock.getAlignRes().get(str).get(rightPrevRes) + 1 >= currentBlock.getAlignRes().get(str).get(rightBoundary)) {
                    rightPrevRes = rightBoundary++;
                }
                Integer residueR0 = currentBlock.getAlignRes().get(str).get(--rightBoundary);
                Integer residueL0 = currentBlock.getAlignRes().get(str).get(leftBoundary);
                currentBlock.getAlignRes().get(str).remove(rightBoundary);
                if (residueR0 == null) {
                    throw new IllegalStateException("The residue right boundary in shift is null! Cannot be...");
                }
                this.freePool.get(str).add(residueR0);
                if (residueL0 == null) {
                    throw new IllegalStateException("The residue left boundary in shift is null! Cannot be...");
                }
                residueL0 = residueL0 - 1;
                if (this.freePool.get(str).contains(residueL0)) {
                    currentBlock.getAlignRes().get(str).add(leftBoundary, residueL0);
                    this.freePool.get(str).remove(residueL0);
                    break;
                }
                currentBlock.getAlignRes().get(str).add(leftBoundary, null);
                break;
            }
            case 1: {
                int leftBoundary1 = res - 1;
                int leftPrevRes1 = res;
                while (leftBoundary1 >= 0 && currentBlock.getAlignRes().get(str).get(leftBoundary1) != null && currentBlock.getAlignRes().get(str).get(leftPrevRes1) <= currentBlock.getAlignRes().get(str).get(leftBoundary1) + 1) {
                    leftPrevRes1 = leftBoundary1--;
                }
                ++leftBoundary1;
                int rightBoundary1 = res + 1;
                int rightPrevRes1 = res;
                while (rightBoundary1 != currentBlock.length() && currentBlock.getAlignRes().get(str).get(rightBoundary1) != null && currentBlock.getAlignRes().get(str).get(rightPrevRes1) + 1 >= currentBlock.getAlignRes().get(str).get(rightBoundary1)) {
                    rightPrevRes1 = rightBoundary1++;
                }
                Integer residueR1 = currentBlock.getAlignRes().get(str).get(--rightBoundary1);
                Integer residueL1 = currentBlock.getAlignRes().get(str).get(leftBoundary1);
                if (residueR1 == null) {
                    throw new IllegalStateException("The residue right boundary in shift is null! Cannot be...");
                }
                residueR1 = residueR1 + 1;
                if (this.freePool.contains(residueR1)) {
                    if (rightBoundary1 == currentBlock.length() - 1) {
                        currentBlock.getAlignRes().get(str).add(residueR1);
                    } else {
                        currentBlock.getAlignRes().get(str).add(rightBoundary1 + 1, residueR1);
                    }
                    this.freePool.get(str).remove(residueR1);
                } else {
                    currentBlock.getAlignRes().get(str).add(rightBoundary1 + 1, null);
                }
                currentBlock.getAlignRes().get(str).remove(leftBoundary1);
                if (residueL1 == null) throw new IllegalStateException("The residue left boundary in shift is null! Cannot be...");
                this.freePool.get(str).add(residueL1);
                break;
            }
        }
        this.checkGaps();
        return true;
    }

    private boolean expandBlock() {
        int rl = this.rnd.nextInt(2);
        int bk = this.rnd.nextInt(this.blockNr);
        int res = this.rnd.nextInt(this.block.getBlocks().get(bk).length());
        Block currentBlock = this.block.getBlocks().get(bk);
        int gaps = 0;
        switch (rl) {
            case 0: {
                int str;
                int rightBoundary = res;
                int[] previousPos = new int[this.size];
                for (str = 0; str < this.size; ++str) {
                    previousPos[str] = -1;
                }
                while (currentBlock.length() - 1 > rightBoundary) {
                    int noncontinuous = 0;
                    for (int str2 = 0; str2 < this.size; ++str2) {
                        if (currentBlock.getAlignRes().get(str2).get(rightBoundary) == null) continue;
                        if (previousPos[str2] == -1) {
                            previousPos[str2] = currentBlock.getAlignRes().get(str2).get(rightBoundary);
                            continue;
                        }
                        if (currentBlock.getAlignRes().get(str2).get(rightBoundary) <= previousPos[str2] + 1) continue;
                        ++noncontinuous;
                    }
                    if (noncontinuous >= this.Rmin) break;
                    ++rightBoundary;
                }
                --rightBoundary;
                for (str = 0; str < this.size; ++str) {
                    Integer residueR = currentBlock.getAlignRes().get(str).get(rightBoundary);
                    if (residueR == null) {
                        if (rightBoundary == currentBlock.length() - 1) {
                            currentBlock.getAlignRes().get(str).add(null);
                        } else {
                            currentBlock.getAlignRes().get(str).add(rightBoundary + 1, null);
                        }
                        ++gaps;
                        continue;
                    }
                    if (this.freePool.get(str).contains(residueR + 1)) {
                        Integer residueAdd = residueR + 1;
                        if (rightBoundary == currentBlock.length() - 1) {
                            currentBlock.getAlignRes().get(str).add(residueAdd);
                        } else {
                            currentBlock.getAlignRes().get(str).add(rightBoundary + 1, residueAdd);
                        }
                        this.freePool.get(str).remove(residueAdd);
                        continue;
                    }
                    if (rightBoundary == currentBlock.length() - 1) {
                        currentBlock.getAlignRes().get(str).add(null);
                    } else {
                        currentBlock.getAlignRes().get(str).add(rightBoundary + 1, null);
                    }
                    ++gaps;
                }
                break;
            }
            case 1: {
                int str;
                int leftBoundary = res;
                int[] nextPos = new int[this.size];
                for (str = 0; str < this.size; ++str) {
                    nextPos[str] = -1;
                }
                while (leftBoundary > 0) {
                    int noncontinuous = 0;
                    for (int str3 = 0; str3 < this.size; ++str3) {
                        if (currentBlock.getAlignRes().get(str3).get(leftBoundary) == null) continue;
                        if (nextPos[str3] == -1) {
                            nextPos[str3] = currentBlock.getAlignRes().get(str3).get(leftBoundary);
                            continue;
                        }
                        if (currentBlock.getAlignRes().get(str3).get(leftBoundary) >= nextPos[str3] - 1) continue;
                        ++noncontinuous;
                    }
                    if (noncontinuous >= this.Rmin) break;
                    --leftBoundary;
                }
                for (str = 0; str < this.size; ++str) {
                    Integer residueL = currentBlock.getAlignRes().get(str).get(leftBoundary);
                    if (residueL == null) {
                        currentBlock.getAlignRes().get(str).add(leftBoundary, null);
                        ++gaps;
                        continue;
                    }
                    if (this.freePool.get(str).contains(residueL - 1)) {
                        Integer residueAdd = residueL - 1;
                        currentBlock.getAlignRes().get(str).add(leftBoundary, residueAdd);
                        this.freePool.get(str).remove(residueAdd);
                        continue;
                    }
                    currentBlock.getAlignRes().get(str).add(leftBoundary, null);
                    ++gaps;
                }
                break;
            }
        }
        if (this.size - gaps >= this.Rmin) {
            return true;
        }
        this.checkGaps();
        return false;
    }

    private boolean shrinkBlock() {
        int bk = this.rnd.nextInt(this.blockNr);
        int res = this.rnd.nextInt(this.block.getBlocks().get(bk).length());
        if (this.block.getBlocks().get(bk).length() <= 15) {
            return false;
        }
        Block currentBlock = this.block.getBlocks().get(bk);
        for (int str = 0; str < this.size; ++str) {
            Integer residue = currentBlock.getAlignRes().get(str).get(res);
            currentBlock.getAlignRes().get(str).remove(res);
            if (residue == null) continue;
            this.freePool.get(str).add(residue);
        }
        return true;
    }

    private double probabilityFunction(double AS, int m, int maxIter) {
        double prob = (20.0 + AS) / (double)m;
        double norm = 1.0 - (double)m * 1.0 / (double)maxIter;
        return Math.min(Math.max(prob * norm, 0.0), 1.0);
    }

    private void saveHistory(String filePath) throws IOException {
        FileWriter writer = new FileWriter(filePath);
        writer.append("Step,Length,RMSD,Score\n");
        for (int i = 0; i < this.lengthHistory.size(); ++i) {
            writer.append(i * 100 + "," + this.lengthHistory.get(i) + "," + this.rmsdHistory.get(i) + "," + this.scoreHistory.get(i) + "\n");
        }
        writer.flush();
        writer.close();
    }
}

