/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.structure.align.multiple.ScoresCache;

public abstract class AbstractScoresCache
implements ScoresCache {
    private Map<String, Double> scores = null;

    protected AbstractScoresCache() {
        this.scores = null;
    }

    protected AbstractScoresCache(AbstractScoresCache cache) {
        this.scores = cache.scores;
    }

    @Override
    public void putScore(String property, Double score) {
        if (this.scores == null) {
            this.scores = new HashMap<String, Double>();
        }
        this.scores.put(property, score);
    }

    @Override
    public Double getScore(String property) {
        if (this.scores != null && this.scores.containsKey(property)) {
            return this.scores.get(property);
        }
        return null;
    }

    @Override
    public Set<String> getScores() {
        if (this.scores == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.scores.keySet());
    }

    protected Object clone(Object e) throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Subclasses must override clone");
    }

    public void clear() {
        this.scores = null;
    }
}

