/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.align.multiple.AbstractScoresCache;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;

public class BlockSetImpl
extends AbstractScoresCache
implements Serializable,
BlockSet,
Cloneable {
    private static final long serialVersionUID = -1015791986000076089L;
    private MultipleAlignment parent;
    private List<Block> blocks;
    private List<Matrix4d> pose;
    private int length;
    private int coreLength;

    public BlockSetImpl(MultipleAlignment multipleAlignment) {
        this.parent = multipleAlignment;
        if (this.parent != null) {
            this.parent.getBlockSets().add(this);
        }
        this.blocks = null;
        this.pose = null;
        this.length = -1;
        this.coreLength = -1;
    }

    public BlockSetImpl(BlockSetImpl bs) {
        this.parent = bs.parent;
        this.length = bs.length;
        this.coreLength = bs.coreLength;
        this.pose = null;
        this.pose = null;
        this.blocks = null;
        if (bs.blocks != null) {
            this.blocks = new ArrayList<Block>();
            for (Block b : bs.blocks) {
                Block newB = b.clone();
                newB.setBlockSet(this);
                this.blocks.add(newB);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.length = -1;
        this.coreLength = -1;
        this.pose = null;
        for (Block a : this.getBlocks()) {
            a.clear();
        }
    }

    @Override
    public BlockSetImpl clone() {
        return new BlockSetImpl(this);
    }

    public String toString() {
        return "BlockSetImpl [blocks=" + this.blocks + ", pose=" + this.pose + ", length=" + this.length + ", coreLength=" + this.coreLength + "]";
    }

    @Override
    public MultipleAlignment getMultipleAlignment() {
        return this.parent;
    }

    @Override
    public void setMultipleAlignment(MultipleAlignment parent) {
        this.parent = parent;
    }

    @Override
    public List<Block> getBlocks() {
        if (this.blocks == null) {
            this.blocks = new ArrayList<Block>();
        }
        return this.blocks;
    }

    @Override
    public void setBlocks(List<Block> blocks) {
        this.blocks = blocks;
        for (Block b : blocks) {
            b.setBlockSet(this);
        }
    }

    @Override
    public List<Matrix4d> getTransformations() {
        return this.pose;
    }

    @Override
    public void setTransformations(List<Matrix4d> transformations) {
        if (this.size() != transformations.size()) {
            throw new IllegalArgumentException("Wrong number of structures for this alignment");
        }
        this.pose = transformations;
    }

    @Override
    public int length() {
        if (this.length == -1) {
            this.updateLength();
        }
        return this.length;
    }

    @Override
    public int size() {
        if (this.parent != null) {
            return this.parent.size();
        }
        if (this.getBlocks().size() == 0) {
            throw new IndexOutOfBoundsException("Empty BlockSet: number of Blocks == 0.");
        }
        return this.blocks.get(0).size();
    }

    @Override
    public int getCoreLength() {
        if (this.coreLength == -1) {
            this.updateCoreLength();
        }
        return this.coreLength;
    }

    protected void updateLength() {
        if (this.getBlocks().size() == 0) {
            throw new IndexOutOfBoundsException("Empty BlockSet: number of Blocks == 0.");
        }
        this.length = 0;
        for (Block block : this.blocks) {
            this.length += block.length();
        }
    }

    protected void updateCoreLength() {
        if (this.getBlocks().size() == 0) {
            throw new IndexOutOfBoundsException("Empty BlockSet: number of Blocks == 0.");
        }
        this.coreLength = 0;
        for (Block block : this.blocks) {
            this.coreLength += block.getCoreLength();
        }
    }

    protected void updateCache() {
        this.updateCoreLength();
        this.updateLength();
    }
}

