/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.AbstractScoresCache;
import org.biojava.nbio.structure.align.multiple.BlockImpl;
import org.biojava.nbio.structure.align.multiple.BlockSetImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsemble;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentImpl;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.jama.Matrix;

public class MultipleAlignmentEnsembleImpl
extends AbstractScoresCache
implements MultipleAlignmentEnsemble,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5732485866623431898L;
    String algorithmName;
    String version;
    Long ioTime;
    Long calculationTime;
    private List<String> structureNames;
    private List<Atom[]> atomArrays;
    private List<Matrix> distanceMatrix;
    private List<MultipleAlignment> multipleAlignments;

    public MultipleAlignmentEnsembleImpl() {
        this.algorithmName = null;
        this.version = null;
        this.ioTime = null;
        this.calculationTime = null;
        this.structureNames = null;
        this.atomArrays = null;
        this.distanceMatrix = null;
        this.multipleAlignments = null;
    }

    public MultipleAlignmentEnsembleImpl(List<String> structureNames) {
        this();
        this.setStructureNames(structureNames);
    }

    public MultipleAlignmentEnsembleImpl(MultipleAlignmentEnsembleImpl e) {
        this.algorithmName = e.algorithmName;
        this.version = e.version;
        this.ioTime = e.ioTime;
        this.calculationTime = e.calculationTime;
        this.atomArrays = null;
        if (e.atomArrays != null) {
            this.atomArrays = new ArrayList<Atom[]>();
            for (Atom[] array : e.atomArrays) {
                Atom[] newArray = new Atom[array.length];
                for (int i = 0; i < array.length; ++i) {
                    newArray[i] = (Atom)array[i].clone();
                }
                this.atomArrays.add(newArray);
            }
        }
        this.distanceMatrix = null;
        if (e.distanceMatrix != null) {
            this.distanceMatrix = new ArrayList<Matrix>();
            for (Matrix mat : e.distanceMatrix) {
                this.distanceMatrix.add((Matrix)mat.clone());
            }
        }
        this.multipleAlignments = null;
        if (e.multipleAlignments != null) {
            this.multipleAlignments = new ArrayList<MultipleAlignment>();
            for (MultipleAlignment msa : e.multipleAlignments) {
                MultipleAlignment newMSA = msa.clone();
                newMSA.setEnsemble(this);
            }
        }
        this.structureNames = new ArrayList<String>(e.structureNames);
    }

    public MultipleAlignmentEnsembleImpl(AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        this();
        this.setAtomArrays(Arrays.asList(ca1, ca2));
        this.setStructureNames(Arrays.asList(afpChain.getName1(), afpChain.getName2()));
        this.setAlgorithmName(afpChain.getAlgorithmName());
        this.setVersion(afpChain.getVersion());
        this.setCalculationTime(afpChain.getCalculationTime());
        MultipleAlignmentImpl alignment = new MultipleAlignmentImpl(this);
        this.setMultipleAlignments(Arrays.asList(alignment));
        Matrix4d ident = new Matrix4d();
        ident.setIdentity();
        alignment.setTransformations(Arrays.asList(ident, Calc.getTransformation(afpChain.getBlockRotationMatrix()[0], afpChain.getBlockShiftVector()[0])));
        ArrayList<BlockImpl> blocks = new ArrayList<BlockImpl>(afpChain.getBlockNum());
        for (int bs = 0; bs < afpChain.getBlockNum(); ++bs) {
            BlockSetImpl blockSet = new BlockSetImpl(alignment);
            BlockImpl block = new BlockImpl(blockSet);
            block.setAlignRes(new ArrayList<List<Integer>>());
            block.getAlignRes().add(new ArrayList());
            block.getAlignRes().add(new ArrayList());
            blocks.add(block);
            blockSet.setTransformations(Arrays.asList(ident, Calc.getTransformation(afpChain.getBlockRotationMatrix()[bs], afpChain.getBlockShiftVector()[bs])));
            for (int i = 0; i < afpChain.getOptAln()[bs][0].length; ++i) {
                block.getAlignRes().get(0).add(afpChain.getOptAln()[bs][0][i]);
                block.getAlignRes().get(1).add(afpChain.getOptAln()[bs][1][i]);
            }
        }
    }

    @Override
    public MultipleAlignmentEnsembleImpl clone() {
        return new MultipleAlignmentEnsembleImpl(this);
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Long getIoTime() {
        return this.ioTime;
    }

    @Override
    public void setIoTime(Long millis) {
        this.ioTime = millis;
    }

    @Override
    public Long getCalculationTime() {
        return this.calculationTime;
    }

    @Override
    public void setCalculationTime(Long millis) {
        this.calculationTime = millis;
    }

    @Override
    public List<String> getStructureNames() {
        return this.structureNames;
    }

    @Override
    public void setStructureNames(List<String> structureNames) {
        this.structureNames = structureNames;
    }

    @Override
    public List<Atom[]> getAtomArrays() {
        if (this.atomArrays == null) {
            try {
                this.updateAtomArrays();
            }
            catch (IOException e) {
                throw new NullPointerException(e.getMessage());
            }
            catch (StructureException e) {
                throw new NullPointerException(e.getMessage());
            }
        }
        return this.atomArrays;
    }

    @Override
    public void setAtomArrays(List<Atom[]> atomArrays) {
        this.atomArrays = atomArrays;
    }

    public void updateAtomArrays() throws IOException, StructureException {
        AtomCache cache = new AtomCache();
        this.atomArrays = new ArrayList<Atom[]>();
        for (String name : this.getStructureNames()) {
            Atom[] array = cache.getRepresentativeAtoms(name);
            this.atomArrays.add(array);
        }
    }

    @Override
    public int getAlignmentNum() {
        return this.multipleAlignments.size();
    }

    @Override
    public List<Matrix> getDistanceMatrix() {
        return this.distanceMatrix;
    }

    public void updateDistanceMatrix() {
        this.distanceMatrix = new ArrayList<Matrix>();
        for (int s = 0; s < this.size(); ++s) {
            int n = this.atomArrays.get(s).length;
            Matrix distMat = new Matrix(n, n);
            for (int a1 = 0; a1 < n; ++a1) {
                for (int a2 = 0; a2 < n; ++a2) {
                    double dist = Calc.getDistance(this.atomArrays.get(s)[a1], this.atomArrays.get(s)[a2]);
                    distMat.set(a1, a2, dist);
                }
            }
            this.distanceMatrix.add(distMat);
        }
    }

    @Override
    public List<MultipleAlignment> getMultipleAlignments() {
        if (this.multipleAlignments == null) {
            this.multipleAlignments = new ArrayList<MultipleAlignment>();
        }
        return this.multipleAlignments;
    }

    @Override
    public void setMultipleAlignments(List<MultipleAlignment> multipleAlignments) {
        this.multipleAlignments = multipleAlignments;
    }

    @Override
    public void addMultipleAlignment(MultipleAlignment alignment) {
        if (this.multipleAlignments == null) {
            this.multipleAlignments = new ArrayList<MultipleAlignment>();
        }
        this.multipleAlignments.add(alignment);
        alignment.setEnsemble(this);
    }

    @Override
    public int size() {
        if (this.structureNames != null) {
            return this.structureNames.size();
        }
        if (this.atomArrays != null) {
            return this.atomArrays.size();
        }
        throw new IndexOutOfBoundsException("Empty MultipleAlignmentEnsemble: structureNames == null && atomArrays == null");
    }

    @Override
    public void clear() {
        super.clear();
        this.distanceMatrix = null;
        for (MultipleAlignment a : this.getMultipleAlignments()) {
            a.clear();
        }
    }
}

