/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.align.multiple.AbstractScoresCache;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsemble;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsembleImpl;

public class MultipleAlignmentImpl
extends AbstractScoresCache
implements Serializable,
MultipleAlignment,
Cloneable {
    private static final long serialVersionUID = 3432043794125805139L;
    MultipleAlignmentEnsemble parent;
    List<BlockSet> blockSets;
    int length;
    int coreLength;
    List<Matrix4d> pose;

    public MultipleAlignmentImpl() {
        this(new MultipleAlignmentEnsembleImpl());
    }

    public MultipleAlignmentImpl(List<String> structureNames) {
        this(new MultipleAlignmentEnsembleImpl(structureNames));
    }

    public MultipleAlignmentImpl(MultipleAlignmentEnsemble ensemble) {
        this.parent = ensemble;
        if (this.parent != null) {
            this.parent.getMultipleAlignments().add(this);
        }
        this.blockSets = null;
        this.pose = null;
        this.length = -1;
        this.coreLength = -1;
    }

    public MultipleAlignmentImpl(MultipleAlignmentImpl ma) {
        super(ma);
        this.parent = ma.parent;
        this.pose = null;
        this.blockSets = null;
        if (ma.blockSets != null) {
            this.blockSets = new ArrayList<BlockSet>();
            for (BlockSet bs : ma.blockSets) {
                BlockSet newBS = bs.clone();
                newBS.setMultipleAlignment(this);
                this.blockSets.add(newBS);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.length = -1;
        this.coreLength = -1;
        this.pose = null;
        for (BlockSet a : this.getBlockSets()) {
            a.clear();
        }
    }

    @Override
    public MultipleAlignmentImpl clone() {
        return new MultipleAlignmentImpl(this);
    }

    @Override
    public String toString() {
        String resume = "Structures:" + this.parent.getStructureNames() + " \nAlgorithm:" + this.parent.getAlgorithmName() + "_" + this.parent.getVersion() + " \nBlockSets: " + this.getBlockSets().size() + " \nBlocks: " + this.getBlocks().size() + " \nLength: " + this.length() + " \nCore Length: " + this.getCoreLength();
        for (String score : this.getScores()) {
            resume = resume + " \n" + score + ": " + String.format("%.2f", this.getScore(score));
        }
        return resume;
    }

    @Override
    public List<BlockSet> getBlockSets() {
        if (this.blockSets == null) {
            this.blockSets = new ArrayList<BlockSet>();
        }
        return this.blockSets;
    }

    @Override
    public List<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (BlockSet bs : this.getBlockSets()) {
            blocks.addAll(bs.getBlocks());
        }
        return blocks;
    }

    @Override
    public void setBlockSets(List<BlockSet> blockSets) {
        this.blockSets = blockSets;
    }

    @Override
    public List<Matrix4d> getTransformations() {
        return this.pose;
    }

    @Override
    public void setTransformations(List<Matrix4d> matrices) {
        if (this.size() != matrices.size()) {
            throw new IllegalArgumentException("Wrong number of structures for this alignment");
        }
        this.clear();
        this.pose = matrices;
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public int length() {
        if (this.length < 0) {
            this.updateLength();
        }
        return this.length;
    }

    @Override
    public int getCoreLength() {
        if (this.coreLength < 0) {
            this.updateCoreLength();
        }
        return this.coreLength;
    }

    protected void updateLength() {
        if (this.getBlockSets().size() == 0) {
            throw new IndexOutOfBoundsException("Empty MultipleAlignment: getBlockSetNum() == 0.");
        }
        this.length = 0;
        for (BlockSet blockSet : this.blockSets) {
            this.length += blockSet.length();
        }
    }

    protected void updateCoreLength() {
        if (this.getBlockSets().size() == 0) {
            throw new IndexOutOfBoundsException("Empty MultipleAlignment: getBlockSetNum() == 0.");
        }
        this.coreLength = 0;
        for (BlockSet blockSet : this.blockSets) {
            this.coreLength += blockSet.getCoreLength();
        }
    }

    protected void updateCache() {
        this.updateCoreLength();
        this.updateLength();
    }

    @Override
    public MultipleAlignmentEnsemble getEnsemble() {
        return this.parent;
    }

    @Override
    public void setEnsemble(MultipleAlignmentEnsemble parent) {
        this.parent = parent;
    }
}

