/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.jama.Matrix;

public class MultipleAlignmentTools {
    public static List<String> getSequenceAlignment(MultipleAlignment alignment, List<Integer> mapSeqToStruct) {
        int i;
        ArrayList<String> alnSequences = new ArrayList<String>();
        for (int str = 0; str < alignment.size(); ++str) {
            alnSequences.add("");
        }
        mapSeqToStruct.clear();
        List<Atom[]> atoms = alignment.getEnsemble().getAtomArrays();
        int globalPos = -1;
        ArrayList freePool = new ArrayList();
        ArrayList blockStarts = new ArrayList();
        ArrayList aligned = new ArrayList();
        for (i = 0; i < alignment.size(); ++i) {
            ArrayList<Integer> residues = new ArrayList<Integer>();
            freePool.add(new TreeSet());
            blockStarts.add(new TreeSet());
            for (BlockSet bs : alignment.getBlockSets()) {
                for (Block b : bs.getBlocks()) {
                    boolean first = true;
                    for (int l = 0; l < b.length(); ++l) {
                        Integer residue = b.getAlignRes().get(i).get(l);
                        if (residue == null) continue;
                        if (first) {
                            ((SortedSet)blockStarts.get(i)).add(residue);
                        }
                        residues.add(residue);
                        first = false;
                    }
                }
            }
            aligned.add(residues);
        }
        for (i = 0; i < alignment.size(); ++i) {
            for (int k = 0; k < atoms.get(i).length; ++k) {
                if (((List)aligned.get(i)).contains(k)) continue;
                ((SortedSet)freePool.get(i)).add(k);
            }
        }
        for (int b = 0; b < alignment.getBlocks().size(); ++b) {
            if (b != 0) {
                for (int str = 0; str < alignment.size(); ++str) {
                    alnSequences.set(str, ((String)alnSequences.get(str)).concat("-"));
                }
                mapSeqToStruct.add(-1);
            }
            int[] previousPos = new int[alignment.size()];
            Arrays.fill(previousPos, -1);
            char[] provisionalChar = new char[alignment.size()];
            Arrays.fill(provisionalChar, '-');
            for (int pos = 0; pos < alignment.getBlocks().get(b).length(); ++pos) {
                ++globalPos;
                boolean gaps = true;
                while (gaps) {
                    int str;
                    gaps = false;
                    for (str = 0; str < alignment.size(); ++str) {
                        Integer residue;
                        if (previousPos[str] == -1) {
                            residue = alignment.getBlocks().get(b).getAlignRes().get(str).get(pos);
                            if (residue == null) {
                                provisionalChar[str] = 45;
                                continue;
                            }
                            provisionalChar[str] = StructureTools.get1LetterCode(atoms.get(str)[residue].getGroup().getPDBName()).charValue();
                            continue;
                        }
                        residue = alignment.getBlocks().get(b).getAlignRes().get(str).get(pos);
                        if (residue == null) {
                            if (((SortedSet)freePool.get(str)).contains(previousPos[str] + 1)) {
                                provisionalChar[str] = Character.toLowerCase(StructureTools.get1LetterCode(atoms.get(str)[previousPos[str] + 1].getGroup().getPDBName()).charValue());
                                continue;
                            }
                            provisionalChar[str] = 45;
                            continue;
                        }
                        if (previousPos[str] + 1 == residue) {
                            provisionalChar[str] = StructureTools.get1LetterCode(atoms.get(str)[residue].getGroup().getPDBName()).charValue();
                            continue;
                        }
                        provisionalChar[str] = 32;
                        gaps = true;
                    }
                    if (gaps) {
                        for (str = 0; str < alignment.size(); ++str) {
                            if (provisionalChar[str] == ' ') {
                                alnSequences.set(str, ((String)alnSequences.get(str)).concat("" + Character.toLowerCase(StructureTools.get1LetterCode(atoms.get(str)[previousPos[str] + 1].getGroup().getPDBName()).charValue())));
                                int n = str;
                                previousPos[n] = previousPos[n] + 1;
                                continue;
                            }
                            alnSequences.set(str, ((String)alnSequences.get(str)).concat("-"));
                        }
                        mapSeqToStruct.add(-1);
                        continue;
                    }
                    for (str = 0; str < alignment.size(); ++str) {
                        alnSequences.set(str, ((String)alnSequences.get(str)).concat("" + provisionalChar[str]));
                        if (provisionalChar[str] == '-') continue;
                        if (alignment.getBlocks().get(b).getAlignRes().get(str).get(pos) == null) {
                            int n = str;
                            previousPos[n] = previousPos[n] + 1;
                            continue;
                        }
                        previousPos[str] = alignment.getBlocks().get(b).getAlignRes().get(str).get(pos);
                    }
                    mapSeqToStruct.add(globalPos);
                }
            }
            int[] blockEnds = new int[alignment.size()];
            block14: for (int str = 0; str < alignment.size(); ++str) {
                Iterator i$ = ((SortedSet)blockStarts.get(str)).iterator();
                while (i$.hasNext()) {
                    int res = (Integer)i$.next();
                    if (previousPos[str] > res) {
                        blockEnds[str] = res;
                        continue;
                    }
                    blockEnds[str] = res;
                    continue block14;
                }
            }
            boolean allGaps = false;
            while (!allGaps) {
                int str;
                allGaps = true;
                for (str = 0; str < alignment.size(); ++str) {
                    if (previousPos[str] + 1 < blockEnds[str]) {
                        provisionalChar[str] = Character.toLowerCase(StructureTools.get1LetterCode(atoms.get(str)[previousPos[str] + 1].getGroup().getPDBName()).charValue());
                        int n = str;
                        previousPos[n] = previousPos[n] + 1;
                        allGaps = false;
                        continue;
                    }
                    provisionalChar[str] = 45;
                }
                if (allGaps) continue;
                for (str = 0; str < alignment.size(); ++str) {
                    alnSequences.set(str, ((String)alnSequences.get(str)).concat("" + provisionalChar[str]));
                }
                mapSeqToStruct.add(-1);
            }
        }
        return alnSequences;
    }

    public static List<String> getSequenceAlignment(MultipleAlignment alignment) {
        return MultipleAlignmentTools.getSequenceAlignment(alignment, new ArrayList<Integer>());
    }

    public static List<String> getBlockSequenceAlignment(MultipleAlignment alignment, List<Integer> mapSeqToStruct) {
        ArrayList<String> alnSequences = new ArrayList<String>();
        for (int str = 0; str < alignment.size(); ++str) {
            alnSequences.add("");
        }
        mapSeqToStruct.clear();
        List<Atom[]> atoms = alignment.getEnsemble().getAtomArrays();
        int globalPos = -1;
        for (int b = 0; b < alignment.getBlocks().size(); ++b) {
            if (b != 0) {
                for (int str = 0; str < alignment.size(); ++str) {
                    alnSequences.set(str, ((String)alnSequences.get(str)).concat("-"));
                }
                mapSeqToStruct.add(-1);
            }
            int[] previousPos = new int[alignment.size()];
            Arrays.fill(previousPos, -1);
            char[] provisionalChar = new char[alignment.size()];
            Arrays.fill(provisionalChar, '-');
            for (int pos = 0; pos < alignment.getBlocks().get(b).length(); ++pos) {
                ++globalPos;
                boolean gaps = true;
                while (gaps) {
                    int str;
                    gaps = false;
                    for (str = 0; str < alignment.size(); ++str) {
                        Integer residue;
                        if (previousPos[str] == -1) {
                            residue = alignment.getBlocks().get(b).getAlignRes().get(str).get(pos);
                            if (residue == null) {
                                provisionalChar[str] = 45;
                                continue;
                            }
                            provisionalChar[str] = StructureTools.get1LetterCode(atoms.get(str)[residue].getGroup().getPDBName()).charValue();
                            continue;
                        }
                        residue = alignment.getBlocks().get(b).getAlignRes().get(str).get(pos);
                        if (residue == null) {
                            provisionalChar[str] = 45;
                            continue;
                        }
                        if (previousPos[str] + 1 == residue) {
                            provisionalChar[str] = StructureTools.get1LetterCode(atoms.get(str)[residue].getGroup().getPDBName()).charValue();
                            continue;
                        }
                        provisionalChar[str] = 32;
                        gaps = true;
                    }
                    if (gaps) {
                        for (str = 0; str < alignment.size(); ++str) {
                            if (provisionalChar[str] != ' ') continue;
                            for (int str2 = 0; str2 < alignment.size(); ++str2) {
                                if (str == str2) {
                                    alnSequences.set(str2, ((String)alnSequences.get(str2)).concat("" + StructureTools.get1LetterCode(atoms.get(str2)[previousPos[str] + 1].getGroup().getPDBName())));
                                    continue;
                                }
                                alnSequences.set(str2, ((String)alnSequences.get(str2)).concat("-"));
                            }
                            mapSeqToStruct.add(-1);
                            int n = str;
                            previousPos[n] = previousPos[n] + 1;
                        }
                        continue;
                    }
                    for (str = 0; str < alignment.size(); ++str) {
                        alnSequences.set(str, ((String)alnSequences.get(str)).concat("" + provisionalChar[str]));
                        if (provisionalChar[str] == '-') continue;
                        previousPos[str] = alignment.getBlocks().get(b).getAlignRes().get(str).get(pos);
                    }
                    mapSeqToStruct.add(globalPos);
                }
            }
        }
        return alnSequences;
    }

    public static List<String> getBlockSequenceAlignment(MultipleAlignment alignment) {
        return MultipleAlignmentTools.getBlockSequenceAlignment(alignment, new ArrayList<Integer>());
    }

    public static Atom getAtomForSequencePosition(MultipleAlignment multAln, List<Integer> mapSeqToStruct, int structure, int sequencePos) {
        int seqPos = mapSeqToStruct.get(sequencePos);
        if (seqPos == -1) {
            return null;
        }
        Atom a = null;
        int sum = 0;
        block0: for (Block b : multAln.getBlocks()) {
            if (sum + b.length() <= seqPos) {
                sum += b.length();
                continue;
            }
            for (Integer p : b.getAlignRes().get(structure)) {
                if (sum == seqPos) {
                    if (p == null) break block0;
                    a = multAln.getEnsemble().getAtomArrays().get(structure)[p];
                    break block0;
                }
                ++sum;
            }
        }
        return a;
    }

    public static int getBlockForSequencePosition(MultipleAlignment multAln, List<Integer> mapSeqToStruct, int sequencePos) {
        int seqPos = mapSeqToStruct.get(sequencePos);
        if (seqPos == -1) {
            return -1;
        }
        int sum = 0;
        int block = 0;
        for (Block b : multAln.getBlocks()) {
            if (sum + b.length() > seqPos) break;
            sum += b.length();
            ++block;
        }
        return block;
    }

    public static Matrix getAverageResidueDistances(MultipleAlignment alignment) {
        return null;
    }
}

